<div class="wdash-stats-grid">
    @if($isLoading)
        @for($i = 0; $i < 7; $i++)
            <div class="wdash-stat-card">
                <div class="wdash-stat-icon" style="background: rgba(255,255,255,0.1);">
                    <i class="fas fa-spinner fa-spin" style="color: rgba(255,255,255,0.3);"></i>
                </div>
                <div class="wdash-stat-content">
                    <span class="wdash-stat-number" style="color: rgba(255,255,255,0.3);">—</span>
                    <span class="wdash-stat-label">Loading...</span>
                </div>
            </div>
        @endfor
    @else
        {{-- Styles --}}
        <div class="wdash-stat-card wdash-stat-styles">
            <div class="wdash-stat-icon">
                <i class="fas fa-palette"></i>
            </div>
            <div class="wdash-stat-content">
                <span class="wdash-stat-number">{{ number_format($totalStylesInSeason) }}</span>
                <span class="wdash-stat-label">Styles</span>
                <span class="wdash-stat-detail">{{ number_format($totalStylesInOrders) }} in orders</span>
            </div>
        </div>

        {{-- GMTs Shipped --}}
        <div class="wdash-stat-card wdash-stat-shipped">
            <div class="wdash-stat-icon">
                <i class="fas fa-shipping-fast"></i>
            </div>
            <div class="wdash-stat-content">
                <span class="wdash-stat-number">{{ number_format($totalQmtsShipped) }}</span>
                <span class="wdash-stat-label">GMTs Shipped</span>
                <span class="wdash-stat-detail">Total shipped</span>
            </div>
        </div>

        {{-- GMTs Remaining --}}
        <div class="wdash-stat-card wdash-stat-remaining">
            <div class="wdash-stat-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="wdash-stat-content">
                <span class="wdash-stat-number">{{ number_format($totalGmtsLeftToShip) }}</span>
                <span class="wdash-stat-label">GMTs Left</span>
                <span class="wdash-stat-detail">Remaining to ship</span>
            </div>
        </div>

        {{-- Value Shipped --}}
        <div class="wdash-stat-card wdash-stat-value">
            <div class="wdash-stat-icon">
                <i class="fas fa-pound-sign"></i>
            </div>
            <div class="wdash-stat-content">
                <span class="wdash-stat-number">£{{ number_format($totalValueShipped, 0) }}</span>
                <span class="wdash-stat-label">Value Shipped</span>
                <span class="wdash-stat-detail">of £{{ number_format($totalValueOrdered, 0) }}</span>
            </div>
        </div>

        {{-- Margin --}}
        <div class="wdash-stat-card wdash-stat-margin">
            <div class="wdash-stat-icon">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="wdash-stat-content">
                <span class="wdash-stat-number">{{ number_format($averageMargin, 1) }}%</span>
                <span class="wdash-stat-label">Avg Margin</span>
                <span class="wdash-stat-detail">Wholesale only</span>
            </div>
        </div>

        {{-- Samples Sent --}}
        <div class="wdash-stat-card wdash-stat-samples">
            <div class="wdash-stat-icon">
                <i class="fas fa-tshirt"></i>
            </div>
            <div class="wdash-stat-content">
                <span class="wdash-stat-number">{{ number_format($totalSamplesSent) }}</span>
                <span class="wdash-stat-label">Samples Sent</span>
                <span class="wdash-stat-detail">Total samples</span>
            </div>
        </div>

        {{-- Invoices Sent --}}
        <div class="wdash-stat-card wdash-stat-invoices">
            <div class="wdash-stat-icon">
                <i class="fas fa-file-invoice"></i>
            </div>
            <div class="wdash-stat-content">
                <span class="wdash-stat-number">{{ number_format($totalInvoicesSent) }}</span>
                <span class="wdash-stat-label">Invoices Sent</span>
                <span class="wdash-stat-detail">Total invoices</span>
            </div>
        </div>
    @endif
</div>
