<div class="wdash-hero">
    <div class="wdash-hero-content">
        <div class="wdash-hero-left">
            <h1 class="wdash-title">Wholesale Dashboard</h1>
            <p class="wdash-subtitle">{{ $seasons->firstWhere('id', $selectedSeason)?->description ?? 'All Seasons' }} Overview</p>
        </div>
        <div class="wdash-quick-actions">
            {{-- Season Filter --}}
            <div class="wdash-filter-group">
                <select wire:model.live="selectedSeason" class="wdash-filter-select" wire:loading.attr="disabled">
                    @foreach($seasons as $season)
                        <option value="{{ $season->id }}">{{ $season->description }}</option>
                    @endforeach
                </select>
            </div>
            
            {{-- Refresh Button --}}
            <button wire:click="refreshDashboard" class="wdash-action-btn" wire:loading.attr="disabled" title="Clear cache and refresh all data">
                <i class="fas fa-sync-alt" wire:loading.class="fa-spin"></i>
                <span>Refresh</span>
            </button>
        </div>
    </div>
</div>
