<div>
    <div class="wdash-card-header">
        <h3><i class="fas fa-chart-line"></i> Customer Sales Progress</h3>
        <span class="wdash-badge wdash-badge-muted">
            {{ $seasons->where('id', $selectedSeason)->first()?->description ?? '' }}
        </span>
    </div>

    @if($isLoading)
        <div class="wdash-card-body" style="min-height: 400px;">
            <div class="wdash-empty">
                <i class="fas fa-spinner fa-spin"></i> Loading sales data...
            </div>
        </div>
    @elseif(empty($salesData))
        <div class="wdash-card-body" style="min-height: 200px;">
            <div class="wdash-empty">
                <i class="fas fa-chart-bar"></i><br>
                No sales data for selected filters
            </div>
        </div>
    @else
        {{-- Summary Stats --}}
        <div class="wdash-inner-stats">
            <div class="wdash-inner-stat">
                <div class="wdash-inner-stat-icon wdash-inner-stat-icon-success">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="wdash-inner-stat-content">
                    <span class="wdash-inner-stat-value">£{{ number_format($totalSales, 0) }}</span>
                    <span class="wdash-inner-stat-label">Shipped</span>
                </div>
            </div>
            <div class="wdash-inner-stat">
                <div class="wdash-inner-stat-icon wdash-inner-stat-icon-warning">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="wdash-inner-stat-content">
                    <span class="wdash-inner-stat-value">£{{ number_format(array_sum(array_column($salesData, 'remaining_sales')), 0) }}</span>
                    <span class="wdash-inner-stat-label">Remaining</span>
                </div>
            </div>
            <div class="wdash-inner-stat">
                <div class="wdash-inner-stat-icon wdash-inner-stat-icon-info">
                    <i class="fas fa-users"></i>
                </div>
                <div class="wdash-inner-stat-content">
                    <span class="wdash-inner-stat-value">{{ count($salesData) }}</span>
                    <span class="wdash-inner-stat-label">Customers</span>
                </div>
            </div>
            <div class="wdash-inner-stat">
                <div class="wdash-inner-stat-icon wdash-inner-stat-icon-primary">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="wdash-inner-stat-content">
                    <span class="wdash-inner-stat-value">{{ number_format(array_sum(array_column($salesData, 'shipping_percentage')) / count($salesData), 0) }}%</span>
                    <span class="wdash-inner-stat-label">Avg Progress</span>
                </div>
            </div>
        </div>

        {{-- Customer Table --}}
        <div class="wdash-card-body wdash-card-body-flush" style="max-height: 400px; overflow-y: auto;">
            <table class="wdash-table">
                <thead>
                    <tr>
                        <th>Customer</th>
                        <th class="text-end">Shipped</th>
                        <th class="text-end">Remaining</th>
                        <th class="text-center">Margin</th>
                        <th class="text-center">Progress</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($salesData as $customerId => $data)
                        @php
                            $shippingPercentage = $data['shipping_percentage'] ?? 0;
                        @endphp
                        <tr>
                            <td>
                                <div style="display: flex; align-items: center; gap: 0.75rem;">
                                    <div style="width: 28px; height: 28px; border-radius: 8px; background: linear-gradient(135deg, #38bdf8 0%, #0284c7 100%); display: flex; align-items: center; justify-content: center; font-size: 0.7rem; font-weight: 600; color: #0c1929; flex-shrink: 0;">
                                        {{ substr($data['name'], 0, 1) }}
                                    </div>
                                    <div>
                                        <div style="font-weight: 500; color: #fff;">{{ Str::limit($data['name'], 25) }}</div>
                                        <div class="wdash-badge wdash-badge-muted" style="font-size: 0.65rem; padding: 0.125rem 0.375rem;">{{ $data['department'] }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-end">
                                <span style="font-weight: 600; color: #34d399;">£{{ number_format($data['shipped_sales'] ?? 0, 0) }}</span>
                            </td>
                            <td class="text-end">
                                <span style="font-weight: 600; color: #fbbf24;">£{{ number_format($data['remaining_sales'] ?? 0, 0) }}</span>
                            </td>
                            <td class="text-center">
                                @if(isset($data['avg_margin']) && $data['avg_margin'] > 0)
                                    <span style="font-weight: 600; color: #a78bfa;">{{ number_format($data['avg_margin'], 1) }}%</span>
                                @else
                                    <span style="color: rgba(255,255,255,0.3);">—</span>
                                @endif
                            </td>
                            <td class="text-center" style="min-width: 120px;">
                                <div style="font-weight: 500; color: rgba(255,255,255,0.6); margin-bottom: 0.375rem; font-size: 0.8rem;">{{ number_format($shippingPercentage, 0) }}%</div>
                                <div class="wdash-progress" style="margin-bottom: 0.25rem;">
                                    <div class="wdash-progress-bar wdash-progress-success" style="width: {{ $shippingPercentage }}%;"></div>
                                </div>
                                <div style="font-size: 0.7rem; color: rgba(255,255,255,0.4);">{{ number_format($data['shipped_drops'] ?? 0) }}/{{ number_format($data['total_drops'] ?? 0) }} drops</div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>
