<div>
    <div class="row mb-2">
        <div class="col text-end">
            <div class="input-group">
                <select class="form-select @error('department') bg-red @enderror" wire:model.live="department">
                    <option value="">Department...</option>
                    @foreach($this->departments ?? [] as $department)
                        <option value="{{$department->id}}">{{$department->description}}</option>
                    @endforeach
                </select>
                <select class="form-select @error('season') bg-red @enderror" wire:model.live="season">
                    <option value=""></option>
                    @foreach($this->seasons ?? [] as $season)
                        <option value="{{$season->id}}">{{$season->description}}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table">
            <thead>
                <th>Customer</th>
                <th>Qty</th>
                <th>Revenue</th>
                <th>Commission</th>
            </thead>
            <tbody>
                @foreach($data as $line)
                    <tr>
                        <td>{{$line->name}}</td>
                        <td>{{$line->qty}}</td>
                        <td>£{{number_format($line->revenue)}}</td>
                        <td>£{{number_format($line->commission)}}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot class="fw-bold">
                <td>Total</td>
                <td>{{$data->sum('qty')}}</td>
                <td>£{{number_format($data->sum('revenue'))}}</td>
                <td>£{{number_format($data->sum('commission'))}}</td>
            </tfoot>
        </table>
    </div>
</div>
