<div class="commission-styles">
    {{-- Header --}}
    <header class="comm-header">
        <div class="comm-header-content">
            <div class="comm-title-section">
                <div class="comm-stats">
                    <span class="comm-stat comm-stat-total" wire:loading.remove wire:target="search, season, customer, clearFilters">
                        <span class="comm-stat-value">{{ $totalCount }}</span>
                        <span class="comm-stat-label">Total</span>
                    </span>
                    <span class="comm-stat" wire:loading wire:target="search, season, customer, clearFilters">
                        <span class="spinner-border spinner-border-sm text-white"></span>
                    </span>
                </div>
            </div>
            
            {{-- Search --}}
            <div class="comm-search-section">
                <div class="comm-search-wrapper">
                    <i class="fas fa-search comm-search-icon"></i>
                    <input 
                        type="text" 
                        class="comm-search-input" 
                        placeholder="Search by RT code, reference, description..."
                        wire:model.live.debounce.300ms="search"
                    >
                    @if($search)
                        <button class="comm-search-clear" wire:click="$set('search', '')">
                            <i class="fas fa-times"></i>
                        </button>
                    @endif
                </div>
            </div>

            {{-- Action Buttons --}}
            <div class="comm-actions">
                <button class="comm-create-btn" style="background: rgba(255,255,255,0.15); color: #fff;" wire:click="$dispatch('open-quickadd')">
                    <i class="fas fa-bolt"></i>
                    <span>Quick Add</span>
                </button>
                <button class="comm-create-btn" wire:click="$dispatch('create-new-style')">
                    <i class="fas fa-plus"></i>
                    <span>New Style</span>
                </button>
            </div>
        </div>
    </header>

    {{-- Filters Bar --}}
    <div class="cfilter-bar" x-data="{ showFilters: true }">
        <div class="cfilter-content">
            {{-- Mobile Toggle --}}
            <button class="cfilter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="cfilter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="cfilter-items" :class="{ 'show': showFilters }">
                {{-- Season Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $season ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-snowflake cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($season)
                                {{ $this->seasons->firstWhere('id', $season)?->description ?? 'Season' }}
                            @else
                                All Seasons
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$season ? 'selected' : '' }}" 
                                wire:click="$set('season', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Seasons
                            @if(!$season)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    @foreach($this->seasons as $s)
                            <button class="cfilter-option {{ $season == $s->id ? 'selected' : '' }}" 
                                    wire:click="$set('season', '{{ $s->id }}')" @click="open = false">
                                <i class="fas fa-snowflake"></i>
                                {{ $s->description }}
                                @if($season == $s->id)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
                    @endforeach
                    </div>
                </div>

                {{-- Customer Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $customer ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($customer)
                                {{ $this->customers->firstWhere('id', $customer)?->name ?? 'Customer' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" @click.stop>
                        </div>
                        <div class="cfilter-options">
                            <button class="cfilter-option {{ !$customer ? 'selected' : '' }}" 
                                    x-show="!search || 'all customers'.includes(search.toLowerCase())"
                                    wire:click="$set('customer', '')" @click="open = false; search = ''">
                                <i class="fas fa-users"></i>
                                All Customers
                                @if(!$customer)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
                    @foreach($this->customers as $c)
                                <button class="cfilter-option {{ $customer == $c->id ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="$set('customer', '{{ $c->id }}')" @click="open = false; search = ''">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if($customer == $c->id)<i class="fas fa-check cfilter-check"></i>@endif
                                </button>
                    @endforeach
                        </div>
                    </div>
                </div>
            </div>
            
            {{-- Active Filters Summary & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="cfilter-active">
                    <span class="cfilter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="cfilter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Content --}}
    <div class="cs-content">
        {{-- Loading overlay - only for full reloads (filters/search), not for infinite scroll --}}
        <div class="cs-loading" wire:loading.delay wire:target="search, season, customer, clearFilters">
            <div class="cs-loading-spinner">
                <div class="spinner-border text-light" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>

        @if($this->styles->isEmpty())
            {{-- Empty State --}}
            <div class="cs-empty">
                <div class="cs-empty-icon">
                    <i class="fas fa-tshirt"></i>
                </div>
                <h3>No styles found</h3>
                <p>Try adjusting your search or filters</p>
                @if($this->activeFiltersCount > 0)
                    <button class="btn btn-commission mt-3" wire:click="clearFilters">
                        Clear all filters
                    </button>
                @endif
            </div>
        @else
            {{-- Grid --}}
            <div class="cs-grid" wire:ignore.self>
                @foreach($this->styles as $style)
                    <article class="cs-card" wire:key="style-{{ $style->id }}" wire:click="$dispatch('open-style-edit', { styleId: {{ $style->id }} })">
                        {{-- Image --}}
                        <div class="cs-card-image">
                            @if($style->firstImageColourway && !empty($style->firstImageColourway->img_thumb))
                                <img 
                                    src="{{ asset('storage/' . $style->firstImageColourway->img_thumb) }}" 
                                    alt="{{ $style->designs?->description }}"
                                    loading="lazy"
                                >
                            @else
                                <div class="cs-card-no-image">
                                    <i class="fas fa-image"></i>
                                </div>
                            @endif
                            
                            {{-- Design Number Badge --}}
                            <span class="cs-card-rt-badge">
                                {{ $style->designs?->id }}
                            </span>
                        </div>
                        
                        {{-- Content --}}
                        <div class="cs-card-body">
                            {{-- Season Tag --}}
                            <div class="cs-card-season">
                                {{ $style->seasons?->description ?? 'No Season' }}
                            </div>
                            
                            {{-- Description --}}
                            <h3 class="cs-card-title" title="{{ $style->designs?->description }}">
                                {{ $style->designs?->description ?? 'No Description' }}
                            </h3>
                            
                            {{-- Customer --}}
                            <div class="cs-card-customer">
                                <i class="fas fa-building"></i>
                                {{ $style->customers?->name ?? 'No Customer' }}
                            </div>
                            
                            {{-- Reference --}}
                            @if($style->customer_ref)
                                <div class="cs-card-ref">
                                    <span class="cs-card-ref-label">Ref:</span>
                                    <span class="cs-card-ref-value">{{ $style->customer_ref }}</span>
                                </div>
                            @endif
                        </div>
                    </article>
                @endforeach
            </div>

            {{-- Infinite Scroll Trigger --}}
            @if($this->hasMorePages())
                <div class="cs-infinite-scroll-trigger"
                     x-data="{ loading: false }"
                     x-init="
                        $nextTick(() => {
                            const content = document.querySelector('.cs-content');
                            if (content && content.scrollHeight <= content.clientHeight) {
                                loading = true;
                                $wire.loadMore().then(() => { loading = false; });
                            }
                        });
                     ">
                    {{-- Early prefetch sentinel - triggers before user reaches bottom --}}
                    <div x-intersect="
                            if (!loading) {
                                loading = true;
                                $wire.loadMore().then(() => { loading = false; });
                            }
                         "
                         style="transform: translateY(-50vh); height: 1px; pointer-events: none;"></div>
                    
                    {{-- Visible loader --}}
                    <div x-intersect="
                            if (!loading) {
                                loading = true;
                                $wire.loadMore().then(() => { loading = false; });
                            }
                         ">
                        <div class="cs-load-more" x-show="!loading">
                            <span class="cs-load-more-text">Scroll for more</span>
                        </div>
                        <div class="cs-load-more cs-load-more-loading" x-show="loading" x-cloak>
                            <span class="spinner-border spinner-border-sm"></span>
                            <span class="cs-load-more-text">Loading more styles...</span>
                        </div>
                    </div>
                </div>
            @else
                @if($this->styles->count() > 0)
                    <div class="cs-end-of-list">
                        <span>Showing all {{ $totalCount }} styles</span>
                    </div>
                @endif
            @endif
        @endif
    </div>

    {{-- Style Edit Panel --}}
    @livewire('commission.style-edit')
    
    {{-- Quick Add Panel --}}
    @livewire('commission.styles-quick-add')
</div>

