<div x-data="{ }" x-on:keydown.escape.window="if ($wire.isOpen) $wire.close()">
    
    {{-- Backdrop --}}
    @if($isOpen)
        <div class="cqa-backdrop" wire:click="close"></div>
    @endif

    {{-- Modal Panel --}}
    <div class="cqa-panel {{ $isOpen ? 'open' : '' }}">
        @if($isOpen)
            {{-- Header --}}
            <header class="cqa-header">
                <div class="cqa-header-info">
                    <i class="fas fa-bolt"></i>
                    <h2>Quick Add</h2>
                    <span class="cqa-badge">{{ count($rows) }} row(s)</span>
                </div>
                <button class="cqa-close" wire:click="close">
                    <i class="fas fa-times"></i>
                </button>
            </header>

            {{-- Flash Messages --}}
            @if(session()->has('quickadd-error'))
                <div class="cqa-alert cqa-alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <div>{!! session('quickadd-error') !!}</div>
                </div>
            @endif

            {{-- Info Banner --}}
            <div class="cqa-info-banner">
                <i class="fas fa-info-circle"></i>
                <span>Create multiple <strong>Designs + Styles</strong> quickly. Department & Factory default to <strong>ERDOS</strong>.</span>
            </div>

            {{-- Content --}}
            <div class="cqa-content">
                <div class="cqa-rows">
                    @foreach($rows as $index => $row)
                        <div class="cqa-row" wire:key="row-{{ $index }}">
                            <div class="cqa-row-header">
                                <span class="cqa-row-number">{{ $index + 1 }}</span>
                                @if(count($rows) > 1)
                                    <button class="cqa-row-remove" wire:click="removeRow({{ $index }})" title="Remove row">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                @endif
                            </div>
                            
                            <div class="cqa-row-fields">
                                {{-- Description --}}
                                <div class="cqa-field cqa-field-full">
                                    <label>Description <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control" 
                                           wire:model="rows.{{ $index }}.description"
                                           placeholder="e.g. Cable Knit Jumper, Ribbed Cardigan...">
                                </div>

                                {{-- Season --}}
                                <div class="cqa-field">
                                    <label>Season <span class="text-danger">*</span></label>
                                    <select class="form-select" wire:model="rows.{{ $index }}.season_id">
                                        <option value="">Select</option>
                                        @foreach($this->seasons as $season)
                                            <option value="{{ $season->id }}">{{ $season->description }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- Customer --}}
                                <div class="cqa-field">
                                    <label>Customer <span class="text-danger">*</span></label>
                                    <select class="form-select" wire:model="rows.{{ $index }}.customer_id">
                                        <option value="">Select</option>
                                        @foreach($this->customers as $customer)
                                            <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- Category --}}
                                <div class="cqa-field">
                                    <label>Category <span class="text-danger">*</span></label>
                                    <select class="form-select" wire:model="rows.{{ $index }}.category">
                                        <option value="">Select</option>
                                        @foreach($this->categories as $value => $label)
                                            <option value="{{ $value }}">{{ $label }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- Customer Ref --}}
                                <div class="cqa-field">
                                    <label>Customer Ref <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control" 
                                           wire:model="rows.{{ $index }}.customer_ref"
                                           placeholder="Customer's style code">
                                </div>

                                {{-- Colourways --}}
                                <div class="cqa-field cqa-field-wide">
                                    <label>Colourways <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control" 
                                           wire:model="rows.{{ $index }}.colourways"
                                           placeholder="e.g. Navy, Cream, Grey (comma separated)">
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                {{-- Add Row Button --}}
                <button class="cqa-add-row" wire:click="addRow">
                    <i class="fas fa-plus"></i>
                    Add Another Row
                </button>
            </div>

            {{-- Footer --}}
            <footer class="cqa-footer">
                <button class="cqa-btn cqa-btn-secondary" wire:click="close">
                    Close
                </button>
                <button class="cqa-btn cqa-btn-primary" wire:click="save">
                    <i class="fas fa-check"></i>
                    Create {{ count($rows) }} Style(s)
                </button>
            </footer>
        @endif
    </div>
</div>
