<div class="commission-styles-overview" 
     x-data="{ 
         init() {
             this.setupInfiniteScroll();
         },
         setupInfiniteScroll() {
             const container = this.$refs.scrollContainer;
             if (!container) return;
             
             container.addEventListener('scroll', () => {
                 if (container.scrollTop + container.clientHeight >= container.scrollHeight - 200) {
                     if ($wire.hasMore && !$wire.isLoading) {
                         $wire.loadMore();
                     }
                 }
             });
         }
     }">

    {{-- Header --}}
    <x-commission.page-header 
        title="Styles Overview"
        :stats="[
            ['label' => 'Total', 'value' => $this->stats['total'], 'class' => 'total'],
            ['label' => 'Proto Approved', 'value' => $this->stats['proto'], 'class' => 'approved'],
            ['label' => 'Sealer Approved', 'value' => $this->stats['sealer'], 'class' => 'sealer'],
        ]"
        searchPlaceholder="Search by RT, description, colourway..."
        searchModel="search"
        :search="$search"
    />

    {{-- Filters Bar --}}
    <div class="cfilter-bar" x-data="{ showFilters: true }">
        <div class="cfilter-content">
            {{-- Mobile Toggle --}}
            <button class="cfilter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="cfilter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="cfilter-items" :class="{ 'show': showFilters }">
                {{-- Season Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $season ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-snowflake cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($season)
                                {{ $this->seasons->firstWhere('id', $season)?->description ?? 'Season' }}
                            @else
                                All Seasons
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$season ? 'selected' : '' }}" 
                                wire:click="$set('season', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Seasons
                            @if(!$season)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
            @foreach($this->seasons as $s)
                            <button class="cfilter-option {{ $season == $s->id ? 'selected' : '' }}" 
                                    wire:click="$set('season', '{{ $s->id }}')" @click="open = false">
                                <i class="fas fa-snowflake"></i>
                                {{ $s->description }}
                                @if($season == $s->id)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
            @endforeach
                    </div>
                </div>

                {{-- Customer Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $customer ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($customer)
                                {{ $this->customers->firstWhere('id', $customer)?->name ?? 'Customer' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" @click.stop>
                        </div>
                        <div class="cfilter-options">
                            <button class="cfilter-option {{ !$customer ? 'selected' : '' }}" 
                                    x-show="!search || 'all customers'.includes(search.toLowerCase())"
                                    wire:click="$set('customer', '')" @click="open = false; search = ''">
                                <i class="fas fa-users"></i>
                                All Customers
                                @if(!$customer)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
            @foreach($this->customers as $c)
                                <button class="cfilter-option {{ $customer == $c->id ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="$set('customer', '{{ $c->id }}')" @click="open = false; search = ''">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if($customer == $c->id)<i class="fas fa-check cfilter-check"></i>@endif
                                </button>
            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Status Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $status ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-check-circle cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($status === 'proto_pending')
                                Proto Pending
                            @elseif($status === 'proto_approved')
                                Proto Approved
                            @elseif($status === 'sealer_approved')
                                Sealer Approved
                            @else
                                All Status
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$status ? 'selected' : '' }}" 
                                wire:click="$set('status', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Status
                            @if(!$status)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'proto_pending' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'proto_pending')" @click="open = false">
                            <i class="fas fa-clock"></i>
                            Proto Pending
                            @if($status === 'proto_pending')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'proto_approved' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'proto_approved')" @click="open = false">
                            <i class="fas fa-check"></i>
                            Proto Approved
                            @if($status === 'proto_approved')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'sealer_approved' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'sealer_approved')" @click="open = false">
                            <i class="fas fa-check-double"></i>
                            Sealer Approved
                            @if($status === 'sealer_approved')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    </div>
                </div>
            </div>

            {{-- Active Filters Summary & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="cfilter-active">
                    <span class="cfilter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="cfilter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                    </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Content --}}
    <div class="csamp-content" x-ref="scrollContainer">
        @if(empty($loadedItems))
            {{-- Empty State --}}
            <div class="csamp-empty">
                <div class="csamp-empty-icon">
                    <i class="fas fa-th-large"></i>
                </div>
                <h3>No styles found</h3>
                <p>Try adjusting your search or filters</p>
                @if($this->activeFiltersCount > 0)
                    <button class="btn btn-commission mt-3" wire:click="clearFilters">
                        Clear all filters
                    </button>
                @endif
            </div>
        @else
            {{-- Table --}}
            <div class="csamp-table-container">
                <table class="csamp-table cso-table">
                    <thead>
                        <tr>
                            <th style="width: 80px;">Image</th>
                            <th class="csamp-th-sortable" wire:click="sort('rt')">
                                <span>RT</span>
                                @if($sortBy === 'rt')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="csamp-th-sortable" wire:click="sort('description')">
                                <span>Description</span>
                                @if($sortBy === 'description')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="csamp-th-sortable" wire:click="sort('customer')">
                                <span>Customer</span>
                                @if($sortBy === 'customer')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th>Season</th>
                            <th class="csamp-th-sortable" wire:click="sort('colourway')">
                                <span>Colourway</span>
                                @if($sortBy === 'colourway')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th>Composition</th>
                            <th style="min-width: 180px;">Comments</th>
                            <th class="text-center">Approval</th>
                            <th class="text-center">Proto</th>
                            <th class="text-center">Sealer</th>
                            <th class="text-center">Photo</th>
                            <th class="text-center">Shipment</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($loadedItems as $item)
                            <tr class="csamp-row" 
                                wire:key="overview-row-{{ $item['id'] }}"
                                wire:click="$dispatch('open-style-edit', { styleId: {{ $item['style_id'] }} })"
                                style="cursor: pointer;">
                                
                                {{-- Image --}}
                                <td class="cso-td-image">
                                    @if($item['image'])
                                        <img src="{{ asset('storage/' . $item['image']) }}" 
                                             alt="{{ $item['colourway_name'] }}"
                                             class="cso-thumb"
                                             loading="lazy">
                                    @else
                                        <div class="cso-no-image">
                                            <i class="fas fa-image"></i>
                                        </div>
                                    @endif
                                </td>
                                
                                {{-- RT --}}
                                <td>
                                    <span class="csamp-rt">{{ $item['design_id'] }}</span>
                                </td>
                                
                                {{-- Description --}}
                                <td>
                                    <div class="csamp-style-info">
                                        <span class="csamp-desc">{{ Str::limit($item['design_description'], 30) }}</span>
                                    </div>
                                    @if($item['customer_ref'])
                                        <div class="csamp-style-meta">
                                            <span class="csamp-customer">{{ $item['customer_ref'] }}</span>
                                        </div>
                                    @endif
                                </td>
                                
                                {{-- Customer --}}
                                <td>
                                    <span class="csamp-desc">{{ $item['customer_name'] }}</span>
                                </td>
                                
                                {{-- Season --}}
                                <td>
                                    <span class="csamp-type-badge">{{ $item['season_description'] }}</span>
                                </td>
                                
                                {{-- Colourway --}}
                                <td>
                                    <div class="csamp-style-info">
                                        <span class="csamp-colourway-name">{{ $item['colourway_name'] }}</span>
                                    </div>
                                    @if($item['version_name'])
                                        <div class="csamp-style-meta">
                                            <span class="csamp-season">Version: {{ $item['version_name'] }}</span>
                                        </div>
                                    @endif
                                </td>
                                
                                {{-- Composition --}}
                                <td>
                                    @if($item['composition'])
                                        <span class="cso-composition" title="{{ $item['composition'] }}">
                                            {{ Str::limit($item['composition'], 25) }}
                                        </span>
                                    @else
                                        <span class="csamp-date-empty">—</span>
                                    @endif
                                </td>
                                
                                {{-- Comments (Editable) --}}
                                <td class="cso-comments-td" wire:click.stop>
                                    @if($editingCommentId === $item['id'])
                                        <div class="cso-comment-edit">
                                            <textarea 
                                                class="cso-comment-input"
                                                wire:model="editingCommentValue"
                                                rows="2"
                                                placeholder="Add comment..."
                                                wire:keydown.escape="cancelEditingComment"
                                                x-data
                                                x-init="$el.focus()"
                                            ></textarea>
                                            <div class="cso-comment-actions">
                                                <button type="button" class="cso-comment-btn cso-comment-save" wire:click="saveComment" title="Save">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                                <button type="button" class="cso-comment-btn cso-comment-cancel" wire:click="cancelEditingComment" title="Cancel">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                    @else
                                        <div class="cso-comment-display" 
                                             wire:click="startEditingComment({{ $item['id'] }}, {{ json_encode($item['comments'] ?? '') }})"
                                             title="Click to edit">
                                            @if($item['comments'])
                                                <span class="cso-comment-text">{{ Str::limit($item['comments'], 50) }}</span>
                                            @else
                                                <span class="cso-comment-placeholder">
                                                    <i class="fas fa-plus-circle"></i> Add
                                                </span>
                                            @endif
                                        </div>
                                    @endif
                                </td>
                                
                                {{-- Approval Date --}}
                                <td class="cso-approval-td">
                                    @php
                                        $protoApproved = collect($item['proto_samples'])->firstWhere('status', 'approved');
                                        $sealerApproved = collect($item['sealer_samples'])->firstWhere('status', 'approved');
                                    @endphp
                                    <div class="cso-approval-dates">
                                        @if($protoApproved && $protoApproved['approved_date'])
                                            <div class="cso-approval-item cso-proto-date" title="Proto Approved">
                                                <span class="cso-approval-label">P</span>
                                                <span class="cso-approval-value">{{ \Carbon\Carbon::parse($protoApproved['approved_date'])->format('d M') }}</span>
                                            </div>
                                        @endif
                                        @if($sealerApproved && $sealerApproved['approved_date'])
                                            <div class="cso-approval-item cso-sealer-date" title="Sealer Approved">
                                                <span class="cso-approval-label">S</span>
                                                <span class="cso-approval-value">{{ \Carbon\Carbon::parse($sealerApproved['approved_date'])->format('d M') }}</span>
                                            </div>
                                        @endif
                                        @if((!$protoApproved || !$protoApproved['approved_date']) && (!$sealerApproved || !$sealerApproved['approved_date']))
                                            <span class="csamp-date-empty">—</span>
                                        @endif
                                    </div>
                                </td>
                                
                                {{-- Proto Status --}}
                                <td class="cso-sample-td" wire:click.stop>
                                    <div class="cso-samples-group">
                                        @forelse($item['proto_samples'] as $idx => $sample)
                                            <x-commission.sample-tile 
                                                :sample="$sample" 
                                                :colourwayId="$item['id']" 
                                                :type="1" 
                                                typeName="Proto"
                                            />
                                        @empty
                                            <x-commission.sample-tile 
                                                :sample="null" 
                                                :colourwayId="$item['id']" 
                                                :type="1" 
                                                typeName="Proto"
                                                :sampleRequired="$item['proto_required']"
                                            />
                                        @endforelse
                                        @if(count($item['proto_samples']) > 0 && count($item['proto_samples']) < 3)
                                            @can('style:update')
                                                <button class="cso-sample-add" wire:click="quickAddSample({{ $item['id'] }}, 1)" title="Add Proto">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            @endcan
                                        @endif
                                    </div>
                                </td>
                                
                                {{-- Sealer Status --}}
                                <td class="cso-sample-td" wire:click.stop>
                                    <div class="cso-samples-group">
                                        @forelse($item['sealer_samples'] as $idx => $sample)
                                            <x-commission.sample-tile 
                                                :sample="$sample" 
                                                :colourwayId="$item['id']" 
                                                :type="3" 
                                                typeName="Sealer"
                                            />
                                        @empty
                                            <x-commission.sample-tile 
                                                :sample="null" 
                                                :colourwayId="$item['id']" 
                                                :type="3" 
                                                typeName="Sealer"
                                                :sampleRequired="$item['sealer_required']"
                                            />
                                        @endforelse
                                        @if(count($item['sealer_samples']) > 0 && count($item['sealer_samples']) < 3)
                                            @can('style:update')
                                                <button class="cso-sample-add" wire:click="quickAddSample({{ $item['id'] }}, 3)" title="Add Sealer">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            @endcan
                                        @endif
                                    </div>
                                </td>
                                
                                {{-- Photo Status --}}
                                <td class="cso-sample-td" wire:click.stop>
                                    <div class="cso-samples-group">
                                        @forelse($item['photo_samples'] as $idx => $sample)
                                            <x-commission.sample-tile 
                                                :sample="$sample" 
                                                :colourwayId="$item['id']" 
                                                :type="6" 
                                                typeName="Photo"
                                            />
                                        @empty
                                            <x-commission.sample-tile 
                                                :sample="null" 
                                                :colourwayId="$item['id']" 
                                                :type="6" 
                                                typeName="Photo"
                                                :sampleRequired="$item['photo_required']"
                                            />
                                        @endforelse
                                        @if(count($item['photo_samples']) > 0 && count($item['photo_samples']) < 3)
                                            @can('style:update')
                                                <button class="cso-sample-add" wire:click="quickAddSample({{ $item['id'] }}, 6)" title="Add Photo">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            @endcan
                                        @endif
                                    </div>
                                </td>
                                
                                {{-- Shipment Status --}}
                                <td class="cso-sample-td" wire:click.stop>
                                    <div class="cso-samples-group">
                                        @forelse($item['shipment_samples'] as $idx => $sample)
                                            <x-commission.sample-tile 
                                                :sample="$sample" 
                                                :colourwayId="$item['id']" 
                                                :type="7" 
                                                typeName="Shipment"
                                            />
                                        @empty
                                            <x-commission.sample-tile 
                                                :sample="null" 
                                                :colourwayId="$item['id']" 
                                                :type="7" 
                                                typeName="Shipment"
                                                :sampleRequired="$item['shipment_required']"
                                            />
                                        @endforelse
                                        @if(count($item['shipment_samples']) > 0 && count($item['shipment_samples']) < 3)
                                            @can('style:update')
                                                <button class="cso-sample-add" wire:click="quickAddSample({{ $item['id'] }}, 7)" title="Add Shipment">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            @endcan
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Loading More Indicator --}}
            @if($hasMore)
                <div class="csamp-load-more" wire:loading.remove wire:target="loadMore">
                    <div class="csamp-load-more-trigger" x-intersect="$wire.loadMore()">
                        <i class="fas fa-circle-notch fa-spin"></i>
                        <span>Loading more...</span>
                    </div>
                </div>
            @else
                <div class="csamp-end-of-list">
                    <span>{{ count($loadedItems) }} styles loaded</span>
                </div>
            @endif

            {{-- Loading indicator when fetching more --}}
            <div class="csamp-load-more" wire:loading wire:target="loadMore">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>Loading more...</span>
            </div>
        @endif
    </div>

    {{-- Style Edit Sidebar (reuse from styles page) --}}
    @livewire('commission.style-edit')
    
    {{-- Sample Edit Sidebar --}}
    @livewire('commission.sample-edit')
</div>

