<div x-data="{ showConfirm: false }" 
     x-on:confirm-close.window="showConfirm = true"
     x-on:keydown.escape.window="if ($wire.isOpen) $wire.confirmClose()">
    
    {{-- Backdrop --}}
    @if($isOpen)
        <div class="cse-backdrop" wire:click="confirmClose"></div>
    @endif

    {{-- Unsaved Changes Confirmation --}}
    <div class="cse-confirm-modal" x-show="showConfirm" x-cloak>
        <div class="cse-confirm-backdrop" @click="showConfirm = false"></div>
        <div class="cse-confirm-dialog">
            <div class="cse-confirm-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h3>Unsaved Changes</h3>
            <p>You have unsaved changes. Are you sure you want to close?</p>
            <div class="cse-confirm-actions">
                <button class="cse-btn cse-btn-secondary" @click="showConfirm = false">
                    Keep Editing
                </button>
                <button class="cse-btn cse-btn-danger" @click="showConfirm = false; $wire.close()">
                    Discard Changes
                </button>
            </div>
        </div>
    </div>

    {{-- Duplicate Confirmation --}}
    @if($showDuplicateConfirm)
        <div class="cse-confirm-modal">
            <div class="cse-confirm-backdrop" wire:click="cancelDuplicateSave"></div>
            <div class="cse-confirm-dialog cse-confirm-duplicate">
                <div class="cse-confirm-icon cse-confirm-icon-warning">
                    <i class="fas fa-copy"></i>
                </div>
                <h3>Potential Duplicates Found</h3>
                <p>Similar designs already exist. Are you sure you want to create a new one?</p>
                
                <div class="cse-duplicate-list">
                    @foreach($similarDesigns as $match)
                        <div class="cse-duplicate-item">
                            <span class="cse-similar-id">RT{{ $match['id'] }}</span>
                            <span class="cse-similar-desc">{{ $match['description'] }}</span>
                            @if(!empty($match['reason']))
                                <span class="cse-similar-reason">{{ $match['reason'] }}</span>
                            @endif
                        </div>
                    @endforeach
                </div>
                
                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="cancelDuplicateSave">
                        <i class="fas fa-arrow-left"></i> Go Back
                    </button>
                    <button class="cse-btn cse-btn-primary" wire:click="confirmSaveWithDuplicates">
                        <i class="fas fa-plus"></i> Create Anyway
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Slide Panel --}}
    <div class="cse-panel {{ $isOpen ? 'open' : '' }}">
        @if($isOpen && ($this->style || $isNewStyle))
            {{-- Header --}}
            <header class="cse-header">
                <div class="cse-header-info">
                    @if($isNewStyle)
                        <span class="cse-badge cse-badge-new"><i class="fas fa-plus"></i></span>
                        <h2 class="cse-title">New Style</h2>
                    @else
                        <span class="cse-badge">{{ $design_id }}</span>
                        <h2 class="cse-title">{{ $design_description }}</h2>
                    @endif
                    @if($isDirty)
                        <span class="cse-dirty-badge">Unsaved</span>
                    @endif
                </div>
                <button class="cse-close" wire:click="confirmClose">
                    <i class="fas fa-times"></i>
                </button>
            </header>

            {{-- Toast Notifications --}}
            @if(session()->has('message'))
                <div class="cse-toast cse-toast-success" 
                     x-data="{ show: true }" 
                     x-show="show" 
                     x-init="setTimeout(() => show = false, 3000)"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0">
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('message') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif
            @if(session()->has('error'))
                <div class="cse-toast cse-toast-error"
                     x-data="{ show: true }" 
                     x-show="show"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0">
                    <i class="fas fa-exclamation-circle"></i>
                    <span>{{ session('error') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif

            {{-- Tabs --}}
            @if(!$isNewStyle)
                <nav class="cse-tabs">
                    <button 
                        class="cse-tab {{ $activeTab === 'details' ? 'active' : '' }}"
                        wire:click="$set('activeTab', 'details')"
                    >
                        <i class="fas fa-info-circle"></i>
                        Details
                    </button>
                    <button 
                        class="cse-tab {{ $activeTab === 'colourways' ? 'active' : '' }}"
                        wire:click="$set('activeTab', 'colourways')"
                    >
                        <i class="fas fa-palette"></i>
                        Colourways
                    </button>
                    <button 
                        class="cse-tab {{ $activeTab === 'history' ? 'active' : '' }}"
                        wire:click="$set('activeTab', 'history')"
                    >
                        <i class="fas fa-history"></i>
                        History
                    </button>
                </nav>

                {{-- Persistent Version Selector Bar --}}
                @if($this->style && $this->style->style_versions->count() > 0)
                    <div class="cse-version-bar">
                        <span class="cse-version-bar-label">
                            <i class="fas fa-layer-group"></i>
                            Version:
                        </span>
                        <div class="cse-version-bar-pills">
                            @foreach($this->style->style_versions as $version)
                                <button 
                                    class="cse-version-pill {{ $activeVersionId === $version->id ? 'active' : '' }}"
                                    wire:click="selectVersion({{ $version->id }})"
                                    wire:key="version-bar-{{ $version->id }}"
                                    title="{{ $version->factories?->name ?? 'No factory' }}"
                                >
                                    <span class="cse-version-pill-name">{{ $version->name ?: 'V' . $loop->iteration }}</span>
                                    @if($version->factories)
                                        <span class="cse-version-pill-factory">{{ Str::limit($version->factories->name, 10) }}</span>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                        @if($activeTab !== 'details')
                            <button class="cse-version-bar-add" wire:click="addVersion" title="Add Version">
                                <i class="fas fa-plus"></i>
                            </button>
                        @endif
                    </div>
                @endif
            @endif

            {{-- Content --}}
            <div class="cse-content">
                @if($isNewStyle)
                    {{-- New Style Form --}}
                    <div class="cse-new-style-warning">
                        <div class="cse-warning-icon">
                            <i class="fas fa-exclamation-circle"></i>
                        </div>
                        <div class="cse-warning-content">
                            <strong>Creating a new Design & Style</strong>
                            <p>This will create a new Design (RT number). If a design already exists for this product, find it in the list and create a style from there to avoid duplication.</p>
                        </div>
                    </div>

                    <div class="cse-section">
                        <h3 class="cse-section-title">New Style Details</h3>
                        
                        {{-- Validation Errors Summary --}}
                        @if($errors->any())
                            <div class="alert alert-danger mb-3">
                                <strong><i class="fas fa-exclamation-triangle me-2"></i>Please fix the following errors:</strong>
                                <ul class="mb-0 mt-2">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <div class="cse-field cse-field-full">
                            <label class="cse-label">Design Description <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control {{ $errors->has('new_design_description') ? 'is-invalid border-danger' : '' }}" 
                                   wire:model="new_design_description" 
                                   placeholder="e.g. Cable Knit Jumper, Ribbed Cardigan..." 
                                   maxlength="255">
                            @error('new_design_description') 
                                <div class="text-danger small mt-1">{{ $message }}</div> 
                            @enderror
                        </div>

                        <div class="cse-grid">
                            <div class="cse-field">
                                <label class="cse-label">Season <span class="text-danger">*</span></label>
                                <select class="form-select {{ $errors->has('seasons_id') ? 'is-invalid border-danger' : '' }}" 
                                        wire:model="seasons_id">
                                    <option value="">Select Season</option>
                                    @foreach($this->seasons as $season)
                                        <option value="{{ $season->id }}">{{ $season->description }}</option>
                                    @endforeach
                                </select>
                                @error('seasons_id') 
                                    <div class="text-danger small mt-1">{{ $message }}</div> 
                                @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Customer <span class="text-danger">*</span></label>
                                <select class="form-select {{ $errors->has('customers_id') ? 'is-invalid border-danger' : '' }}" 
                                        wire:model="customers_id">
                                    <option value="">Select Customer</option>
                                    @foreach($this->customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                                @error('customers_id') 
                                    <div class="text-danger small mt-1">{{ $message }}</div> 
                                @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Department <span class="text-danger">*</span></label>
                                <select class="form-select {{ $errors->has('departments_id') ? 'is-invalid border-danger' : '' }}" 
                                        wire:model="departments_id">
                                    <option value="">Select Department</option>
                                    @foreach($this->departments as $dept)
                                        <option value="{{ $dept->id }}">{{ $dept->description }}</option>
                                    @endforeach
                                </select>
                                @error('departments_id') 
                                    <div class="text-danger small mt-1">{{ $message }}</div> 
                                @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Factory <span class="text-danger">*</span></label>
                                <select class="form-select {{ $errors->has('factory_id') ? 'is-invalid border-danger' : '' }}" 
                                        wire:model="factory_id">
                                    <option value="">Select Factory</option>
                                    @foreach($this->factories as $factory)
                                        <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                    @endforeach
                                </select>
                                @error('factory_id') 
                                    <div class="text-danger small mt-1">{{ $message }}</div> 
                                @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Customer Reference <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control {{ $errors->has('customer_ref') ? 'is-invalid border-danger' : '' }}" 
                                       wire:model="customer_ref" 
                                       placeholder="Customer's style code" 
                                       maxlength="255">
                                @error('customer_ref') 
                                    <div class="text-danger small mt-1">{{ $message }}</div> 
                                @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Category <span class="text-danger">*</span></label>
                                <select class="form-select {{ $errors->has('category') ? 'is-invalid border-danger' : '' }}" 
                                        wire:model="category">
                                    <option value="">Select Category</option>
                                    @foreach($this->categories as $value => $label)
                                        <option value="{{ $value }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                                @error('category') 
                                    <div class="text-danger small mt-1">{{ $message }}</div> 
                                @enderror
                            </div>
                        </div>

                        <div class="cse-field cse-field-full">
                            <label class="cse-label">Notes</label>
                            <textarea class="form-control {{ $errors->has('notes') ? 'is-invalid border-danger' : '' }}" 
                                      wire:model="notes" 
                                      rows="3" 
                                      placeholder="Internal notes..." 
                                      maxlength="5000"></textarea>
                            @error('notes') 
                                <div class="text-danger small mt-1">{{ $message }}</div> 
                            @enderror
                        </div>
                    </div>

                @elseif($activeTab === 'details')
                    {{-- Details Tab --}}
                    <div class="cse-section">
                        <h3 class="cse-section-title">Style Information</h3>
                        
                        <div class="cse-grid">
                            <div class="cse-field">
                                <label class="cse-label">Season <span class="text-danger">*</span></label>
                                <select class="form-select @error('seasons_id') is-invalid @enderror" wire:model="seasons_id">
                                    <option value="">Select Season</option>
                                    @foreach($this->seasons as $season)
                                        <option value="{{ $season->id }}">{{ $season->description }}</option>
                                    @endforeach
                                </select>
                                @error('seasons_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Customer <span class="text-danger">*</span></label>
                                <select class="form-select @error('customers_id') is-invalid @enderror" wire:model="customers_id">
                                    <option value="">Select Customer</option>
                                    @foreach($this->customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                                @error('customers_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Department</label>
                                <select class="form-select @error('departments_id') is-invalid @enderror" wire:model="departments_id">
                                    <option value="">Select Department</option>
                                    @foreach($this->departments as $dept)
                                        <option value="{{ $dept->id }}">{{ $dept->description }}</option>
                                    @endforeach
                                </select>
                                @error('departments_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Category</label>
                                <input type="text" class="form-control @error('category') is-invalid @enderror" wire:model="category" placeholder="e.g. Jumper, Cardigan..." maxlength="255">
                                @error('category') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Customer Reference</label>
                                <input type="text" class="form-control @error('customer_ref') is-invalid @enderror" wire:model="customer_ref" placeholder="Customer's style code" maxlength="255">
                                @error('customer_ref') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">RT Number</label>
                                <input type="text" class="form-control" value="{{ $design_id }}" disabled>
                            </div>
                        </div>

                        <div class="cse-field cse-field-full">
                            <label class="cse-label">Description</label>
                            <input type="text" 
                                   class="form-control @error('design_description') is-invalid border-danger @enderror" 
                                   wire:model="design_description"
                                   maxlength="255">
                            @error('design_description') 
                                <div class="text-danger small mt-1">{{ $message }}</div> 
                            @enderror
                        </div>

                        <div class="cse-field cse-field-full">
                            <label class="cse-label">Notes</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" wire:model="notes" rows="3" placeholder="Internal notes..." maxlength="5000"></textarea>
                            @error('notes') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>

                        <div class="cse-field">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="cancelled" wire:model="cancelled">
                                <label class="form-check-label" for="cancelled">Style Cancelled</label>
                            </div>
                        </div>
                    </div>

                    {{-- Versions Section - Prominent Card Design --}}
                    <div class="cse-section cse-versions-section">
                        <div class="cse-section-header">
                            <h3 class="cse-section-title">
                                <i class="fas fa-layer-group"></i>
                                Versions
                            </h3>
                            <button class="cse-add-version-btn" wire:click="addVersion" title="Add New Version">
                                <i class="fas fa-plus"></i>
                                <span>Add Version</span>
                            </button>
                        </div>

                        <div class="cse-versions-grid">
                            @foreach($this->style->style_versions as $version)
                                <div class="cse-version-card {{ $activeVersionId === $version->id ? 'active' : '' }}"
                                     wire:click="selectVersion({{ $version->id }})"
                                     wire:key="version-{{ $version->id }}">
                                    <div class="cse-version-card-header">
                                        <span class="cse-version-name">{{ $version->name ?: 'Version ' . $loop->iteration }}</span>
                                        @if($activeVersionId === $version->id)
                                            <span class="cse-version-active-badge">
                                                <i class="fas fa-check"></i>
                                            </span>
                                        @endif
                                    </div>
                                    <div class="cse-version-card-body">
                                        <div class="cse-version-factory">
                                            <i class="fas fa-industry"></i>
                                            <span>{{ $version->factories?->name ?? 'No Factory' }}</span>
                                        </div>
                                        <div class="cse-version-colourways">
                                            <i class="fas fa-palette"></i>
                                            <span>{{ $version->colourways->count() }} {{ Str::plural('colourway', $version->colourways->count()) }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        {{-- Selected Version Editor --}}
                        @if($activeVersionId)
                            <div class="cse-version-editor">
                                <div class="cse-version-editor-header">
                                    <span class="cse-version-editing-label">
                                        <i class="fas fa-edit"></i>
                                        Editing: <strong>{{ $version_name ?: 'Version' }}</strong>
                                    </span>
                                    <div class="cse-version-actions">
                                        <button class="cse-version-action-btn" wire:click="cloneVersion" title="Clone Version">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                        @if($this->style->style_versions->count() > 1)
                                            <button class="cse-version-action-btn cse-version-action-danger" 
                                                    wire:click="deleteVersion" 
                                                    wire:confirm="Delete this version and all its colourways?"
                                                    title="Delete Version">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        @endif
                                    </div>
                                </div>
                                <div class="cse-grid">
                                    <div class="cse-field">
                                        <label class="cse-label">Version Name</label>
                                        <input type="text" class="form-control @error('version_name') is-invalid @enderror" wire:model="version_name" placeholder="e.g. V1, V2, China..." maxlength="255">
                                        @error('version_name') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="cse-field">
                                        <label class="cse-label">Factory</label>
                                        <select class="form-select @error('factory_id') is-invalid @enderror" wire:model="factory_id">
                                            <option value="">Select Factory</option>
                                            @foreach($this->factories as $factory)
                                                <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('factory_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>

                @elseif($activeTab === 'colourways')
                    {{-- Colourways Tab --}}
                    <div class="cse-cw-container">
                        {{-- Colourway Sidebar --}}
                        <div class="cse-cw-sidebar">
                            <div class="cse-cw-sidebar-header">
                                <span class="cse-cw-count">
                                    {{ $this->style->style_versions->find($activeVersionId)?->colourways->count() ?? 0 }} Colourways
                                </span>
                                <button class="cse-cw-add-btn" wire:click="addColourway" title="Add Colourway">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                            
                            <div class="cse-cw-list">
                                @if($activeVersionId)
                                    @foreach($this->style->style_versions->find($activeVersionId)?->colourways ?? [] as $cw)
                                        <button 
                                            class="cse-cw-item {{ $activeColourwayId === $cw->id ? 'active' : '' }} {{ $cw->cancelled ? 'cancelled' : '' }}"
                                            wire:click="selectColourway({{ $cw->id }})"
                                            wire:key="cw-{{ $cw->id }}"
                                        >
                                            <div class="cse-cw-item-thumb">
                                                @if($cw->img_thumb)
                                                    <img src="{{ asset('storage/' . $cw->img_thumb) }}" alt="{{ $cw->name }}">
                                                @else
                                                    <i class="fas fa-image"></i>
                                                @endif
                                            </div>
                                            <div class="cse-cw-item-info">
                                                <span class="cse-cw-item-name">{{ $cw->name ?: 'Unnamed' }}</span>
                                                @if($cw->customer_description)
                                                    <span class="cse-cw-item-desc">{{ $cw->customer_description }}</span>
                                                @endif
                                            </div>
                                            @if($cw->cancelled)
                                                <span class="cse-cw-item-cancelled">
                                                    <i class="fas fa-ban"></i>
                                                </span>
                                            @endif
                                        </button>
                                    @endforeach
                                @endif
                            </div>
                        </div>

                        {{-- Colourway Editor --}}
                        <div class="cse-cw-editor">
                            @if($activeColourwayId)
                                {{-- Action Bar --}}
                                <div class="cse-cw-actions">
                                    <button class="cse-cw-action-btn" wire:click="cloneColourway" title="Clone Colourway">
                                        <i class="fas fa-copy"></i>
                                        <span>Clone</span>
                                    </button>
                                    <button class="cse-cw-action-btn cse-cw-action-danger" wire:click="deleteColourway" 
                                            wire:confirm="Are you sure you want to delete this colourway?" title="Delete Colourway">
                                        <i class="fas fa-trash"></i>
                                        <span>Delete</span>
                                    </button>
                                </div>

                                {{-- Image Upload with Drag & Drop and Paste --}}
                                <div class="cse-cw-image-area"
                                     x-data="{ 
                                         isDragging: false,
                                         handleDrop(e) {
                                             this.isDragging = false;
                                             const files = e.dataTransfer.files;
                                             if (files.length > 0 && files[0].type.startsWith('image/')) {
                                                 @this.upload('new_image', files[0]);
                                             }
                                         },
                                         handlePaste(e) {
                                             const items = e.clipboardData?.items;
                                             if (!items) return;
                                             for (let i = 0; i < items.length; i++) {
                                                 if (items[i].type.startsWith('image/')) {
                                                     const file = items[i].getAsFile();
                                                     if (file) {
                                                         @this.upload('new_image', file);
                                                         e.preventDefault();
                                                         break;
                                                     }
                                                 }
                                             }
                                         }
                                     }"
                                     x-on:paste.window="handlePaste($event)"
                                     x-on:dragover.prevent="isDragging = true"
                                     x-on:dragleave.prevent="isDragging = false"
                                     x-on:drop.prevent="handleDrop($event)"
                                     :class="{ 'cse-cw-dragging': isDragging }">
                                    <div class="cse-cw-image-preview">
                                        @if($new_image)
                                            <img src="{{ $new_image->temporaryUrl() }}" alt="New image">
                                        @elseif($colourway_image)
                                            <img src="{{ asset('storage/' . $colourway_image) }}" alt="Current image">
                                        @else
                                            <div class="cse-cw-no-image">
                                                <i class="fas fa-camera"></i>
                                                <span>No Image</span>
                                            </div>
                                        @endif
                                        
                                        <label class="cse-cw-image-overlay">
                                            <input type="file" wire:model="new_image" accept="image/*" hidden>
                                            <i class="fas fa-camera"></i>
                                            <span>{{ $colourway_image || $new_image ? 'Change' : 'Add Photo' }}</span>
                                        </label>
                                        
                                        {{-- Drag overlay --}}
                                        <div class="cse-cw-drag-overlay" x-show="isDragging" x-cloak>
                                            <i class="fas fa-cloud-upload-alt"></i>
                                            <span>Drop image here</span>
                                        </div>
                                    </div>
                                    
                                    <div class="cse-cw-image-hint">
                                        <i class="fas fa-info-circle"></i>
                                        Drag & drop, paste, or click to upload
                                    </div>
                                    
                                    <div wire:loading wire:target="new_image" class="cse-cw-image-loading">
                                        <i class="fas fa-spinner fa-spin"></i> Uploading...
                                    </div>
                                </div>

                                {{-- Fields --}}
                                <div class="cse-cw-fields">
                                    <div class="cse-field">
                                        <label class="cse-label">Colourway Name</label>
                                        <input type="text" class="form-control @error('colourway_name') is-invalid @enderror" wire:model="colourway_name" placeholder="e.g. Navy, Oatmeal..." maxlength="255">
                                        @error('colourway_name') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="cse-field">
                                        <label class="cse-label">Customer Description</label>
                                        <input type="text" class="form-control @error('colourway_customer_description') is-invalid @enderror" wire:model="colourway_customer_description" placeholder="Customer's colour name" maxlength="255">
                                        @error('colourway_customer_description') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="cse-field">
                                        <label class="cse-label">Composition</label>
                                        <textarea class="form-control @error('colourway_composition') is-invalid @enderror" wire:model="colourway_composition" rows="3" placeholder="e.g. 100% Lambswool" maxlength="5000"></textarea>
                                        @error('colourway_composition') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    </div>

                                    <div class="cse-field">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="colourway_cancelled" wire:model="colourway_cancelled">
                                            <label class="form-check-label text-danger" for="colourway_cancelled">Cancelled</label>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="cse-cw-empty">
                                    <i class="fas fa-hand-pointer"></i>
                                    <p>Select a colourway to edit</p>
                                    <span>or add a new one</span>
                                </div>
                            @endif
                        </div>
                    </div>

                @else
                    {{-- History Tab --}}
                    <div class="cse-history-container">
                        @if($this->auditHistory->isEmpty())
                            <div class="cse-history-empty">
                                <i class="fas fa-history"></i>
                                <p>No history available</p>
                                <small class="text-muted">History tracking was enabled in December 2023</small>
                            </div>
                        @else
                            @php
                                $hasCreationRecord = $this->auditHistory->contains(fn($a) => $a->event === 'Created' && $a->model_type === 'Style');
                            @endphp
                            @if(!$hasCreationRecord)
                                <div class="cse-history-notice">
                                    <i class="fas fa-info-circle"></i>
                                    <span>This style was created before history tracking was enabled (Dec 2023)</span>
                                </div>
                            @endif
                            <div class="cse-history-timeline">
                                @foreach($this->auditHistory as $audit)
                                    <div class="cse-history-item" wire:key="audit-{{ $audit->id }}">
                                        <div class="cse-history-icon cse-history-icon-{{ strtolower($audit->event) }}">
                                            @if($audit->event === 'Created')
                                                <i class="fas fa-plus"></i>
                                            @elseif($audit->event === 'Updated')
                                                <i class="fas fa-edit"></i>
                                            @elseif($audit->event === 'Deleted')
                                                <i class="fas fa-trash"></i>
                                            @else
                                                <i class="fas fa-circle"></i>
                                            @endif
                                        </div>
                                        <div class="cse-history-content">
                                            <div class="cse-history-header">
                                                <span class="cse-history-event">
                                                    {{ $audit->model_type }}@if($audit->item_name) <span class="cse-history-item-name" title="{{ $audit->item_name }}">"{{ Str::limit($audit->item_name, 10) }}"</span>@endif {{ $audit->event }}
                                                </span>
                                                <span class="cse-history-meta">
                                                    <span class="cse-history-user">
                                                        <i class="fas fa-user"></i> {{ $audit->user_name }}
                                                    </span>
                                                    <span class="cse-history-time" title="{{ $audit->created_at->format('d M Y H:i:s') }}">
                                                        {{ $audit->created_at->diffForHumans() }}
                                                    </span>
                                                </span>
                                            </div>
                                            @if(!empty($audit->changes))
                                                <div class="cse-history-changes">
                                                    @foreach($audit->changes as $change)
                                                        <div class="cse-history-change">
                                                            <span class="cse-history-field">{{ $change['field'] }}:</span>
                                                            @if($audit->event !== 'Created')
                                                                <span class="cse-history-old">{{ $change['old'] }}</span>
                                                                <i class="fas fa-arrow-right cse-history-arrow"></i>
                                                            @endif
                                                            <span class="cse-history-new">{{ $change['new'] }}</span>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                @endif
            </div>

            {{-- Footer --}}
            <footer class="cse-footer">
                <button class="cse-btn cse-btn-secondary" wire:click="confirmClose">
                    Close
                </button>
                <button class="cse-btn cse-btn-primary" wire:click="save" wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="save, checkForSimilarDesigns">
                        @if($isNewStyle)
                            <i class="fas fa-plus"></i> Create Style
                        @else
                            Save Changes
                        @endif
                    </span>
                    <span wire:loading wire:target="save, checkForSimilarDesigns">
                        <i class="fas fa-spinner fa-spin"></i> 
                        @if($isNewStyle)
                            Checking...
                        @else
                            Saving...
                        @endif
                    </span>
                </button>
            </footer>
        @endif
    </div>
</div>

