<div class="commission-sl-invoicing"
     x-data="{ 
         showZohoToast: {{ $this->isZohoConnected ? 'false' : 'true' }},
         openZohoAuth(url) {
             const popup = window.open(url, 'ZohoOAuth', 'width=600,height=700');
             // Poll to check when popup closes
             const checkClosed = setInterval(() => {
                 if (popup.closed) {
                     clearInterval(checkClosed);
                     // Refresh the component to check connection status
                     $wire.$refresh();
                 }
             }, 500);
         }
     }"
     @open-zoho-oauth-popup.window="openZohoAuth($event.detail.url)">

    {{-- Zoho Connection Status - Top Right Notification --}}
    @if($this->isZohoConnected)
        <div class="slinv-zoho-status-bubble">
            <i class="fas fa-check-circle"></i>
            <span>Zoho Connected</span>
        </div>
    @endif

    {{-- Header --}}
    <header class="comm-header">
        <div class="comm-header-content">
            <div class="comm-title-section">
                <div class="comm-stats">
                    <span class="comm-stat ready">
                        <span class="comm-stat-value">{{ $this->stats['ready'] }}</span>
                        <span class="comm-stat-label">Shipped & Approved</span>
                    </span>
                    <span class="comm-stat sent">
                        <span class="comm-stat-value">{{ $this->stats['sent_to_zoho'] }}</span>
                        <span class="comm-stat-label">Sent to Zoho</span>
                    </span>
                    <span class="comm-stat confirmed">
                        <span class="comm-stat-value">{{ $this->stats['complete'] }}</span>
                        <span class="comm-stat-label">Complete</span>
                    </span>
                    <span class="comm-stat total">
                        <span class="comm-stat-value">{{ number_format($this->stats['total_value'], 0) }}</span>
                        <span class="comm-stat-label">Pending Value</span>
                    </span>
                </div>
            </div>
            
            <div class="comm-search-section">
                <div class="comm-search-wrapper">
                    <i class="fas fa-search comm-search-icon"></i>
                    <input 
                        type="text" 
                        class="comm-search-input" 
                        placeholder="Search invoices..."
                        wire:model.live.debounce.300ms="search"
                    >
                    @if($search)
                        <button class="comm-search-clear" wire:click="$set('search', '')">
                            <i class="fas fa-times"></i>
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </header>
    
    {{-- Zoho Connection Toast (Floating) --}}
    @if(!$this->isZohoConnected)
        <div class="slinv-zoho-toast" 
             x-show="showZohoToast" 
             x-cloak
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform translate-y-4"
             x-transition:enter-end="opacity-100 transform translate-y-0"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100 transform translate-y-0"
             x-transition:leave-end="opacity-0 transform translate-y-4">
            <div class="slinv-toast-content">
                <div class="slinv-toast-icon">
                    <i class="fas fa-plug"></i>
                </div>
                <div class="slinv-toast-text">
                    <span class="slinv-toast-title">Connect to Zoho Books</span>
                    <span class="slinv-toast-desc">Required to create invoices automatically</span>
                </div>
                <button class="slinv-toast-btn" wire:click="initiateZohoOAuth">
                    <i class="fas fa-sign-in-alt"></i>
                    Connect
                </button>
                <button class="slinv-toast-close" @click="showZohoToast = false">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    @endif

    {{-- Filters --}}
    <x-commission.filters-bar :activeFiltersCount="$this->activeFiltersCount" clearAction="clearFilters">
        {{-- Status Dropdown --}}
        <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
            <button class="cfilter-dropdown-btn {{ $status ? 'has-value' : '' }}" @click="open = !open">
                <i class="fas fa-check-circle cfilter-icon"></i>
                <span class="cfilter-label">
                    @if($status)
                        {{ $this->statusOptions[$status]['label'] ?? 'Status' }}
                    @else
                        All Statuses
                    @endif
                </span>
                <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
            </button>
            <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                 x-transition:enter="transition ease-out duration-150"
                 x-transition:enter-start="opacity-0 transform -translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-100"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0">
                <button class="cfilter-option {{ !$status ? 'selected' : '' }}" 
                        wire:click="$set('status', '')" @click="open = false">
                    <i class="fas fa-layer-group"></i>
                    All Statuses
                    @if(!$status)<i class="fas fa-check cfilter-check"></i>@endif
                </button>
                @foreach($this->statusOptions as $key => $opt)
                    <button class="cfilter-option {{ $status === $key ? 'selected' : '' }}" 
                            wire:click="$set('status', '{{ $key }}')" @click="open = false">
                        <i class="fas {{ $opt['icon'] }}"></i>
                        {{ $opt['label'] }}
                        @if($status === $key)<i class="fas fa-check cfilter-check"></i>@endif
                    </button>
                @endforeach
            </div>
        </div>

        {{-- Customer Dropdown --}}
        <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
            <button class="cfilter-dropdown-btn {{ $customer ? 'has-value' : '' }}" @click="open = !open">
                <i class="fas fa-building cfilter-icon"></i>
                <span class="cfilter-label">
                    @if($customer)
                        {{ $this->customers->firstWhere('id', $customer)?->name ?? 'Customer' }}
                    @else
                        All Customers
                    @endif
                </span>
                <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
            </button>
            <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                 x-transition:enter="transition ease-out duration-150"
                 x-transition:enter-start="opacity-0 transform -translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-100"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0">
                <div class="cfilter-search">
                    <i class="fas fa-search"></i>
                    <input type="text" placeholder="Search customers..." x-model="search" @click.stop>
                </div>
                <div class="cfilter-options">
                    <button class="cfilter-option {{ !$customer ? 'selected' : '' }}" 
                            x-show="!search || 'all customers'.includes(search.toLowerCase())"
                            wire:click="$set('customer', '')" @click="open = false; search = ''">
                        <i class="fas fa-users"></i>
                        All Customers
                        @if(!$customer)<i class="fas fa-check cfilter-check"></i>@endif
                    </button>
                    @foreach($this->customers as $c)
                        <button class="cfilter-option {{ $customer == $c->id ? 'selected' : '' }}" 
                                x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                wire:click="$set('customer', '{{ $c->id }}')" @click="open = false; search = ''">
                            <i class="fas fa-building"></i>
                            {{ $c->name }}
                            @if($customer == $c->id)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    @endforeach
                </div>
            </div>
        </div>
    </x-commission.filters-bar>

    {{-- Content --}}
    <div class="csamp-content">
        {{-- Loading overlay --}}
        <div class="csamp-loading" wire:loading.delay>
            <div class="spinner-border text-light" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>

        @if(empty($loadedInvoiceGroups))
            <div class="csamp-empty">
                <div class="csamp-empty-icon">
                    <i class="fas fa-file-invoice-dollar"></i>
                </div>
                <h3>No invoices to process</h3>
                <p>Shipped & approved invoices will appear here for Zoho processing</p>
                <a href="{{ route('commission.invoices') }}" class="btn btn-commission mt-3">
                    <i class="fas fa-arrow-left me-2"></i>View All Invoices
                </a>
            </div>
        @else
            <div class="slinv-list">
                @foreach($loadedInvoiceGroups as $invoiceData)
                    @php
                        $invoice = (object) $invoiceData;
                        $invoice->customer = isset($invoiceData['customer']) ? (object) $invoiceData['customer'] : null;
                        $invoice->drops = collect($invoiceData['drops'] ?? []);
                        $isExpanded = in_array($invoice->id, $expanded);
                        $statusOpt = $this->statusOptions[$invoice->status] ?? null;
                    @endphp
                    <div class="slinv-card {{ $invoice->status }}" wire:key="invoice-{{ $invoice->id }}">
                        {{-- Invoice Header --}}
                        <div class="slinv-header" wire:click="toggleExpanded({{ $invoice->id }})">
                            <div class="slinv-expand-icon">
                                <i class="fas fa-chevron-{{ $isExpanded ? 'down' : 'right' }}"></i>
                            </div>
                            
                            <div class="slinv-info">
                                <div class="slinv-main">
                                    <span class="slinv-id">#{{ $invoice->id }}</span>
                                    <span class="slinv-ref">{{ $invoice->reference ?? 'No Reference' }}</span>
                                    <span class="slinv-customer">{{ $invoice->customer?->name }}</span>
                                </div>
                                <div class="slinv-meta">
                                    @if($invoice->invoice_date ?? null)
                                        <span><i class="fas fa-calendar"></i> {{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d M Y') }}</span>
                                    @endif
                                    <span><i class="fas fa-boxes"></i> {{ $invoice->drops_count ?? $invoice->drops->count() }} drops</span>
                                    <span class="slinv-value">{{ $invoice->customer?->currency ?? '$' }}{{ number_format($invoice->total_value ?? 0, 2) }}</span>
                                </div>
                            </div>

                            <div class="slinv-status">
                                @if($statusOpt)
                                    <span class="slinv-status-badge slinv-status-{{ $invoice->status }}">
                                        <i class="fas {{ $statusOpt['icon'] }}"></i>
                                        {{ $statusOpt['label'] }}
                                    </span>
                                @endif
                            </div>

                            <div class="slinv-actions" wire:click.stop>
                                @if($invoice->status === 'ready')
                                    {{-- Send to Zoho via API --}}
                                    <button class="btn btn-sm btn-primary" 
                                            wire:click="sendToZoho({{ $invoice->id }})"
                                            wire:confirm="Generate Zoho Invoice for this group?"
                                            @if(!$this->isZohoConnected) disabled title="Connect to Zoho first" @endif>
                                        <span wire:loading.remove wire:target="sendToZoho({{ $invoice->id }})">
                                            <i class="fas fa-paper-plane me-1"></i>
                                            Send to Zoho
                                        </span>
                                        <span wire:loading wire:target="sendToZoho({{ $invoice->id }})">
                                            <i class="fas fa-spinner fa-spin me-1"></i>
                                            Creating...
                                        </span>
                                    </button>
                                    {{-- Manual entry option (always available) --}}
                                    <button class="btn btn-sm btn-outline-secondary" 
                                            wire:click="openManualEntry({{ $invoice->id }})"
                                            title="Mark as sent manually">
                                        <i class="fas fa-edit me-1"></i>
                                        Mark As Sent
                                    </button>
                                @elseif($invoice->status === 'sent_to_zoho')
                                    @if($invoice->zoho_invoice_id)
                                        {{-- Already has Zoho ID from API - just display it --}}
                                        <span class="slinv-zoho-id">
                                            <i class="fas fa-file-invoice"></i>
                                            {{ $invoice->zoho_invoice_id }}
                                        </span>
                                    @else
                                        {{-- Missing Zoho ID - show input for manual entry --}}
                                        <div class="slinv-zoho-input">
                                            <input type="text" 
                                                   class="form-control form-control-sm" 
                                                   placeholder="Zoho Invoice ID"
                                                   wire:model.defer="zohoIds.{{ $invoice->id }}">
                                            <button class="btn btn-sm btn-outline-primary" 
                                                    wire:click="saveZohoId({{ $invoice->id }})"
                                                    title="Save Zoho ID">
                                                <i class="fas fa-save"></i>
                                            </button>
                                        </div>
                                    @endif
                                    <button class="btn btn-sm btn-success" 
                                            wire:click="markComplete({{ $invoice->id }})"
                                            wire:confirm="Mark this invoice as complete?"
                                            @if(!$invoice->zoho_invoice_id) disabled title="Enter Zoho ID first" @endif>
                                        <i class="fas fa-check-double me-1"></i>
                                        Complete
                                    </button>
                                    <button class="btn btn-sm btn-outline-secondary"
                                            wire:click="revertToReady({{ $invoice->id }})"
                                            wire:confirm="Revert this invoice to Shipped & Approved status?"
                                            title="Revert to Shipped & Approved">
                                        <i class="fas fa-undo"></i>
                                    </button>
                                @elseif($invoice->status === 'complete')
                                    @if($invoice->zoho_invoice_id)
                                        <span class="slinv-zoho-id">
                                            <i class="fas fa-external-link-alt"></i>
                                            Zoho: {{ $invoice->zoho_invoice_id }}
                                        </span>
                                    @endif
                                @endif
                            </div>
                        </div>

                        {{-- Expanded Drops Section --}}
                        @if($isExpanded)
                            <div class="slinv-drops">
                                <table class="slinv-drops-table">
                                    <thead>
                                        <tr>
                                            <th>Order PO</th>
                                            <th>Style</th>
                                            <th>Colour</th>
                                            <th class="text-end">Unit Price</th>
                                            <th class="text-end">Total Price</th>
                                            <th>Ship Date</th>
                                            <th class="text-end">Qty</th>
                                            <th class="text-end">Value</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($invoice->drops as $dropData)
                                            @php
                                                $drop = (object) $dropData;
                                                $line = isset($dropData['line']) ? (object) $dropData['line'] : null;
                                                $order = isset($dropData['line']['order']) ? (object) $dropData['line']['order'] : null;
                                                $shippedDate = isset($drop->shipped_date) ? \Carbon\Carbon::parse($drop->shipped_date) : null;
                                                
                                                // Get style ref - prefer the serialized style_ref, fallback to imported data
                                                $styleRef = $dropData['style_ref'] 
                                                    ?? $dropData['line']['style_ref'] 
                                                    ?? $line?->imported_style_ref
                                                    ?? 'N/A';
                                                
                                                // Get colour name - prefer the serialized colour_name, fallback to imported data
                                                $colourName = $dropData['colour_name'] 
                                                    ?? $dropData['line']['colour_name'] 
                                                    ?? $line?->imported_colour_name 
                                                    ?? $line?->imported_colour
                                                    ?? 'N/A';
                                            @endphp
                                            <tr>
                                                <td>
                                                    <span class="slinv-drop-po">{{ $order?->customer_po ?? 'N/A' }}</span>
                                                </td>
                                                <td>
                                                    <span class="slinv-drop-style">{{ $styleRef }}</span>
                                                </td>
                                                <td>
                                                    <span class="slinv-drop-colour">{{ $colourName }}</span>
                                                </td>
                                                <td class="text-end">
                                                    @if(isset($dropData['unit_price_display']))
                                                        @if($dropData['unit_price_display'] === 'DIFF')
                                                            <span class="text-muted">DIFF</span>
                                                        @else
                                                            <span>{{ $invoice->customer?->currency ?? '$' }}{{ $dropData['unit_price_display'] }}</span>
                                                        @endif
                                                    @else
                                                        <span class="text-muted">—</span>
                                                    @endif
                                                </td>
                                                <td class="text-end">
                                                    @if(isset($dropData['total_price']) && $dropData['total_price'] !== null)
                                                        <span>{{ $invoice->customer?->currency ?? '$' }}{{ number_format($dropData['total_price'], 2) }}</span>
                                                    @else
                                                        <span class="text-muted">—</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($shippedDate)
                                                        {{ $shippedDate->format('d M Y') }}
                                                    @else
                                                        <span class="text-muted">—</span>
                                                    @endif
                                                </td>
                                                <td class="text-end">
                                                    <strong>{{ number_format($drop->total_shipped_qty ?? $drop->total_qty ?? 0) }}</strong>
                                                </td>
                                                <td class="text-end">
                                                    <span class="slinv-drop-value">{{ $invoice->customer?->currency ?? '$' }}{{ number_format($drop->total_value ?? 0, 2) }}</span>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="8" class="text-center text-muted py-3">
                                                    No drops attached to this invoice
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    @if($invoice->drops->count() > 0)
                                        <tfoot>
                                            <tr>
                                                <td colspan="6" class="text-end"><strong>Totals:</strong></td>
                                                <td class="text-end"><strong>{{ number_format($invoice->total_qty ?? 0) }}</strong></td>
                                                <td class="text-end"><strong class="slinv-total-value">{{ $invoice->customer?->currency ?? '$' }}{{ number_format($invoice->total_value ?? 0, 2) }}</strong></td>
                                            </tr>
                                        </tfoot>
                                    @endif
                                </table>

                                {{-- Additional Info --}}
                                @if(($invoice->notes ?? null) || ($invoice->supplier_invoice_ref ?? null))
                                    <div class="slinv-extra-info">
                                        @if($invoice->supplier_invoice_ref ?? null)
                                            <div class="slinv-info-item">
                                                <label>Supplier Invoice Ref:</label>
                                                <span>{{ $invoice->supplier_invoice_ref }}</span>
                                            </div>
                                        @endif
                                        @if($invoice->notes ?? null)
                                            <div class="slinv-info-item">
                                                <label>Notes:</label>
                                                <span>{{ $invoice->notes }}</span>
                                            </div>
                                        @endif
                                        @if($invoice->sent_to_zoho_at ?? null)
                                            <div class="slinv-info-item">
                                                <label>Sent to Zoho:</label>
                                                <span>{{ \Carbon\Carbon::parse($invoice->sent_to_zoho_at)->format('d M Y H:i') }}</span>
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>

            {{-- Infinite Scroll Trigger --}}
            @if($hasMore)
                <div class="csamp-load-more" wire:loading.remove wire:target="loadMore">
                    <div class="csamp-load-more-trigger" x-intersect="$wire.loadMore()">
                        <i class="fas fa-circle-notch fa-spin"></i>
                        <span>Loading more...</span>
                    </div>
                </div>
            @else
                <div class="csamp-end-of-list">
                    <span>{{ count($loadedInvoiceGroups) }} invoices loaded</span>
                </div>
            @endif

            {{-- Loading indicator when fetching more --}}
            <div class="csamp-load-more" wire:loading wire:target="loadMore">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>Loading more...</span>
            </div>
        @endif
    </div>

    {{-- Manual Zoho Entry Modal --}}
    @if($manualInvoiceId)
        <div class="cse-confirm-overlay" wire:click.self="closeManualEntry">
            <div class="cse-confirm-modal">
                <h4><i class="fas fa-edit me-2"></i>Mark as Sent to Zoho</h4>
                <p class="text-muted mb-3">Enter the Zoho Invoice Number if you created this invoice manually in Zoho.</p>
                
                <div class="mb-3">
                    <label class="form-label">Zoho Invoice Number <span class="text-danger">*</span></label>
                    <input type="text" 
                           class="form-control" 
                           wire:model="manualZohoNumber" 
                           placeholder="e.g. INV-00123"
                           autofocus>
                </div>
                
                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeManualEntry">
                        Cancel
                    </button>
                    <button class="cse-btn cse-btn-primary" 
                            wire:click="markAsSentManually"
                            @if(empty($manualZohoNumber)) disabled @endif>
                        <i class="fas fa-check me-1"></i>
                        Mark as Sent
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>



