<div class="commission-skeleton-orders"
     x-data="{ 
         toasts: [],
         addToast(type, message) {
             const id = Date.now();
             this.toasts.push({ id, type, message });
             setTimeout(() => this.removeToast(id), 5000);
         },
         removeToast(id) {
             this.toasts = this.toasts.filter(t => t.id !== id);
         }
     }"
     @notify.window="addToast($event.detail.type, $event.detail.message)"
     x-init="
         const container = $refs.scrollContainer;
         if (container) {
             container.addEventListener('scroll', () => {
                 if (container.scrollTop + container.clientHeight >= container.scrollHeight - 200) {
                     if ($wire.hasMore && !$wire.isLoading) {
                         $wire.loadMore();
                     }
                 }
             });
         }
     ">
    <x-commission.page-header 
        title="Skeleton Orders"
        :stats="[
            ['label' => 'Total', 'value' => $this->stats['total'], 'class' => 'total'],
            ['label' => 'Skeleton', 'value' => $this->stats['skeleton'], 'class' => 'skeleton'],
            ['label' => 'Pending PD', 'value' => $this->stats['pending_pd'], 'class' => 'pending'],
            ['label' => 'Pending Merch', 'value' => $this->stats['pending_merch'], 'class' => 'pending'],
        ]"
        searchPlaceholder="Search by PO, Order ID, Source file..."
        searchModel="search"
        :search="$search"
    >
        <x-slot name="actions">
            <a href="{{ route('commission.batch-import') }}" class="comm-create-btn">
                <i class="fas fa-file-import"></i>
                <span>Import Orders</span>
            </a>
        </x-slot>
    </x-commission.page-header>

    {{-- Toast Notifications --}}
    <div class="cso-toast-container" x-show="toasts.length > 0">
        <template x-for="toast in toasts" :key="toast.id">
            <div class="cso-toast" 
                 :class="{ 'cso-toast-success': toast.type === 'success', 'cso-toast-error': toast.type === 'error' }"
                 x-transition>
                <i :class="toast.type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-circle'"></i>
                <span x-text="toast.message"></span>
                <button @click="removeToast(toast.id)">&times;</button>
            </div>
        </template>
    </div>

    {{-- Filters --}}
    <div class="cfilter-bar" x-data="{ showFilters: true }">
        <div class="cfilter-content">
            {{-- Mobile Toggle --}}
            <button class="cfilter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="cfilter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="cfilter-items" :class="{ 'show': showFilters }">
                {{-- Status/Stage Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $status ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-tasks cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($status === 'skeleton')
                                Awaiting Forward
                            @elseif($status === 'pending_pd')
                                Pending PD Review
                            @elseif($status === 'pending_merch')
                                Pending Merch Approval
                            @else
                                All Stages
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$status ? 'selected' : '' }}" 
                                wire:click="$set('status', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Stages
                            @if(!$status)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'skeleton' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'skeleton')" @click="open = false">
                            <i class="fas fa-hourglass-start"></i>
                            Awaiting Forward
                            @if($status === 'skeleton')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'pending_pd' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'pending_pd')" @click="open = false">
                            <i class="fas fa-user-clock"></i>
                            Pending PD Review
                            @if($status === 'pending_pd')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'pending_merch' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'pending_merch')" @click="open = false">
                            <i class="fas fa-clipboard-check"></i>
                            Pending Merch Approval
                            @if($status === 'pending_merch')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    </div>
                </div>

                {{-- Customer Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $customer ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($customer)
                                {{ $this->customers->firstWhere('id', $customer)?->name ?? 'Customer' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" @click.stop>
                        </div>
                        <div class="cfilter-options">
                            <button class="cfilter-option {{ !$customer ? 'selected' : '' }}" 
                                    x-show="!search || 'all customers'.includes(search.toLowerCase())"
                                    wire:click="$set('customer', '')" @click="open = false; search = ''">
                                <i class="fas fa-users"></i>
                                All Customers
                                @if(!$customer)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
            @foreach($this->customers as $c)
                                <button class="cfilter-option {{ $customer == $c->id ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="$set('customer', '{{ $c->id }}')" @click="open = false; search = ''">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if($customer == $c->id)<i class="fas fa-check cfilter-check"></i>@endif
                                </button>
            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            {{-- Active Filters Summary & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="cfilter-active">
                    <span class="cfilter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="cfilter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                    </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Content --}}
    <div class="csamp-content" x-ref="scrollContainer">
        <div class="csamp-loading" wire:loading.delay wire:target="loadInitialOrders">
            <div class="spinner-border text-light" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>

        @if(empty($loadedOrders))
            <div class="csamp-empty">
                <div class="csamp-empty-icon">
                    <i class="fas fa-file-import"></i>
                </div>
                <h3>No skeleton orders</h3>
                <p>Import orders to get started with the approval workflow</p>
                <a href="{{ route('commission.batch-import') }}" class="btn btn-commission mt-3">
                    <i class="fas fa-file-import"></i> Import Orders
                </a>
            </div>
        @else
            <div class="csamp-table-container">
                <table class="csamp-table">
                    <thead>
                        <tr>
                            <th class="csamp-th-sortable" wire:click="sort('id')" style="width: 80px;">
                                <span>Order</span>
                                @if($sortBy === 'id')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Source / PO</th>
                            <th>Customer</th>
                            <th>Season</th>
                            <th class="text-center">Match</th>
                            <th class="text-center">Lines</th>
                            <th class="csamp-th-sortable text-end" wire:click="sort('imported_at')">
                                <span>Imported</span>
                                @if($sortBy === 'imported_at')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Workflow</th>
                            <th class="csamp-th-actions">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($loadedOrders as $order)
                            <tr class="csamp-row" wire:key="order-{{ $order['id'] }}">
                                <td>
                                    <span class="co-order-id">#{{ $order['id'] }}</span>
                                </td>

                                <td>
                                    <div class="cso-source-info">
                                        <span class="cso-source-file">{{ $order['source_file'] ?? $order['customer_po'] ?? '—' }}</span>
                                        @if($order['customer_po'] && $order['source_file'])
                                            <span class="cso-po-number">PO: {{ $order['customer_po'] }}</span>
                                        @endif
                                        @if(!empty($order['source_files']))
                                            <div class="cso-source-files mt-1">
                                                @foreach($order['source_files'] as $index => $filePath)
                                                    <a href="{{ route('commission.orders.download', ['order' => $order['id'], 'fileIndex' => $index]) }}" 
                                                       class="cso-file-link" 
                                                       target="_blank"
                                                       title="Download {{ basename($filePath) }}">
                                                        <i class="fas fa-file-pdf"></i>
                                                        {{ Str::limit(basename($filePath), 25) }}
                                                    </a>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </td>

                                <td>
                                    <span class="csamp-desc">{{ $order['customer_name'] ?? '—' }}</span>
                                </td>

                                <td>
                                    <span class="csamp-type-badge">{{ $order['season_description'] ?? '—' }}</span>
                                </td>

                                <td class="text-center">
                                    <div class="co-match-indicator {{ $order['match_percent'] === 100 ? 'matched' : ($order['match_percent'] === 0 ? 'unmatched' : 'partial') }}"
                                         title="{{ $order['matched_lines'] }}/{{ $order['total_lines'] }} matched">
                                        <div class="co-match-bar">
                                            <div class="co-match-fill" style="width: {{ $order['match_percent'] }}%"></div>
                                        </div>
                                        <span class="co-match-text">{{ $order['match_percent'] }}%</span>
                                    </div>
                                    @if($order['unmatched_lines'] > 0)
                                        <span class="co-unmatched-count">{{ $order['unmatched_lines'] }} unmatched</span>
                                    @endif
                                </td>

                                <td class="text-center">
                                    <span class="co-lines-badge">{{ $order['total_lines'] }}</span>
                                </td>

                                <td class="text-end">
                                    @if($order['imported_at'])
                                        <span class="cso-date" title="{{ $order['imported_at'] }}">
                                            {{ $order['imported_at_diff'] }}
                                        </span>
                                    @else
                                        <span class="cso-date">—</span>
                                    @endif
                                </td>

                                <td>
                                    @php
                                        $currentUser = auth()->user();
                                        $isPdUser = $currentUser?->hasRole('pd') || $currentUser?->hasRole('admin');
                                        $isMerchUser = $currentUser?->hasRole('merch') || $currentUser?->hasRole('admin');
                                        $isAssignedToPd = $order['pd_reviewed_by_id'] === $currentUser?->id;
                                        
                                        // Determine if current user needs to act
                                        $needsMyAction = false;
                                        if ($order['status'] === 'skeleton' && $isPdUser) {
                                            $needsMyAction = true;
                                        } elseif ($order['status'] === 'pending_pd' && $isPdUser && $isAssignedToPd) {
                                            $needsMyAction = true;
                                        } elseif ($order['status'] === 'pending_merch' && $isMerchUser) {
                                            $needsMyAction = true;
                                        }
                                    @endphp
                                    <div class="cso-workflow-info">
                                        @if($order['status'] === 'skeleton')
                                            <span class="cso-workflow-step {{ $needsMyAction ? 'my-action' : 'waiting' }}">
                                                <i class="fas fa-clock"></i> Awaiting forward
                                            </span>
                                        @elseif($order['status'] === 'pending_pd')
                                            <span class="cso-workflow-step {{ $needsMyAction ? 'my-action' : 'waiting' }}">
                                                <i class="fas fa-user"></i> 
                                                @if($order['pd_reviewed_by_name'])
                                                    With {{ $order['pd_reviewed_by_name'] }}
                                                @else
                                                    Awaiting PD review
                                                @endif
                                            </span>
                                        @elseif($order['status'] === 'pending_merch')
                                            <span class="cso-workflow-step {{ $needsMyAction ? 'my-action' : 'waiting' }}">
                                                <i class="fas fa-check-circle"></i> 
                                                PD approved, awaiting Merch
                                            </span>
                                        @endif
                                    </div>
                                </td>

                                <td class="csamp-td-actions">
                                    <div class="co-action-group">
                                        <button class="csamp-action-btn" title="View/Edit" 
                                                wire:click="viewOrder({{ $order['id'] }})">
                                            <i class="fas fa-eye"></i>
                                        </button>

                                        @if($order['status'] === 'skeleton')
                                            <button class="csamp-action-btn co-action-primary" 
                                                    title="Forward to PD"
                                                    wire:click="openForwardModal({{ $order['id'] }})">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                        @elseif($order['status'] === 'pending_pd')
                                            <button class="csamp-action-btn co-action-success" 
                                                    title="Approve (PD)"
                                                    wire:click="openApprovalModal({{ $order['id'] }}, 'pd')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @elseif($order['status'] === 'pending_merch')
                                            <button class="csamp-action-btn co-action-success" 
                                                    title="Confirm (Merch)"
                                                    wire:click="openApprovalModal({{ $order['id'] }}, 'merch')"
                                                    @if($order['unmatched_lines'] > 0) disabled title="Cannot confirm: has unmatched lines" @endif>
                                                <i class="fas fa-check-double"></i>
                                            </button>
                                        @endif

                                        <button class="csamp-action-btn csamp-action-danger" 
                                                title="Delete"
                                                wire:click="deleteOrder({{ $order['id'] }})"
                                                wire:confirm="Delete this order?">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Loading More Indicator --}}
            @if($hasMore)
                <div class="csamp-load-more" wire:loading.remove wire:target="loadMore">
                    <div class="csamp-load-more-trigger" x-intersect="$wire.loadMore()">
                        <i class="fas fa-circle-notch fa-spin"></i>
                        <span>Loading more...</span>
                    </div>
                </div>
            @else
                <div class="csamp-end-of-list">
                    <span>{{ count($loadedOrders) }} orders loaded</span>
                </div>
            @endif

            {{-- Loading indicator when fetching more --}}
            <div class="csamp-load-more" wire:loading wire:target="loadMore">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>Loading more...</span>
            </div>
        @endif
    </div>

    {{-- Forward to PD Modal --}}
    @if($showForwardModal)
        <div class="cse-confirm-modal">
            <div class="cse-confirm-backdrop" wire:click="closeForwardModal"></div>
            <div class="cse-confirm-dialog cso-forward-dialog">
                <div class="cse-confirm-icon">
                    <i class="fas fa-paper-plane"></i>
                </div>
                <h3>Forward to PD</h3>
                <p>Select a PD user to review this order</p>

                <div class="cso-forward-form">
                    <div class="mb-3">
                        <label class="form-label">Send to <span class="text-danger">*</span></label>
                        @if($this->pdUsers->count() > 0)
                            <select class="form-select" wire:model="forwardToUserId" @if($forwardSelfCertified) disabled @endif>
                                <option value="">Select User</option>
                                @foreach($this->pdUsers as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        @else
                            <p class="text-muted small mb-0">
                                <i class="fas fa-info-circle"></i> 
                                No PD users configured. Assign the "PD" role to users first.
                            </p>
                        @endif
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Notes (optional)</label>
                        <textarea class="form-control" wire:model="forwardNotes" rows="2" 
                                  placeholder="Add any notes for the reviewer..."></textarea>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="cso-forward-self-certify"
                                   wire:model="forwardSelfCertified">
                            <label class="form-check-label" for="cso-forward-self-certify">
                                I certify this order is approved to move to the next stage.
                            </label>
                        </div>
                        @error('forwardSelfCertified')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                        @if($forwardSelfCertified)
                            <div class="text-muted small mt-1">
                                You will be assigned as the PD reviewer.
                            </div>
                        @endif
                    </div>
                </div>

                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeForwardModal">
                        Cancel
                    </button>
                    <button class="cse-btn cse-btn-primary" wire:click="forwardToPd"
                            @if(!$forwardSelfCertified && !$forwardToUserId) disabled @endif>
                        <i class="fas fa-paper-plane"></i> Forward
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Approval Modal --}}
    @if($showApprovalModal)
        <div class="cse-confirm-modal">
            <div class="cse-confirm-backdrop" wire:click="closeApprovalModal"></div>
            <div class="cse-confirm-dialog cso-approval-dialog">
                <div class="cse-confirm-icon {{ $approvalType === 'merch' ? 'success' : '' }}">
                    <i class="fas fa-{{ $approvalType === 'merch' ? 'check-double' : 'check' }}"></i>
                </div>
                <h3>{{ $approvalType === 'pd' ? 'PD Approval' : 'Merch Confirmation' }}</h3>
                <p>
                    @if($approvalType === 'pd')
                        Approve this order and send to Merch for final confirmation
                    @else
                        Confirm this order to make it a full order
                    @endif
                </p>

                <div class="cso-approval-form">
                    <div class="mb-3">
                        <label class="form-label">Notes (optional)</label>
                        <textarea class="form-control" wire:model="approvalNotes" rows="2" 
                                  placeholder="Add any notes..."></textarea>
                    </div>
                </div>

                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeApprovalModal">
                        Cancel
                    </button>
                    <button class="cse-btn cse-btn-{{ $approvalType === 'merch' ? 'success' : 'primary' }}" 
                            wire:click="submitApproval">
                        <i class="fas fa-{{ $approvalType === 'merch' ? 'check-double' : 'check' }}"></i>
                        {{ $approvalType === 'pd' ? 'Approve' : 'Confirm Order' }}
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Order Edit Panel --}}
    @livewire('commission.order-edit')

    {{-- Batch Filter Toast --}}
    @if($this->batch)
        <div class="comm-selection-toast" 
             x-data
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform translate-y-4"
             x-transition:enter-end="opacity-100 transform translate-y-0">
            <div class="comm-selection-toast-content">
                <div class="comm-selection-toast-icon">
                    <i class="fas fa-file-import"></i>
                </div>
                <div class="comm-selection-toast-text">
                    <span class="comm-selection-toast-title">Viewing Import Batch #{{ $this->batch }}</span>
                    <span class="comm-selection-toast-desc">Showing only orders from this import</span>
                </div>
                <button class="comm-selection-toast-btn" wire:click="$set('batch', null)">
                    <i class="fas fa-list"></i>
                    Show All
                </button>
            </div>
        </div>
    @endif

    {{-- Single Order Filter Toast --}}
    @if($this->order)
        <div class="comm-selection-toast" 
             x-data
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform translate-y-4"
             x-transition:enter-end="opacity-100 transform translate-y-0">
            <div class="comm-selection-toast-content">
                <div class="comm-selection-toast-icon">
                    <i class="fas fa-filter"></i>
                </div>
                <div class="comm-selection-toast-text">
                    <span class="comm-selection-toast-title">Viewing Order #{{ $this->order }}</span>
                    <span class="comm-selection-toast-desc">Filtered from import batch</span>
                </div>
                <button class="comm-selection-toast-btn" wire:click="$set('order', null)">
                    <i class="fas fa-list"></i>
                    Show All
                </button>
            </div>
        </div>
    @endif
</div>


