<div class="css-schedule" x-data="{ 
    showFilters: true,
    imageModal: { show: false, src: '', alt: '' }
}"
     x-init="
         const container = $refs.scrollContainer;
         if (container) {
             container.addEventListener('scroll', () => {
                 if (container.scrollTop + container.clientHeight >= container.scrollHeight - 200) {
                     if ($wire.hasMore && !$wire.isLoading) {
                         $wire.loadMore();
                     }
                 }
             });
         }
     ">
    {{-- Header --}}
    <header class="css-header">
        <div class="css-header-top">
            <div class="css-title-section">
                <h1 class="css-title">Shipment Schedule</h1>
                <div class="css-stats">
                    <span class="css-stat total">
                        <span class="css-stat-value">{{ $this->stats['total'] }}</span>
                        <span class="css-stat-label">Total</span>
                    </span>
                    <span class="css-stat pending">
                        <span class="css-stat-value">{{ $this->stats['unshipped'] }}</span>
                        <span class="css-stat-label">Unshipped</span>
                    </span>
                    <span class="css-stat shipped">
                        <span class="css-stat-value">{{ $this->stats['shipped'] }}</span>
                        <span class="css-stat-label">Shipped</span>
                    </span>
                    @if($this->stats['overdue'] > 0)
                        <span class="css-stat overdue">
                            <span class="css-stat-value">{{ $this->stats['overdue'] }}</span>
                            <span class="css-stat-label">Overdue</span>
                        </span>
                    @endif
                </div>
            </div>

            <div class="css-search-section">
                <div class="css-search-wrapper">
                    <i class="fas fa-search css-search-icon"></i>
                    <input 
                        type="text" 
                        class="css-search-input" 
                        placeholder="Search PO, style, design..."
                        wire:model.live.debounce.300ms="search"
                    >
                    @if($search)
                        <button class="css-search-clear" wire:click="$set('search', '')">
                            <i class="fas fa-times"></i>
                        </button>
                    @endif
                </div>
            </div>

            <div class="css-actions" x-data="{ exporting: false }" style="display: flex; align-items: stretch; gap: 0.5rem;">
                <button class="css-btn css-btn-outline" wire:click="$refresh" title="Refresh" style="display: flex; align-items: center;">
                    <i class="fas fa-sync-alt"></i>
                </button>
                <button class="css-btn css-btn-outline" style="display: flex; align-items: center; gap: 0.25rem;"
                        x-on:click="
                            exporting = true;
                            fetch('{{ route('commission.shipment-schedule.export-sheets') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                    'Accept': 'application/json',
                                },
                                body: JSON.stringify({
                                    view: '{{ $view }}',
                                    fromDate: '{{ $fromDate }}',
                                    toDate: '{{ $toDate }}',
                                    customers: @js($customers),
                                    seasons: @js($seasons),
                                    invoiceStatus: '{{ $invoiceStatus }}',
                                    search: '{{ $search }}',
                                    sortBy: '{{ $sortBy }}',
                                    sortDir: '{{ $sortDir }}'
                                })
                            })
                            .then(response => {
                                if (response.status === 401) {
                                    return response.json().then(data => {
                                        if (data.needs_auth) {
                                            exporting = false;
                                            if (confirm('You need to connect your Google account first. Would you like to connect now?')) {
                                                window.location.href = '{{ route('google.connect') }}';
                                            }
                                            throw new Error('Authentication required');
                                        }
                                    });
                                }
                                return response.json();
                            })
                            .then(data => {
                                exporting = false;
                                if (data && data.success) {
                                    window.open(data.url, '_blank');
                                } else if (data && data.error) {
                                    alert('Error: ' + data.error);
                                }
                            })
                            .catch(error => {
                                exporting = false;
                                if (error.message !== 'Authentication required') {
                                    alert('Error creating Google Sheet: ' + error.message);
                                    console.error(error);
                                }
                            });
                        "
                        :disabled="exporting"
                        title="Open in Google Sheets">
                    <i class="fas fa-table" x-show="!exporting" style="margin-right: 0.25rem;"></i>
                    <i class="fas fa-spinner fa-spin" x-show="exporting" x-cloak style="margin-right: 0.25rem;"></i>
                    <span x-show="!exporting" style="white-space: nowrap;">Open in Sheets</span>
                    <span x-show="exporting" x-cloak style="white-space: nowrap;">Creating...</span>
                </button>
            </div>
        </div>
    </header>

    {{-- Modern Filter Bar --}}
    <div class="cfilter-bar">
        <div class="cfilter-content">
            {{-- Mobile Toggle --}}
            <button class="cfilter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="cfilter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="cfilter-items" :class="{ 'show': showFilters }">
                
                {{-- View Selector (Chip Style) --}}
                <div class="css-view-selector">
                    <button class="css-view-chip {{ $view === 'unshipped' ? 'active' : '' }}" 
                            wire:click="$set('view', 'unshipped')">
                        <i class="fas fa-box"></i>
                        Unshipped
                    </button>
                    <button class="css-view-chip {{ $view === 'overdue' ? 'active' : '' }}" 
                            wire:click="$set('view', 'overdue')">
                        <i class="fas fa-exclamation-triangle"></i>
                        Overdue
                    </button>
                    <button class="css-view-chip {{ $view === 'shipped' ? 'active' : '' }}" 
                            wire:click="$set('view', 'shipped')">
                        <i class="fas fa-check-circle"></i>
                        Shipped
                    </button>
                    <button class="css-view-chip {{ $view === 'all' ? 'active' : '' }}" 
                            wire:click="$set('view', 'all')">
                        <i class="fas fa-list"></i>
                        All
                    </button>
                    <button class="css-view-chip {{ $view === 'needsInvoice' ? 'active' : '' }}" 
                            wire:click="$set('view', 'needsInvoice')">
                        <i class="fas fa-file-invoice-dollar"></i>
                        Needs Invoice
                    </button>
                    <button class="css-view-chip {{ $view === 'financeNC' ? 'active' : '' }}" 
                            wire:click="$set('view', 'financeNC')">
                        <i class="fas fa-calculator"></i>
                        Finance NC
                    </button>
                </div>

                <div class="cfilter-divider"></div>

                {{-- Date Range Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $fromDate || $toDate ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-calendar-alt cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($fromDate && $toDate)
                                {{ \Carbon\Carbon::parse($fromDate)->format('d M') }} - {{ \Carbon\Carbon::parse($toDate)->format('d M') }}
                            @else
                                Date Range
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-date-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="cfilter-date-row">
                            <label>From</label>
                            <input type="date" class="cfilter-date-input" wire:model.live="fromDate">
                        </div>
                        <div class="cfilter-date-row">
                            <label>To</label>
                            <input type="date" class="cfilter-date-input" wire:model.live="toDate">
                        </div>
                        <div class="cfilter-date-presets">
                            <button type="button" class="cfilter-preset-btn" 
                                    wire:click="$set('fromDate', '{{ now()->startOfMonth()->format('Y-m-d') }}'); $set('toDate', '{{ now()->endOfMonth()->format('Y-m-d') }}')"
                                    @click="open = false">
                                This Month
                            </button>
                            <button type="button" class="cfilter-preset-btn"
                                    wire:click="$set('fromDate', '{{ now()->subDays(30)->format('Y-m-d') }}'); $set('toDate', '{{ now()->addDays(30)->format('Y-m-d') }}')"
                                    @click="open = false">
                                ±30 Days
                            </button>
                            <button type="button" class="cfilter-preset-btn"
                                    wire:click="$set('fromDate', '{{ now()->startOfQuarter()->format('Y-m-d') }}'); $set('toDate', '{{ now()->endOfQuarter()->format('Y-m-d') }}')"
                                    @click="open = false">
                                This Quarter
                            </button>
                        </div>
                        @if($fromDate || $toDate)
                            <button type="button" class="cfilter-date-clear" 
                                    wire:click="$set('fromDate', ''); $set('toDate', '')"
                                    @click="open = false">
                                <i class="fas fa-times"></i> Clear dates
                            </button>
                        @endif
                    </div>
                </div>

                {{-- Customer Multi-Select Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ count($customers) > 0 ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if(count($customers) > 0)
                                {{ count($customers) }} Customer{{ count($customers) > 1 ? 's' : '' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" x-ref="customerSearch">
                        </div>
                        <div class="cfilter-options">
                            @if(count($customers) > 0)
                                <button class="cfilter-option cfilter-clear-option" 
                                        wire:click="$set('customers', [])">
                                    <i class="fas fa-times-circle"></i>
                                    Clear selection
                                </button>
                            @endif
                            @foreach($this->customerList as $c)
                                <button class="cfilter-option {{ in_array($c->id, $customers) ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="toggleCustomer({{ $c->id }})">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if(in_array($c->id, $customers))
                                        <i class="fas fa-check cfilter-check"></i>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Season Multi-Select Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ count($seasons) > 0 ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-calendar-check cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if(count($seasons) > 0)
                                {{ count($seasons) }} Season{{ count($seasons) > 1 ? 's' : '' }}
                            @else
                                All Seasons
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search seasons..." x-model="search">
                        </div>
                        <div class="cfilter-options">
                            @if(count($seasons) > 0)
                                <button class="cfilter-option cfilter-clear-option" 
                                        wire:click="$set('seasons', [])">
                                    <i class="fas fa-times-circle"></i>
                                    Clear selection
                                </button>
                            @endif
                            @foreach($this->seasonList as $s)
                                <button class="cfilter-option {{ in_array($s->id, $seasons) ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($s->description) }}'.includes(search.toLowerCase())"
                                        wire:click="toggleSeason({{ $s->id }})">
                                    <i class="fas fa-tag"></i>
                                    {{ $s->description }}
                                    @if(in_array($s->id, $seasons))
                                        <i class="fas fa-check cfilter-check"></i>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Invoice Status Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $invoiceStatus ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-file-invoice cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($invoiceStatus === 'has_invoice')
                                Has Invoice
                            @elseif($invoiceStatus === 'no_invoice')
                                No Invoice
                            @else
                                Invoice Status
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$invoiceStatus ? 'selected' : '' }}" 
                                wire:click="$set('invoiceStatus', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All
                            @if(!$invoiceStatus)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $invoiceStatus === 'has_invoice' ? 'selected' : '' }}" 
                                wire:click="$set('invoiceStatus', 'has_invoice')" @click="open = false">
                            <i class="fas fa-check-circle"></i>
                            Has Invoice
                            @if($invoiceStatus === 'has_invoice')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $invoiceStatus === 'no_invoice' ? 'selected' : '' }}" 
                                wire:click="$set('invoiceStatus', 'no_invoice')" @click="open = false">
                            <i class="fas fa-times-circle"></i>
                            No Invoice
                            @if($invoiceStatus === 'no_invoice')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    </div>
                </div>

            </div>

            {{-- Active Filters Count & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="cfilter-active">
                    <span class="cfilter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="cfilter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                    </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Main Content --}}
    <div class="css-content" x-ref="scrollContainer">
        {{-- Loading Overlay --}}
        <div class="css-loading" wire:loading.delay wire:target="loadInitialDrops, view, search, fromDate, toDate, customers, seasons, invoiceStatus, sort, toggleCustomer, toggleSeason, toggleGroup">
            <div class="css-loading-spinner"></div>
        </div>

        @if($this->showGroupedView)
            {{-- GROUPED VIEW (Shipped) --}}
            @if($this->groupedDrops->isEmpty())
                <div class="css-empty">
                    <div class="css-empty-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3>No shipped drops found</h3>
                    <p>Shipped drops will appear here grouped by invoice</p>
                </div>
            @else
                {{-- Expand/Collapse All --}}
                <div class="css-group-controls">
                    <button class="css-btn css-btn-outline-sm" wire:click="expandAllGroups">
                        <i class="fas fa-expand-alt"></i> Expand All
                    </button>
                    <button class="css-btn css-btn-outline-sm" wire:click="collapseAllGroups">
                        <i class="fas fa-compress-alt"></i> Collapse All
                    </button>
                    <span class="css-group-count">{{ $this->groupedDrops->count() }} invoice groups</span>
                </div>

                <div class="css-invoice-groups">
                    @foreach($this->groupedDrops as $groupIndex => $group)
                        @php
                            $isExpanded = in_array((string)$group['id'], $expandedGroups);
                            $isUnassigned = $group['id'] === 'unassigned';
                            $groupNumber = $loop->iteration;
                        @endphp
                        <div class="css-invoice-group {{ $isUnassigned ? 'unassigned' : '' }} {{ $group['status'] }}" 
                             wire:key="group-{{ $group['id'] }}">
                            {{-- Group Header --}}
                            <div class="css-group-header" wire:click="toggleGroup('{{ $group['id'] }}')">
                                <div class="css-group-number">
                                    <span>{{ $groupNumber }}</span>
                                </div>
                                
                                <div class="css-group-expand">
                                    <i class="fas fa-chevron-{{ $isExpanded ? 'down' : 'right' }}"></i>
                                </div>
                                
                                <div class="css-group-info">
                                    <div class="css-group-main">
                                        <span class="css-group-ref {{ $isUnassigned ? 'unassigned' : '' }}">
                                            @if($isUnassigned)
                                                <i class="fas fa-exclamation-triangle"></i>
                                            @else
                                                <i class="fas fa-file-invoice"></i>
                                            @endif
                                            {{ $group['reference'] }}
                                        </span>
                                        <span class="css-group-sep">•</span>
                                        <span class="css-group-customer">{{ $group['customer'] }}</span>
                                        @if(!$isUnassigned)
                                            <span class="css-group-id">ID: {{ $group['id'] }}</span>
                                        @endif
                                    </div>
                                    <div class="css-group-meta">
                                        <span class="css-group-meta-item">
                                            <i class="fas fa-layer-group"></i> 
                                            <strong>{{ $group['drop_count'] }}</strong> drops
                                        </span>
                                        <span class="css-group-meta-item">
                                            <i class="fas fa-cubes"></i> 
                                            <strong>{{ number_format($group['total_shipped']) }}</strong> units shipped
                                        </span>
                                    </div>
                                </div>

                                @if(!$isUnassigned && $group['invoice'])
                                    <div class="css-group-status">
                                        <span class="css-status-badge css-status-{{ $group['status'] }}">
                                            @if($group['status'] === 'draft')
                                                <i class="fas fa-edit"></i> Draft
                                            @elseif($group['status'] === 'ready')
                                                <i class="fas fa-check"></i> Ready
                                            @elseif($group['status'] === 'sent_to_zoho')
                                                <i class="fas fa-paper-plane"></i> Sent
                                            @elseif($group['status'] === 'complete')
                                                <i class="fas fa-check-double"></i> Complete
                                            @endif
                                        </span>
                                    </div>
                                @endif
                            </div>

                            {{-- Group Content (Drops Table) --}}
                            @if($isExpanded)
                                <div class="css-group-content">
                                    <table class="css-table css-table-compact">
                                        <thead>
                                            <tr>
                                                <th>Drop</th>
                                                <th>PO</th>
                                                <th>Style</th>
                                                <th class="css-th-img">Image</th>
                                                <th class="text-end">Qty</th>
                                                <th class="text-end">Unit Price</th>
                                                <th class="text-end">Total Price</th>
                                                <th class="text-end">Shipped</th>
                                                <th>Ship Date</th>
                                                <th>Notes</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($group['drops'] as $drop)
                                                @php
                                                    $order = $drop->line?->order;
                                                    $colourway = $drop->line?->colourway;
                                                    $style = $colourway?->style_versions?->styles;
                                                    $design = $style?->designs;
                                                    $totalQty = $drop->sizes->sum('qty');
                                                    $totalShipped = $drop->sizes->sum('shipped_qty') ?: 0;
                                                    
                                                    // Calculate price info for grouped view
                                                    $unitPriceDisplay = null;
                                                    $totalPrice = null;
                                                    if ($drop->line && $drop->line->quantities) {
                                                        $prices = $drop->line->quantities->pluck('price')->filter(fn($p) => $p !== null && $p !== '')->unique()->values();
                                                        if ($prices->count() === 1) {
                                                            $unitPrice = (float)$prices->first();
                                                            $unitPriceDisplay = number_format($unitPrice, 2);
                                                            // Calculate total price: sum of (qty * price) for all quantities
                                                            $totalPrice = $drop->line->quantities->sum(function ($qty) {
                                                                return ($qty->qty ?? 0) * ((float)($qty->price ?? 0));
                                                            });
                                                        } elseif ($prices->count() > 1) {
                                                            $unitPriceDisplay = 'DIFF';
                                                            // Still calculate total even if unit prices differ
                                                            $totalPrice = $drop->line->quantities->sum(function ($qty) {
                                                                return ($qty->qty ?? 0) * ((float)($qty->price ?? 0));
                                                            });
                                                        }
                                                    }
                                                @endphp
                                                <tr class="css-row" wire:key="grouped-drop-{{ $drop->id }}">
                                                    <td><span class="css-drop-id">#{{ $drop->id }}</span></td>
                                                    <td><span class="css-po">{{ $order?->customer_po ?? '—' }}</span></td>
                                                    <td>
                                                        <div class="css-style-info">
                                                            @if($design)
                                                                <span class="css-design-id">RT{{ $design->id }}</span>
                                                            @endif
                                                            @if($style?->customer_ref)
                                                                <span class="css-customer-ref">{{ $style->customer_ref }}</span>
                                                            @endif
                                                            <span class="css-colour">{{ $colourway?->name ?? '—' }}</span>
                                                        </div>
                                                    </td>
                                                    <td class="css-td-img">
                                                        @if($colourway?->thumb_url)
                                                            <img src="{{ $colourway->thumb_url }}" 
                                                                 alt="{{ $colourway->name }}"
                                                                 class="css-thumbnail"
                                                                 loading="lazy"
                                                                 @click="imageModal = { show: true, src: '{{ $colourway->thumb_url }}', alt: '{{ $colourway->name }}' }">
                                                        @else
                                                            <div class="css-no-image"><i class="fas fa-image"></i></div>
                                                        @endif
                                                    </td>
                                                    <td class="text-end css-td-qty-hover">
                                                        <div class="css-sizes-editor" 
                                                             x-data="{ 
                                                                open: false,
                                                                dropdownStyle: {},
                                                                sizes: @js($drop->sizes->sortBy('size.order')->unique('sizes_id')->filter(fn($s) => $s->size)->map(function($s) use ($drop) {
                                                                    $quantity = $drop->line?->quantities->firstWhere('sizes_id', $s->sizes_id);
                                                                    $price = $quantity ? (float)($quantity->price ?? 0) : null;
                                                                    return [
                                                                        'id' => $s->id,
                                                                        'name' => $s->size->name,
                                                                        'qty' => (int)$s->qty,
                                                                        'shipped_qty' => (int)($s->shipped_qty ?? 0),
                                                                        'price' => $price,
                                                                        'total_price' => $price !== null ? ($s->qty * $price) : null,
                                                                    ];
                                                                })->values()),
                                                                openDropdown() {
                                                                    const rect = $refs.trigger.getBoundingClientRect();
                                                                    const padding = 40;
                                                                    const spaceBelow = window.innerHeight - rect.bottom - padding;
                                                                    const spaceAbove = rect.top - padding;
                                                                    const estimatedHeight = Math.min(this.sizes.length * 45 + 120, 350);
                                                                    
                                                                    let maxHeight = 'none';
                                                                    let style = {};
                                                                    
                                                                    const nearBottom = rect.bottom > window.innerHeight * 0.6;
                                                                    const openUpward = nearBottom || (spaceBelow < estimatedHeight && spaceAbove > spaceBelow);
                                                                    
                                                                    if (openUpward) {
                                                                        style = { bottom: (window.innerHeight - rect.top + 8) + 'px', left: Math.max(8, rect.left) + 'px', top: 'auto' };
                                                                        maxHeight = (spaceAbove - 20) + 'px';
                                                                    } else {
                                                                        style = { top: (rect.bottom + 8) + 'px', left: Math.max(8, rect.left) + 'px', bottom: 'auto' };
                                                                        maxHeight = (spaceBelow - 20) + 'px';
                                                                    }
                                                                    
                                                                    style['--dropdown-max-height'] = maxHeight;
                                                                    this.dropdownStyle = style;
                                                                    this.open = true;
                                                                },
                                                                saveQty(sizeId, value) {
                                                                    $wire.updateDropSizeQty(sizeId, value);
                                                                },
                                                                saveShipped(sizeId, value) {
                                                                    $wire.updateShippedQty(sizeId, value);
                                                                }
                                                             }"
                                                             @click.away="open = false">
                                                            <div class="css-qty-hover-trigger" x-ref="trigger" @mouseenter="openDropdown()" @click="open ? open = false : openDropdown()">
                                                                <span class="css-qty">{{ number_format($totalQty) }}</span>
                                                            </div>
                                                            
                                                            <div class="css-sizes-dropdown" x-show="open" x-cloak
                                                                 :style="dropdownStyle"
                                                                 x-transition:enter="transition ease-out duration-150"
                                                                 x-transition:enter-start="opacity-0 scale-95"
                                                                 x-transition:enter-end="opacity-100 scale-100"
                                                                 x-transition:leave="transition ease-in duration-100"
                                                                 x-transition:leave-start="opacity-100 scale-100"
                                                                 x-transition:leave-end="opacity-0 scale-95"
                                                                 @click.stop>
                                                                <div class="css-sizes-header">
                                                                    <span>Size Quantities</span>
                                                                    <button class="css-sizes-close" @click="open = false">
                                                                        <i class="fas fa-times"></i>
                                                                    </button>
                                                                </div>
                                                                <div class="css-sizes-table-wrapper">
                                                                <table class="css-sizes-table">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Size</th>
                                                                            <th>Order Qty</th>
                                                                            <th>Shipped</th>
                                                                            <th class="text-end">Unit Price</th>
                                                                            <th class="text-end">Total Price</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <template x-for="size in sizes" :key="size.id">
                                                                            <tr>
                                                                                <td class="css-size-label" x-text="size.name"></td>
                                                                                <td>
                                                                                    <input type="number" 
                                                                                           class="css-size-input"
                                                                                           x-model.number="size.qty"
                                                                                           @change="saveQty(size.id, size.qty)"
                                                                                           min="0">
                                                                                </td>
                                                                                <td>
                                                                                    <input type="number" 
                                                                                           class="css-size-input css-size-input-shipped"
                                                                                           x-model.number="size.shipped_qty"
                                                                                           @change="saveShipped(size.id, size.shipped_qty)"
                                                                                           min="0"
                                                                                           :max="size.qty">
                                                                                </td>
                                                                                <td class="text-end">
                                                                                    <span x-show="size.price !== null && size.price !== undefined" x-text="'{{ $order?->customer?->currency ?? '$' }}' + size.price.toFixed(2)"></span>
                                                                                    <span x-show="size.price === null || size.price === undefined" class="text-muted">—</span>
                                                                                </td>
                                                                                <td class="text-end">
                                                                                    <span x-show="size.total_price !== null && size.total_price !== undefined" x-text="'{{ $order?->customer?->currency ?? '$' }}' + size.total_price.toFixed(2)"></span>
                                                                                    <span x-show="size.total_price === null || size.total_price === undefined" class="text-muted">—</span>
                                                                                </td>
                                                                            </tr>
                                                                        </template>
                                                                    </tbody>
                                                                </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-end">
                                                        @if($unitPriceDisplay)
                                                            @if($unitPriceDisplay === 'DIFF')
                                                                <span class="text-muted">DIFF</span>
                                                            @else
                                                                <span>{{ $order?->customer?->currency ?? '$' }}{{ $unitPriceDisplay }}</span>
                                                            @endif
                                                        @else
                                                            <span class="text-muted">—</span>
                                                        @endif
                                                    </td>
                                                    <td class="text-end">
                                                        @if($totalPrice !== null)
                                                            <span>{{ $order?->customer?->currency ?? '$' }}{{ number_format($totalPrice, 2) }}</span>
                                                        @else
                                                            <span class="text-muted">—</span>
                                                        @endif
                                                    </td>
                                                    <td class="text-end"><span class="css-qty css-qty-shipped">{{ number_format($totalShipped ?: $totalQty) }}</span></td>
                                                    <td>
                                                        @if($drop->shipped_date)
                                                            <span class="css-ship-date">{{ $drop->shipped_date->format('d M Y') }}</span>
                                                        @else
                                                            <span class="css-placeholder">—</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($drop->fn_notes)
                                                            <span class="css-notes-preview" title="{{ $drop->fn_notes }}">
                                                                {{ Str::limit($drop->fn_notes, 25) }}
                                                            </span>
                                                        @else
                                                            <span class="css-placeholder">—</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr class="css-group-totals">
                                                <td colspan="7" class="text-end"><strong>Group Totals:</strong></td>
                                                <td class="text-end"><strong>{{ number_format($group['total_qty']) }}</strong></td>
                                                <td class="text-end"><strong class="css-qty-shipped">{{ number_format($group['total_shipped']) }}</strong></td>
                                                <td colspan="2"></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @endif
        @elseif(empty($loadedDrops))
            {{-- Empty State --}}
            <div class="css-empty">
                <div class="css-empty-icon">
                    <i class="fas fa-shipping-fast"></i>
                </div>
                <h3>No drops found</h3>
                <p>Try adjusting your search or filters</p>
                @if($this->activeFiltersCount > 0)
                    <button class="css-btn css-btn-primary mt-3" wire:click="clearFilters">
                        Clear all filters
                    </button>
                @endif
            </div>
        @else
            {{-- Table --}}
            <div class="css-table-wrapper">
                <table class="css-table">
                    <thead>
                        <tr>
                            <th class="css-th-check">
                                <input type="checkbox" 
                                       class="css-checkbox"
                                       wire:model.live="selectAll"
                                       wire:click="toggleSelectAll">
                            </th>
                            <th class="css-th-sortable" wire:click="sort('id')">
                                Drop
                                @if($sortBy === 'id')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th>Season</th>
                            <th>Customer</th>
                            <th>PO</th>
                            <th>Style</th>
                            <th>Description</th>
                            <th>Colour</th>
                            <th class="css-th-img">Image</th>
                            <th class="text-end">Qty</th>
                            <th class="text-end">Unit Price</th>
                            <th class="text-end">Total Price</th>
                            <th class="text-end">Shipped</th>
                            <th class="css-th-sortable" wire:click="sort('exfty')">
                                Ex-Fty
                                @if($sortBy === 'exfty')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </th>
                            <th class="text-center">Shipped</th>
                            <th>Invoice</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- Skeleton Loading Rows --}}
                        <template x-if="false" wire:loading.block wire:target="view, fromDate, toDate, customers, seasons">
                            @for($i = 0; $i < 10; $i++)
                                <tr class="css-skeleton-row">
                                    <td colspan="19">
                                        <div class="css-skeleton"></div>
                                    </td>
                                </tr>
                            @endfor
                        </template>

                        @php 
                            $lastInvoiceId = 'INITIAL'; 
                            $seenInvoices = [];
                            $items = $this->organizedDrops;
                        @endphp
                        @foreach($items as $index => $item)
                            @php
                                $drop = $item['drop'];
                                $invoiceId = $drop['commission_invoice_groups_id'];
                                $isFirstInGroup = $invoiceId && !in_array($invoiceId, $seenInvoices);
                                
                                // Check if next item is different group
                                $nextItem = $items[$index + 1] ?? null;
                                $nextInvoiceId = $nextItem ? $nextItem['drop']['commission_invoice_groups_id'] : null;
                                $isLastInGroup = $invoiceId && ($nextInvoiceId !== $invoiceId);
                                
                                if ($isFirstInGroup) {
                                    $seenInvoices[] = $invoiceId;
                                }
                                $lastInvoiceId = $invoiceId;
                                
                                $groupClass = $invoiceId ? 'grouped' : 'no-invoice';
                            @endphp
                            
                            <tr class="css-row css-row-{{ $groupClass }} {{ $drop['shipped'] ? 'css-row-shipped' : 'css-row-unshipped' }} {{ $isFirstInGroup ? 'css-row-first' : '' }} {{ $isLastInGroup ? 'css-row-last' : '' }}" 
                                wire:key="drop-{{ $drop['id'] }}"
                                data-invoice="{{ $invoiceId }}"
                                data-group="{{ $item['groupIndex'] }}">
                                
                                {{-- Checkbox --}}
                                <td class="css-td-check">
                                    <input type="checkbox" 
                                           class="css-checkbox"
                                           wire:click="toggleSelect({{ $drop['id'] }})"
                                           @checked($selected[$drop['id']] ?? false)>
                                </td>

                                {{-- Drop ID --}}
                                <td>
                                    <span class="css-drop-id">#{{ $drop['id'] }}</span>
                                </td>

                                {{-- Season --}}
                                <td>
                                    <span class="css-badge css-badge-muted">{{ $drop['season_description'] ?? '—' }}</span>
                                </td>

                                {{-- Customer --}}
                                <td>
                                    <span class="css-customer">{{ $drop['customer_name'] ?? '—' }}</span>
                                </td>

                                {{-- PO --}}
                                <td>
                                    <span class="css-po">{{ $drop['customer_po'] ?? '—' }}</span>
                                </td>

                                {{-- Style --}}
                                <td>
                                    <div class="css-style-info">
                                        @if($drop['design_id'])
                                            <span class="css-design-id">RT{{ $drop['design_id'] }}</span>
                                        @endif
                                        @if($drop['customer_ref'])
                                            <span class="css-customer-ref">{{ $drop['customer_ref'] }}</span>
                                        @endif
                                    </div>
                                </td>

                                {{-- Description --}}
                                <td>
                                    <span class="css-description" title="{{ $drop['design_description'] }}">
                                        {{ Str::limit($drop['design_description'], 30) ?? '—' }}
                                    </span>
                                </td>

                                {{-- Colour --}}
                                <td>
                                    <span class="css-colour">{{ $drop['colourway_name'] ?? '—' }}</span>
                                </td>

                                {{-- Image --}}
                                <td class="css-td-img">
                                    @if($drop['colourway_thumb_url'])
                                        <img 
                                            src="{{ $drop['colourway_thumb_url'] }}" 
                                            alt="{{ $drop['colourway_name'] }}"
                                            class="css-thumbnail"
                                            loading="lazy"
                                            @click="imageModal = { show: true, src: '{{ $drop['colourway_thumb_url'] }}', alt: '{{ $drop['colourway_name'] }}' }"
                                        >
                                    @else
                                        <div class="css-no-image">
                                            <i class="fas fa-image"></i>
                                        </div>
                                    @endif
                                </td>


                                {{-- Total Qty --}}
                                <td class="text-end css-td-qty-hover">
                                    <div class="css-sizes-editor" 
                                         x-data="{ 
                                            open: false,
                                            dropdownStyle: {},
                                            sizes: @js($drop['sizes']),
                                            openDropdown() {
                                                const rect = $refs.trigger.getBoundingClientRect();
                                                const padding = 40;
                                                const spaceBelow = window.innerHeight - rect.bottom - padding;
                                                const spaceAbove = rect.top - padding;
                                                const estimatedHeight = Math.min(this.sizes.length * 45 + 120, 350);
                                                
                                                let maxHeight = 'none';
                                                let style = {};
                                                
                                                // Prefer opening upward if near bottom half of screen or not enough space below
                                                const nearBottom = rect.bottom > window.innerHeight * 0.6;
                                                const openUpward = nearBottom || (spaceBelow < estimatedHeight && spaceAbove > spaceBelow);
                                                
                                                if (openUpward) {
                                                    style = { bottom: (window.innerHeight - rect.top + 8) + 'px', left: Math.max(8, rect.left) + 'px', top: 'auto' };
                                                    maxHeight = (spaceAbove - 20) + 'px';
                                                } else {
                                                    style = { top: (rect.bottom + 8) + 'px', left: Math.max(8, rect.left) + 'px', bottom: 'auto' };
                                                    maxHeight = (spaceBelow - 20) + 'px';
                                                }
                                                
                                                style['--dropdown-max-height'] = maxHeight;
                                                this.dropdownStyle = style;
                                                this.open = true;
                                            },
                                            saveQty(sizeId, value) {
                                                $wire.updateDropSizeQty(sizeId, value);
                                            },
                                            saveShipped(sizeId, value) {
                                                $wire.updateShippedQty(sizeId, value);
                                            }
                                         }"
                                         @click.away="open = false">
                                        
                                        <div class="css-qty-hover-trigger" x-ref="trigger" @mouseenter="openDropdown()" @click="open ? open = false : openDropdown()">
                                            <span class="css-qty">{{ number_format($drop['total_qty']) }}</span>
                                        </div>
                                        
                                        <div class="css-sizes-dropdown" x-show="open" x-cloak
                                             :style="dropdownStyle"
                                             x-transition:enter="transition ease-out duration-150"
                                             x-transition:enter-start="opacity-0 scale-95"
                                             x-transition:enter-end="opacity-100 scale-100"
                                             x-transition:leave="transition ease-in duration-100"
                                             x-transition:leave-start="opacity-100 scale-100"
                                             x-transition:leave-end="opacity-0 scale-95"
                                             @click.stop>
                                            <div class="css-sizes-header">
                                                <span>Size Quantities</span>
                                                <button class="css-sizes-close" @click="open = false">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </div>
                                            <div class="css-sizes-table-wrapper">
                                            <table class="css-sizes-table">
                                                <thead>
                                                    <tr>
                                                        <th>Size</th>
                                                        <th>Order Qty</th>
                                                        <th>Shipped</th>
                                                        <th class="text-end">Unit Price</th>
                                                        <th class="text-end">Total Price</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <template x-for="size in sizes" :key="size.id">
                                                        <tr>
                                                            <td class="css-size-label" x-text="size.name"></td>
                                                            <td>
                                                                <input type="number" 
                                                                       class="css-size-input"
                                                                       x-model.number="size.qty"
                                                                       @change="saveQty(size.id, size.qty)"
                                                                       min="0">
                                                            </td>
                                                            <td>
                                                                <input type="number" 
                                                                       class="css-size-input css-size-input-shipped"
                                                                       x-model.number="size.shipped_qty"
                                                                       @change="saveShipped(size.id, size.shipped_qty)"
                                                                       min="0"
                                                                       :max="size.qty">
                                                            </td>
                                                            <td class="text-end">
                                                                <span x-show="size.price !== null && size.price !== undefined" x-text="'{{ $drop['customer_currency'] ?? '$' }}' + size.price.toFixed(2)"></span>
                                                                <span x-show="size.price === null || size.price === undefined" class="text-muted">—</span>
                                                            </td>
                                                            <td class="text-end">
                                                                <span x-show="size.total_price !== null && size.total_price !== undefined" x-text="'{{ $drop['customer_currency'] ?? '$' }}' + size.total_price.toFixed(2)"></span>
                                                                <span x-show="size.total_price === null || size.total_price === undefined" class="text-muted">—</span>
                                                            </td>
                                                        </tr>
                                                    </template>
                                                </tbody>
                                            </table>
                                            </div>
                                        </div>
                                    </div>
                                </td>

                                {{-- Unit Price --}}
                                <td class="text-end">
                                    @if(isset($drop['unit_price_display']))
                                        @if($drop['unit_price_display'] === 'DIFF')
                                            <span class="text-muted">DIFF</span>
                                        @else
                                            <span>{{ $drop['customer_currency'] ?? '$' }}{{ $drop['unit_price_display'] }}</span>
                                        @endif
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>

                                {{-- Total Price --}}
                                <td class="text-end">
                                    @if(isset($drop['total_price']) && $drop['total_price'] !== null)
                                        <span>{{ $drop['customer_currency'] ?? '$' }}{{ number_format($drop['total_price'], 2) }}</span>
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>

                                {{-- Shipped Qty --}}
                                <td class="text-end">
                                    <span class="css-qty {{ $drop['total_shipped'] > 0 ? 'css-qty-shipped' : '' }}">
                                        {{ number_format($drop['total_shipped']) }}
                                    </span>
                                </td>

                                {{-- Ex-Fty Date --}}
                                <td class="css-td-editable" 
                                    x-data="{ editing: false, value: '{{ $drop['exfty'] ?? '' }}' }">
                                    <div x-show="!editing" 
                                         @click="editing = true; $nextTick(() => $refs.dateInput.focus())"
                                         class="css-editable-cell {{ $drop['status_class'] === 'overdue' ? 'css-overdue' : '' }}">
                                        @if($drop['exfty'])
                                            <span>{{ $drop['exfty_formatted'] }}</span>
                                        @else
                                            <span class="css-placeholder">Set date</span>
                                        @endif
                                        <i class="fas fa-pencil-alt css-edit-icon"></i>
                                    </div>
                                    <input 
                                        x-show="editing"
                                        x-cloak
                                        x-ref="dateInput"
                                        type="date"
                                        class="css-input css-input-inline"
                                        x-model="value"
                                        @blur="editing = false; $wire.updateExfty({{ $drop['id'] }}, value)"
                                        @keydown.enter="editing = false; $wire.updateExfty({{ $drop['id'] }}, value)"
                                        @keydown.escape="editing = false"
                                    >
                                </td>

                                {{-- Shipped Toggle --}}
                                <td class="text-center" 
                                    x-data="{ checked: {{ $drop['shipped'] ? 'true' : 'false' }} }"
                                    @shipped-reset-{{ $drop['id'] }}.window="checked = false"
                                    @shipped-set-{{ $drop['id'] }}.window="checked = true"
                                    wire:key="shipped-toggle-{{ $drop['id'] }}">
                                    <label class="css-toggle">
                                        <input type="checkbox" 
                                               x-model="checked"
                                               @change="$wire.updateShipped({{ $drop['id'] }}, checked)">
                                        <span class="css-toggle-slider"></span>
                                    </label>
                                </td>

                                {{-- Invoice Group --}}
                                <td>
                                    @if($drop['invoice_ref'])
                                        <span class="css-badge css-badge-invoice">
                                            {{ $drop['invoice_ref'] }}
                                        </span>
                                    @else
                                        <span class="css-badge css-badge-none">—</span>
                                    @endif
                                </td>

                                {{-- Finance Notes --}}
                                <td class="css-td-editable"
                                    x-data="{ editing: false, value: @js($drop['fn_notes'] ?? '') }">
                                    <div x-show="!editing" 
                                         @click="editing = true; $nextTick(() => $refs.notesInput.focus())"
                                         class="css-editable-cell css-notes-cell">
                                        @if($drop['fn_notes'])
                                            <span title="{{ $drop['fn_notes'] }}">{{ Str::limit($drop['fn_notes'], 20) }}</span>
                                        @else
                                            <span class="css-placeholder">Add note</span>
                                        @endif
                                        <i class="fas fa-pencil-alt css-edit-icon"></i>
                                    </div>
                                    <input 
                                        x-show="editing"
                                        x-cloak
                                        x-ref="notesInput"
                                        type="text"
                                        class="css-input css-input-inline"
                                        x-model="value"
                                        @blur="editing = false; $wire.updateFnNotes({{ $drop['id'] }}, value)"
                                        @keydown.enter="editing = false; $wire.updateFnNotes({{ $drop['id'] }}, value)"
                                        @keydown.escape="editing = false"
                                    >
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Loading More Indicator --}}
            @if($hasMore)
                <div class="csamp-load-more" wire:loading.remove wire:target="loadMore">
                    <div class="csamp-load-more-trigger" x-intersect="$wire.loadMore()">
                        <i class="fas fa-circle-notch fa-spin"></i>
                        <span>Loading more...</span>
                    </div>
                </div>
            @else
                <div class="csamp-end-of-list">
                    <span>{{ count($loadedDrops) }} drops loaded</span>
                </div>
            @endif

            {{-- Loading indicator when fetching more --}}
            <div class="csamp-load-more" wire:loading wire:target="loadMore">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>Loading more...</span>
            </div>
        @endif
    </div>

    {{-- Image Modal --}}
    <div class="css-modal-backdrop" 
         x-show="imageModal.show" 
         x-cloak
         @click="imageModal.show = false"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0">
        <div class="css-image-modal" @click.stop>
            <button class="css-modal-close" @click="imageModal.show = false">
                <i class="fas fa-times"></i>
            </button>
            <img :src="imageModal.src" :alt="imageModal.alt">
        </div>
    </div>

    {{-- Invoice Group Modal --}}
    @if($showInvoiceModal)
        <div class="css-modal-backdrop" wire:click="closeInvoiceModal">
            <div class="css-modal" wire:click.stop>
                <div class="css-modal-header">
                    <h3>Assign to Invoice Group</h3>
                    <button class="css-modal-close" wire:click="closeInvoiceModal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="css-modal-body">
                    <p class="css-modal-info">
                        <i class="fas fa-info-circle"></i>
                        Assigning {{ $this->selectedCount }} drop(s) to an invoice group
                    </p>

                    <div class="css-form-group">
                        <label class="css-label">Select Existing Group</label>
                        <select class="css-select" wire:model="selectedInvoiceGroup">
                            <option value="">-- Select --</option>
                            @foreach($this->invoiceGroups as $group)
                                <option value="{{ $group->id }}">
                                    {{ $group->reference }} ({{ ucfirst($group->status) }})
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="css-divider">
                        <span>or</span>
                    </div>

                    <div class="css-form-group">
                        <label class="css-label">Create New Group</label>
                        <input type="text" 
                               class="css-input" 
                               placeholder="Enter invoice reference..."
                               wire:model="newInvoiceRef">
                    </div>
                </div>
                <div class="css-modal-footer">
                    <button class="css-btn css-btn-ghost" wire:click="closeInvoiceModal">Cancel</button>
                    <button class="css-btn css-btn-primary" wire:click="assignToInvoiceGroup">
                        <i class="fas fa-check"></i>
                        Assign
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Toast Notifications --}}
    <div class="css-toast-container"
         x-data="{ toasts: [] }"
         @notify.window="
            let id = Date.now();
            toasts.push({ id, type: $event.detail.type, message: $event.detail.message });
            setTimeout(() => toasts = toasts.filter(t => t.id !== id), 3000);
         ">
        <template x-for="toast in toasts" :key="toast.id">
            <div class="css-toast" :class="'css-toast-' + toast.type"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0">
                <i class="fas" :class="{
                    'fa-check-circle': toast.type === 'success',
                    'fa-exclamation-circle': toast.type === 'error',
                    'fa-info-circle': toast.type === 'info'
                }"></i>
                <span x-text="toast.message"></span>
            </div>
        </template>
    </div>

    {{-- Selection Floating Toast --}}
    @if($this->selectedCount > 0)
        <div class="comm-selection-toast" 
             wire:key="selection-float"
             x-data
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform translate-y-4"
             x-transition:enter-end="opacity-100 transform translate-y-0">
            <div class="comm-selection-toast-content">
                <div class="comm-selection-toast-icon">
                    <span>{{ $this->selectedCount }}</span>
                </div>
                <div class="comm-selection-toast-text">
                    <span class="comm-selection-toast-title">{{ $this->selectedCount }} {{ Str::plural('drop', $this->selectedCount) }} selected</span>
                    <span class="comm-selection-toast-desc">Ready for bulk actions</span>
                </div>
                <button class="comm-selection-toast-btn success" wire:click="markSelectedShipped" wire:confirm="Mark {{ $this->selectedCount }} drops as shipped?">
                    <i class="fas fa-check"></i>
                    Mark Shipped
                </button>
                <button class="comm-selection-toast-btn" wire:click="openInvoiceModal">
                    <i class="fas fa-file-invoice"></i>
                    Assign Invoice
                </button>
                <button class="comm-selection-toast-close" wire:click="clearSelection" title="Clear selection">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    @endif
</div>
