<div class="commission-samples" 
     x-data="{ 
         init() {
             this.setupInfiniteScroll();
         },
         setupInfiniteScroll() {
             const container = this.$refs.scrollContainer;
             if (!container) return;
             
             container.addEventListener('scroll', () => {
                 if (container.scrollTop + container.clientHeight >= container.scrollHeight - 200) {
                     if ($wire.hasMore && !$wire.isLoading) {
                         $wire.loadMore();
                     }
                 }
             });
         }
     }">
    {{-- Selection Floating Toast --}}
    @if($this->selectedCount > 0)
        <div class="comm-selection-toast" 
             wire:key="selection-float"
             x-data
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform translate-y-4"
             x-transition:enter-end="opacity-100 transform translate-y-0">
            <div class="comm-selection-toast-content">
                <div class="comm-selection-toast-icon">
                    <span>{{ $this->selectedCount }}</span>
                </div>
                <div class="comm-selection-toast-text">
                    <span class="comm-selection-toast-title">{{ $this->selectedCount }} {{ Str::plural('sample', $this->selectedCount) }} selected</span>
                    <span class="comm-selection-toast-desc">Ready for bulk actions</span>
            </div>
                <button class="comm-selection-toast-btn" wire:click="openBulkEdit">
                    <i class="fas fa-edit"></i>
                    Bulk Edit
                </button>
                <button class="comm-selection-toast-close" wire:click="clearSelection" title="Clear selection">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    @endif

    {{-- Header --}}
    <x-commission.page-header 
        title="Samples"
        :stats="[
            ['label' => 'Total', 'value' => $this->stats['total'], 'class' => 'total'],
            ['label' => 'Pending', 'value' => $this->stats['pending'], 'class' => 'pending'],
            ['label' => 'Approved', 'value' => $this->stats['approved'], 'class' => 'approved'],
            ['label' => 'Sent', 'value' => $this->stats['sent'], 'class' => 'sent'],
        ]"
        searchPlaceholder="Search by RT, description, colourway..."
        searchModel="search"
        :search="$search"
    >
        <x-slot name="actions">
            <button class="comm-create-btn" wire:click="$dispatch('create-new-sample')">
                <i class="fas fa-plus"></i>
                <span>New Sample</span>
            </button>
        </x-slot>
    </x-commission.page-header>

    {{-- Filters Bar --}}
    <div class="cfilter-bar" x-data="{ showFilters: true }">
        <div class="cfilter-content">
            {{-- Mobile Toggle --}}
            <button class="cfilter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="cfilter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="cfilter-items" :class="{ 'show': showFilters }">
                {{-- Season Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $season ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-snowflake cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($season)
                                {{ $this->seasons->firstWhere('id', $season)?->description ?? 'Season' }}
                            @else
                                All Seasons
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$season ? 'selected' : '' }}" 
                                wire:click="$set('season', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Seasons
                            @if(!$season)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
            @foreach($this->seasons as $s)
                            <button class="cfilter-option {{ $season == $s->id ? 'selected' : '' }}" 
                                    wire:click="$set('season', '{{ $s->id }}')" @click="open = false">
                                <i class="fas fa-snowflake"></i>
                                {{ $s->description }}
                                @if($season == $s->id)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
            @endforeach
                    </div>
                </div>

                {{-- Customer Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $customer ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($customer)
                                {{ $this->customers->firstWhere('id', $customer)?->name ?? 'Customer' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" @click.stop>
                        </div>
                        <div class="cfilter-options">
                            <button class="cfilter-option {{ !$customer ? 'selected' : '' }}" 
                                    x-show="!search || 'all customers'.includes(search.toLowerCase())"
                                    wire:click="$set('customer', '')" @click="open = false; search = ''">
                                <i class="fas fa-users"></i>
                                All Customers
                                @if(!$customer)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
            @foreach($this->customers as $c)
                                <button class="cfilter-option {{ $customer == $c->id ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="$set('customer', '{{ $c->id }}')" @click="open = false; search = ''">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if($customer == $c->id)<i class="fas fa-check cfilter-check"></i>@endif
                                </button>
            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Sample Type Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $sampleType ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-tshirt cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($sampleType)
                                {{ $this->sampleTypes->firstWhere('id', $sampleType)?->name ?? 'Type' }}
                            @else
                                All Types
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$sampleType ? 'selected' : '' }}" 
                                wire:click="$set('sampleType', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Types
                            @if(!$sampleType)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
            @foreach($this->sampleTypes as $type)
                            <button class="cfilter-option {{ $sampleType == $type->id ? 'selected' : '' }}" 
                                    wire:click="$set('sampleType', '{{ $type->id }}')" @click="open = false">
                                <i class="fas fa-tag"></i>
                                {{ $type->name }}
                                @if($sampleType == $type->id)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
            @endforeach
                    </div>
                </div>

                {{-- Status Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $status ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-check-circle cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($status)
                                {{ ucfirst($status) }}
                            @else
                                All Status
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$status ? 'selected' : '' }}" 
                                wire:click="$set('status', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Status
                            @if(!$status)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'pending' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'pending')" @click="open = false">
                            <i class="fas fa-clock"></i>
                            Pending
                            @if($status === 'pending')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'approved' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'approved')" @click="open = false">
                            <i class="fas fa-check"></i>
                            Approved
                            @if($status === 'approved')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $status === 'rejected' ? 'selected' : '' }}" 
                                wire:click="$set('status', 'rejected')" @click="open = false">
                            <i class="fas fa-times"></i>
                            Rejected
                            @if($status === 'rejected')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    </div>
                </div>
            </div>

            {{-- Active Filters Summary & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="cfilter-active">
                    <span class="cfilter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="cfilter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                    </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Content --}}
    <div class="csamp-content" x-ref="scrollContainer">
        @if(empty($loadedSamples))
            {{-- Empty State --}}
            <div class="csamp-empty">
                <div class="csamp-empty-icon">
                    <i class="fas fa-tshirt"></i>
                </div>
                <h3>No samples found</h3>
                <p>Try adjusting your search or filters</p>
                @if($this->activeFiltersCount > 0)
                    <button class="btn btn-commission mt-3" wire:click="clearFilters">
                        Clear all filters
                    </button>
                @endif
            </div>
        @else
            {{-- Table --}}
            <div class="csamp-table-container">
                <table class="csamp-table">
                    <thead>
                        <tr>
                            <th class="csamp-th-checkbox">
                                <input type="checkbox" 
                                       class="csamp-checkbox"
                                       wire:key="select-all-checkbox"
                                       wire:model.live="selectAll"
                                       title="Select all loaded">
                            </th>
                            <th class="csamp-th-style">Style</th>
                            <th>Colourway</th>
                            <th>Type</th>
                            <th>Size</th>
                            <th class="text-center">Qty</th>
                            <th class="csamp-th-sortable" wire:click="sort('date_expected')">
                                <span>Expected</span>
                                @if($sortBy === 'date_expected')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="csamp-th-sortable" wire:click="sort('date_sent')">
                                <span>Sent</span>
                                @if($sortBy === 'date_sent')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th>Tracking</th>
                            <th>Status</th>
                            <th class="csamp-th-actions"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($loadedSamples as $sample)
                            @php
                                $sampleIdStr = (string) $sample['id'];
                                $isSelected = in_array($sampleIdStr, $selected);
                                $statusClass = match($sample['status']) {
                                    'approved' => 'approved',
                                    'rejected' => 'rejected',
                                    default => 'pending'
                                };
                            @endphp
                            <tr class="csamp-row {{ $isSelected ? 'csamp-row-selected' : '' }}" 
                                wire:key="sample-row-{{ $sample['id'] }}"
                                style="cursor: pointer;">
                                
                                {{-- Checkbox --}}
                                <td class="csamp-td-checkbox" wire:click.stop>
                                    <input type="checkbox" 
                                           class="csamp-checkbox"
                                           wire:key="sample-checkbox-{{ $sample['id'] }}"
                                           wire:model.live="selected"
                                           value="{{ $sample['id'] }}"
                                           @checked($isSelected)>
                                </td>
                                
                                {{-- Style Info --}}
                                <td class="csamp-td-style" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    <div class="csamp-style-info">
                                        <span class="csamp-rt">{{ $sample['design_id'] }}</span>
                                        <span class="csamp-desc">{{ Str::limit($sample['design_description'], 25) }}</span>
                                    </div>
                                    <div class="csamp-style-meta">
                                        <span class="csamp-customer">{{ $sample['customer_name'] }}</span>
                                        <span class="csamp-season">{{ $sample['season_description'] }}</span>
                                    </div>
                                </td>
                                
                                {{-- Colourway --}}
                                <td class="csamp-td-colourway" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    <span class="csamp-colourway-name">{{ $sample['colourway_name'] ?? '—' }}</span>
                                </td>
                                
                                {{-- Sample Type --}}
                                <td class="csamp-td-type" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    <span class="csamp-type-badge csamp-type-{{ strtolower(str_replace(['/', ' '], '-', $sample['sample_type_name'] ?? 'other')) }}">
                                        {{ $sample['sample_type_name'] ?? '—' }}
                                    </span>
                                </td>
                                
                                {{-- Size --}}
                                <td class="csamp-td-size" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    {{ $sample['size_name'] ?? '—' }}
                                </td>
                                
                                {{-- Qty --}}
                                <td class="csamp-td-qty text-center" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    {{ $sample['qty'] ?? 1 }}
                                </td>
                                
                                {{-- Expected Date --}}
                                <td class="csamp-td-date" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    @if($sample['date_expected'])
                                        <span class="csamp-date">{{ $sample['date_expected'] }}</span>
                                    @else
                                        <span class="csamp-date-empty">—</span>
                                    @endif
                                </td>
                                
                                {{-- Sent Date --}}
                                <td class="csamp-td-date" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    @if($sample['date_sent'])
                                        <span class="csamp-date csamp-date-sent">{{ $sample['date_sent'] }}</span>
                                    @else
                                        <span class="csamp-date-empty">—</span>
                                    @endif
                                </td>
                                
                                {{-- Tracking --}}
                                <td class="csamp-td-tracking" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    @if($sample['tracking'])
                                        <span class="csamp-tracking" title="{{ $sample['tracking'] }}">
                                            {{ Str::limit($sample['tracking'], 12) }}
                                        </span>
                                    @else
                                        <span class="csamp-tracking-empty">—</span>
                                    @endif
                                </td>
                                
                                {{-- Status --}}
                                <td class="csamp-td-status" wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                    <span class="csamp-status csamp-status-{{ $statusClass }}">
                                        {{ ucfirst($sample['status']) }}
                                    </span>
                                </td>
                                
                                {{-- Actions --}}
                                <td class="csamp-td-actions">
                                    <button class="csamp-action-btn" title="Edit sample" 
                                            wire:click.stop="$dispatch('open-sample-edit', { sampleId: {{ $sample['id'] }} })">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Loading More Indicator --}}
            @if($hasMore)
                <div class="csamp-load-more" wire:loading.remove wire:target="loadMore">
                    <div class="csamp-load-more-trigger" x-intersect="$wire.loadMore()">
                        <i class="fas fa-circle-notch fa-spin"></i>
                        <span>Loading more...</span>
                    </div>
                </div>
            @else
                <div class="csamp-end-of-list">
                    <span>{{ count($loadedSamples) }} samples loaded</span>
                </div>
            @endif

            {{-- Loading indicator when fetching more --}}
            <div class="csamp-load-more" wire:loading wire:target="loadMore">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>Loading more...</span>
            </div>
        @endif
    </div>

    {{-- Sample Edit Sidebar --}}
    @livewire('commission.sample-edit')
    
    {{-- Bulk Edit Sidebar --}}
    @livewire('commission.sample-bulk-edit')
</div>
