<div x-data="{ showConfirm: false }" 
     x-on:confirm-close.window="showConfirm = true"
     x-on:keydown.escape.window="if ($wire.isOpen && !showConfirm && !$wire.showStylePicker) $wire.close()">
    
    {{-- Backdrop --}}
    @if($isOpen)
        <div class="cse-backdrop" wire:click="close"></div>
    @endif

    {{-- Unsaved Changes Confirmation --}}
    <div class="cse-confirm-modal" x-show="showConfirm" x-cloak>
        <div class="cse-confirm-backdrop" @click="showConfirm = false"></div>
        <div class="cse-confirm-dialog">
            <div class="cse-confirm-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h3>Unsaved Changes</h3>
            <p>You have unsaved changes. Are you sure you want to close?</p>
            <div class="cse-confirm-actions">
                <button class="cse-btn cse-btn-secondary" @click="showConfirm = false">
                    Keep Editing
                </button>
                <button class="cse-btn cse-btn-danger" @click="showConfirm = false; $wire.forceClose()">
                    Discard Changes
                </button>
            </div>
        </div>
    </div>

    {{-- Slide Panel --}}
    <div class="cse-panel {{ $isOpen ? 'open' : '' }}">
        @if($isOpen)
            {{-- Header --}}
            <header class="cse-header">
                <div class="cse-header-info">
                    @if($isNewSample)
                        <span class="cse-badge cse-badge-new"><i class="fas fa-plus"></i></span>
                        <h2 class="cse-title">New Sample</h2>
                    @else
                        @php
                            $colourway = $this->sample?->colourways;
                            $design = $colourway?->style_versions?->styles?->designs;
                        @endphp
                        <span class="cse-badge">{{ $design?->id }}</span>
                        <h2 class="cse-title">{{ Str::limit($design?->description, 30) }}</h2>
                    @endif
                    @if($isDirty)
                        <span class="cse-dirty-badge">Unsaved</span>
                    @endif
                </div>
                <button class="cse-close" wire:click="close">
                    <i class="fas fa-times"></i>
                </button>
            </header>

            {{-- Toast Notifications --}}
            @if(session()->has('message'))
                <div class="cse-toast cse-toast-success" 
                     x-data="{ show: true }" 
                     x-show="show" 
                     x-init="setTimeout(() => show = false, 3000)"
                     x-transition>
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('message') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif
            @if(session()->has('error'))
                <div class="cse-toast cse-toast-error" x-data="{ show: true }" x-show="show" x-transition>
                    <i class="fas fa-exclamation-circle"></i>
                    <span>{{ session('error') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif

            {{-- Tabs --}}
            <nav class="cse-tabs">
                <button 
                    class="cse-tab {{ $activeTab === 'details' ? 'active' : '' }}"
                    wire:click="$set('activeTab', 'details')"
                >
                    <i class="fas fa-info-circle"></i>
                    Details
                </button>
                @if(!$isNewSample)
                    <button 
                        class="cse-tab {{ $activeTab === 'history' ? 'active' : '' }}"
                        wire:click="$set('activeTab', 'history')"
                    >
                        <i class="fas fa-history"></i>
                        History
                    </button>
                @endif
            </nav>

            {{-- Content --}}
            <div class="cse-content">
                @if($activeTab === 'details')
                    <div class="cse-section">
                        {{-- Style/Colourway Selection --}}
                        <h3 class="cse-section-title">Style & Colourway</h3>
                        
                        @if($this->selectedColourway || $colourways_id)
                            @php
                                $cw = $this->selectedColourway;
                                $sv = $cw?->style_versions;
                                $st = $sv?->styles;
                                $ds = $st?->designs;
                            @endphp
                            <div class="csamp-selected-style">
                                <div class="csamp-selected-info">
                                    <span class="csamp-selected-rt">{{ $ds?->id }}</span>
                                    <span class="csamp-selected-desc">{{ $ds?->description }}</span>
                                    <span class="csamp-selected-cw">{{ $cw?->name }}</span>
                                </div>
                                @if($isNewSample)
                                    <button type="button" class="cse-btn cse-btn-sm" wire:click="openStylePicker">
                                        <i class="fas fa-exchange-alt"></i> Change
                                    </button>
                                @endif
                            </div>
                        @else
                            <button type="button" class="cse-btn cse-btn-primary" wire:click="openStylePicker">
                                <i class="fas fa-search"></i> Select Style & Colourway
                            </button>
                            @error('colourways_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        @endif
                    </div>

                    <div class="cse-section">
                        <h3 class="cse-section-title">Sample Details</h3>
                        
                        <div class="cse-grid">
                            <div class="cse-field">
                                <label class="cse-label">Sample Type <span class="text-danger">*</span></label>
                                <select class="form-select @error('sample_types_id') is-invalid @enderror" wire:model="sample_types_id">
                                    <option value="">Select Type</option>
                                    @foreach($this->sampleTypes as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                                @error('sample_types_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Size <span class="text-danger">*</span></label>
                                <select class="form-select @error('sizes_id') is-invalid @enderror" wire:model="sizes_id">
                                    <option value="">Select Size</option>
                                    @foreach($this->sizes as $size)
                                        <option value="{{ $size->id }}">{{ $size->name }}</option>
                                    @endforeach
                                </select>
                                @error('sizes_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Quantity <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('qty') is-invalid @enderror" 
                                       wire:model="qty" min="1">
                                @error('qty') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Status</label>
                                <select class="form-select" wire:model="status">
                                    <option value="pending">Pending</option>
                                    <option value="approved">Approved</option>
                                    <option value="rejected">Rejected</option>
                                </select>
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">PO Number</label>
                                <input type="text" class="form-control" wire:model="po" placeholder="PO reference">
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Weight (kg)</label>
                                <input type="number" step="0.01" class="form-control" wire:model="weight" placeholder="0.00">
                            </div>
                        </div>
                    </div>

                    <div class="cse-section">
                        <h3 class="cse-section-title">Dates & Shipping</h3>
                        
                        <div class="cse-grid">
                            <div class="cse-field">
                                <label class="cse-label">Expected Date</label>
                                <input type="date" class="form-control" wire:model="date_expected">
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Sent Date</label>
                                <input type="date" class="form-control" wire:model="date_sent">
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Received Date</label>
                                <input type="date" class="form-control" wire:model="date_received">
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Tracking Number</label>
                                <input type="text" class="form-control" wire:model="tracking" placeholder="Tracking reference">
                            </div>
                        </div>
                    </div>

                    <div class="cse-section">
                        <h3 class="cse-section-title">Notes & Charging</h3>
                        
                        <div class="cse-field cse-field-full">
                            <label class="cse-label">Comments</label>
                            <textarea class="form-control" wire:model="comments" rows="2" placeholder="Sample comments..."></textarea>
                        </div>

                        <div class="cse-field cse-field-full">
                            <label class="cse-label">Finance Notes</label>
                            <textarea class="form-control" wire:model="fn_notes" rows="2" placeholder="Notes for finance..."></textarea>
                        </div>

                        <div class="cse-grid">
                            <div class="cse-field">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="do_not_charge" wire:model="do_not_charge">
                                    <label class="form-check-label" for="do_not_charge">Don't Charge</label>
                                </div>
                            </div>

                            <div class="cse-field">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="do_not_charge_dev" wire:model="do_not_charge_dev">
                                    <label class="form-check-label" for="do_not_charge_dev">Don't Charge Development</label>
                                </div>
                            </div>
                        </div>
                    </div>

                @elseif($activeTab === 'history')
                    <div class="cse-history-container">
                        @if($this->auditHistory->isEmpty())
                            <div class="cse-history-empty">
                                <i class="fas fa-history"></i>
                                <p>No history available</p>
                                <small class="text-muted">History tracking was enabled in December 2023</small>
                            </div>
                        @else
                            @php
                                $hasCreationRecord = $this->auditHistory->contains(fn($a) => $a->event === 'Created');
                            @endphp
                            @if(!$hasCreationRecord)
                                <div class="cse-history-notice">
                                    <i class="fas fa-info-circle"></i>
                                    <span>This sample was created before history tracking was enabled (Dec 2023)</span>
                                </div>
                            @endif
                            <div class="cse-history-timeline">
                                @foreach($this->auditHistory as $audit)
                                    <div class="cse-history-item" wire:key="audit-{{ $audit->id }}">
                                        <div class="cse-history-icon cse-history-icon-{{ strtolower($audit->event) }}">
                                            @if($audit->event === 'Created')
                                                <i class="fas fa-plus"></i>
                                            @elseif($audit->event === 'Updated')
                                                <i class="fas fa-edit"></i>
                                            @elseif($audit->event === 'Deleted')
                                                <i class="fas fa-trash"></i>
                                            @else
                                                <i class="fas fa-circle"></i>
                                            @endif
                                        </div>
                                        <div class="cse-history-content">
                                            <div class="cse-history-header">
                                                <span class="cse-history-event">
                                                    {{ $audit->model_type }} {{ $audit->event }}
                                                </span>
                                                <span class="cse-history-meta">
                                                    <span class="cse-history-user">
                                                        <i class="fas fa-user"></i> {{ $audit->user_name }}
                                                    </span>
                                                    <span class="cse-history-time">
                                                        {{ $audit->created_at->format('d M Y H:i') }}
                                                    </span>
                                                </span>
                                            </div>
                                            @if(!empty($audit->changes))
                                                <div class="cse-history-changes">
                                                    @foreach($audit->changes as $change)
                                                        <div class="cse-history-change">
                                                            <span class="cse-history-field">{{ $change['field'] }}:</span>
                                                            @if($audit->event !== 'Created')
                                                                <span class="cse-history-old">{{ $change['old'] }}</span>
                                                                <i class="fas fa-arrow-right cse-history-arrow"></i>
                                                            @endif
                                                            <span class="cse-history-new">{{ $change['new'] }}</span>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                @endif
            </div>

            {{-- Footer --}}
            <footer class="cse-footer">
                @if(!$isNewSample)
                    <button class="cse-btn cse-btn-danger" 
                            x-on:click="if(confirm('Are you sure you want to delete this sample?')) $wire.deleteSample()">
                        <i class="fas fa-trash"></i>
                    </button>
                @endif
                <div class="cse-footer-spacer"></div>
                <button class="cse-btn cse-btn-secondary" wire:click="close">
                    Close
                </button>
                <button class="cse-btn cse-btn-primary" wire:click="save" wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="save">
                        @if($isNewSample)
                            <i class="fas fa-plus"></i> Create Sample
                        @else
                            Save Changes
                        @endif
                    </span>
                    <span wire:loading wire:target="save">
                        <i class="fas fa-spinner fa-spin"></i> Saving...
                    </span>
                </button>
            </footer>
        @endif
    </div>

    {{-- Style Picker Modal --}}
    @if($showStylePicker)
        <div class="cse-confirm-modal">
            <div class="cse-confirm-backdrop" wire:click="closeStylePicker"></div>
            <div class="coe-picker">
                <div class="coe-picker-header">
                    <h3>Select Style & Colourway</h3>
                    <button wire:click="closeStylePicker"><i class="fas fa-times"></i></button>
                </div>
                <div class="coe-picker-filters">
                    <select wire:model.live="selectedSeasonId" class="form-select">
                        <option value="">All Seasons</option>
                        @foreach($this->seasons as $s)
                            <option value="{{ $s->id }}">{{ $s->description }}</option>
                        @endforeach
                    </select>
                    <select wire:model.live="selectedCustomerId" class="form-select">
                        <option value="">All Customers</option>
                        @foreach($this->customers as $c)
                            <option value="{{ $c->id }}">{{ $c->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="coe-picker-search">
                    <i class="fas fa-search"></i>
                    <input type="text" wire:model.live.debounce.300ms="styleSearch" 
                           placeholder="Search by RT, description, reference...">
                </div>
                <div class="coe-picker-results">
                    @forelse($this->availableStyles as $style)
                        <div class="coe-picker-style">
                            <div class="coe-picker-style-header">
                                <span class="coe-picker-rt">{{ $style->designs?->id }}</span>
                                <span class="coe-picker-desc">{{ $style->designs?->description }}</span>
                                @if($style->customer_ref)
                                    <span class="coe-picker-ref">{{ $style->customer_ref }}</span>
                                @endif
                            </div>
                            <div class="coe-picker-colourways">
                                @foreach($style->style_versions as $version)
                                    @foreach($version->colourways as $colourway)
                                        <button class="coe-picker-cw" wire:click="selectColourway({{ $colourway->id }})">
                                            {{ $colourway->name }}
                                        </button>
                                    @endforeach
                                @endforeach
                            </div>
                        </div>
                    @empty
                        <div class="coe-picker-empty">
                            <p>Select a season or customer, or search to find styles</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    @endif
</div>

