<div>
    {{-- Backdrop --}}
    @if($isOpen)
        <div class="cse-backdrop" wire:click="close"></div>
    @endif

    {{-- Slide Panel --}}
    <div class="cse-panel {{ $isOpen ? 'open' : '' }}">
        @if($isOpen)
            {{-- Header --}}
            <header class="cse-header">
                <div class="cse-header-info">
                    <span class="cse-badge cse-badge-bulk"><i class="fas fa-layer-group"></i></span>
                    <h2 class="cse-title">Bulk Edit</h2>
                    <span class="cse-count-badge">{{ count($sampleIds) }} samples</span>
                </div>
                <button class="cse-close" wire:click="close">
                    <i class="fas fa-times"></i>
                </button>
            </header>

            {{-- Toast Notifications --}}
            @if(session()->has('message'))
                <div class="cse-toast cse-toast-success" 
                     x-data="{ show: true }" 
                     x-show="show" 
                     x-init="setTimeout(() => show = false, 4000)"
                     x-transition>
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('message') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif
            @if(session()->has('error'))
                <div class="cse-toast cse-toast-error" x-data="{ show: true }" x-show="show" x-transition>
                    <i class="fas fa-exclamation-circle"></i>
                    <span>{{ session('error') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif

            {{-- Content --}}
            <div class="cse-content">
                {{-- Selected Samples Preview --}}
                <div class="cse-section">
                    <h3 class="cse-section-title">Selected Samples</h3>
                    <div class="csamp-bulk-preview">
                        @foreach($this->selectedSamples->take(5) as $sample)
                            <div class="csamp-bulk-preview-item">
                                <span class="csamp-bulk-rt">{{ $sample->colourways?->style_versions?->styles?->designs?->id }}</span>
                                <span class="csamp-bulk-desc">{{ Str::limit($sample->colourways?->style_versions?->styles?->designs?->description, 20) }}</span>
                                <span class="csamp-bulk-cw">{{ $sample->colourways?->name }}</span>
                                <span class="csamp-bulk-type">{{ $sample->sample_types?->name }}</span>
                            </div>
                        @endforeach
                        @if($this->selectedSamples->count() > 5)
                            <div class="csamp-bulk-more">
                                + {{ $this->selectedSamples->count() - 5 }} more samples
                            </div>
                        @endif
                    </div>
                </div>

                {{-- Info Notice --}}
                <div class="csamp-bulk-notice">
                    <i class="fas fa-info-circle"></i>
                    <span>Toggle the fields you want to update. Only toggled fields will be changed.</span>
                </div>

                {{-- Editable Fields --}}
                <div class="cse-section">
                    <h3 class="cse-section-title">Fields to Update</h3>
                    
                    <div class="csamp-bulk-fields">
                        {{-- Sample Type --}}
                        <div class="csamp-bulk-field {{ $update_sample_type ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_sample_type">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Sample Type</span>
                            </div>
                            @if($update_sample_type)
                                <div class="csamp-bulk-field-input">
                                    <select class="form-select" wire:model="sample_types_id">
                                        <option value="">Select Type</option>
                                        @foreach($this->sampleTypes as $type)
                                            <option value="{{ $type->id }}">{{ $type->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                        </div>

                        {{-- Size --}}
                        <div class="csamp-bulk-field {{ $update_size ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_size">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Size</span>
                            </div>
                            @if($update_size)
                                <div class="csamp-bulk-field-input">
                                    <select class="form-select" wire:model="sizes_id">
                                        <option value="">Select Size</option>
                                        @foreach($this->sizes as $size)
                                            <option value="{{ $size->id }}">{{ $size->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                        </div>

                        {{-- Quantity --}}
                        <div class="csamp-bulk-field {{ $update_qty ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_qty">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Quantity</span>
                            </div>
                            @if($update_qty)
                                <div class="csamp-bulk-field-input">
                                    <input type="number" class="form-control" wire:model="qty" min="1">
                                </div>
                            @endif
                        </div>

                        {{-- Status --}}
                        <div class="csamp-bulk-field {{ $update_status ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_status">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Status</span>
                            </div>
                            @if($update_status)
                                <div class="csamp-bulk-field-input">
                                    <select class="form-select" wire:model="status">
                                        <option value="pending">Pending</option>
                                        <option value="approved">Approved</option>
                                        <option value="rejected">Rejected</option>
                                    </select>
                                </div>
                            @endif
                        </div>

                        {{-- Expected Date --}}
                        <div class="csamp-bulk-field {{ $update_date_expected ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_date_expected">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Expected Date</span>
                            </div>
                            @if($update_date_expected)
                                <div class="csamp-bulk-field-input">
                                    <input type="date" class="form-control" wire:model="date_expected">
                                </div>
                            @endif
                        </div>

                        {{-- Sent Date --}}
                        <div class="csamp-bulk-field {{ $update_date_sent ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_date_sent">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Sent Date</span>
                            </div>
                            @if($update_date_sent)
                                <div class="csamp-bulk-field-input">
                                    <input type="date" class="form-control" wire:model="date_sent">
                                </div>
                            @endif
                        </div>

                        {{-- Tracking --}}
                        <div class="csamp-bulk-field {{ $update_tracking ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_tracking">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Tracking</span>
                            </div>
                            @if($update_tracking)
                                <div class="csamp-bulk-field-input">
                                    <input type="text" class="form-control" wire:model="tracking" placeholder="Tracking number">
                                </div>
                            @endif
                        </div>

                        {{-- Weight --}}
                        <div class="csamp-bulk-field {{ $update_weight ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_weight">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Weight (kg)</span>
                            </div>
                            @if($update_weight)
                                <div class="csamp-bulk-field-input">
                                    <input type="number" step="0.01" class="form-control" wire:model="weight" placeholder="0.00">
                                </div>
                            @endif
                        </div>

                        {{-- PO --}}
                        <div class="csamp-bulk-field {{ $update_po ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_po">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">PO Number</span>
                            </div>
                            @if($update_po)
                                <div class="csamp-bulk-field-input">
                                    <input type="text" class="form-control" wire:model="po" placeholder="PO reference">
                                </div>
                            @endif
                        </div>

                        {{-- Comments --}}
                        <div class="csamp-bulk-field {{ $update_comments ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_comments">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Comments</span>
                            </div>
                            @if($update_comments)
                                <div class="csamp-bulk-field-input">
                                    <textarea class="form-control" wire:model="comments" rows="2" placeholder="Sample comments..."></textarea>
                                </div>
                            @endif
                        </div>

                        {{-- Don't Charge --}}
                        <div class="csamp-bulk-field {{ $update_do_not_charge ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_do_not_charge">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Don't Charge</span>
                            </div>
                            @if($update_do_not_charge)
                                <div class="csamp-bulk-field-input">
                                    <select class="form-select" wire:model="do_not_charge">
                                        <option value="0">Charge</option>
                                        <option value="1">Do Not Charge</option>
                                    </select>
                                </div>
                            @endif
                        </div>

                        {{-- Don't Charge Dev --}}
                        <div class="csamp-bulk-field {{ $update_do_not_charge_dev ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_do_not_charge_dev">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Don't Charge Development</span>
                            </div>
                            @if($update_do_not_charge_dev)
                                <div class="csamp-bulk-field-input">
                                    <select class="form-select" wire:model="do_not_charge_dev">
                                        <option value="0">Charge Development</option>
                                        <option value="1">Do Not Charge Development</option>
                                    </select>
                                </div>
                            @endif
                        </div>

                        {{-- Finance Notes --}}
                        <div class="csamp-bulk-field {{ $update_fn_notes ? 'active' : '' }}">
                            <div class="csamp-bulk-field-header">
                                <label class="csamp-bulk-toggle">
                                    <input type="checkbox" wire:model.live="update_fn_notes">
                                    <span class="csamp-bulk-toggle-slider"></span>
                                </label>
                                <span class="csamp-bulk-field-label">Finance Notes</span>
                            </div>
                            @if($update_fn_notes)
                                <div class="csamp-bulk-field-input">
                                    <textarea class="form-control" wire:model="fn_notes" rows="2" placeholder="Notes for finance..."></textarea>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            {{-- Footer --}}
            <footer class="cse-footer">
                <div class="cse-footer-spacer"></div>
                <button class="cse-btn cse-btn-secondary" wire:click="close">
                    Close
                </button>
                <button class="cse-btn cse-btn-primary" wire:click="save" wire:loading.attr="disabled"
                        @if($this->fieldsToUpdate === 0) disabled @endif>
                    <span wire:loading.remove wire:target="save">
                        <i class="fas fa-save"></i> 
                        Update {{ count($sampleIds) }} Samples
                        @if($this->fieldsToUpdate > 0)
                            ({{ $this->fieldsToUpdate }} {{ Str::plural('field', $this->fieldsToUpdate) }})
                        @endif
                    </span>
                    <span wire:loading wire:target="save">
                        <i class="fas fa-spinner fa-spin"></i> Updating...
                    </span>
                </button>
            </footer>
        @endif
    </div>
</div>


