@php
    $statusClass = match($status ?? null) {
        'approved' => 'cso-sample-approved',
        'rejected' => 'cso-sample-rejected',
        default => $sent ? 'cso-sample-sent' : 'cso-sample-none'
    };
    
    $icon = match($status ?? null) {
        'approved' => 'fa-check',
        'rejected' => 'fa-times',
        default => $sent ? 'fa-paper-plane' : 'fa-minus'
    };
    
    $title = match($status ?? null) {
        'approved' => $label . ' Approved',
        'rejected' => $label . ' Rejected',
        default => $sent ? $label . ' Sent' : 'No ' . $label
    };
@endphp

<span class="cso-sample-badge {{ $statusClass }}" title="{{ $title }}">
    <i class="fas {{ $icon }}"></i>
</span>


