<div class="commission-orders"
     x-data="{ 
         toasts: [],
         addToast(type, message) {
             const id = Date.now();
             this.toasts.push({ id, type, message });
             setTimeout(() => this.removeToast(id), 5000);
         },
         removeToast(id) {
             this.toasts = this.toasts.filter(t => t.id !== id);
         }
     }"
     @notify.window="addToast($event.detail.type, $event.detail.message)"
     x-init="
         const container = $refs.scrollContainer;
         if (container) {
             container.addEventListener('scroll', () => {
                 if (container.scrollTop + container.clientHeight >= container.scrollHeight - 200) {
                     if ($wire.hasMore && !$wire.isLoading) {
                         $wire.loadMore();
                     }
                 }
             });
         }
     ">
    {{-- Header --}}
    <x-commission.page-header 
        title="Orders"
        :stats="[
            ['label' => 'Total', 'value' => $this->stats['total'], 'class' => 'total'],
            ['label' => 'Imported', 'value' => $this->stats['skeleton'], 'class' => 'imported'],
            ['label' => 'Pending PD', 'value' => $this->stats['pending_pd'], 'class' => 'pending-pd'],
            ['label' => 'Pending Merch', 'value' => $this->stats['pending_merch'], 'class' => 'pending-merch'],
            ['label' => 'Approved', 'value' => $this->stats['confirmed'], 'class' => 'approved'],
        ]"
        searchPlaceholder="Search by PO, Order ID, Customer..."
        searchModel="search"
        :search="$search"
    >
        <x-slot name="actions">
            <button class="comm-create-btn" wire:click="$dispatch('create-new-order')">
                <i class="fas fa-plus"></i>
                <span>New Order</span>
            </button>
        </x-slot>
    </x-commission.page-header>

    {{-- Filters Bar --}}
    <div class="cfilter-bar" x-data="{ showFilters: true }">
        <div class="cfilter-content">
            {{-- Mobile Toggle --}}
            <button class="cfilter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="cfilter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="cfilter-items" :class="{ 'show': showFilters }">
                {{-- Status Chips --}}
                <div class="css-view-selector">
                @foreach($this->statusOptions as $key => $opt)
                        <button class="css-view-chip {{ in_array($key, $status) ? 'active' : '' }}" 
                                wire:click="toggleStatus('{{ $key }}')">
                        <i class="fas {{ $opt['icon'] }}"></i>
                        {{ $opt['label'] }}
                        </button>
                    @endforeach
                </div>

                <div class="cfilter-divider"></div>

                {{-- Customer Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $customer ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($customer)
                                {{ $this->customers->firstWhere('id', $customer)?->name ?? 'Customer' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" @click.stop>
                        </div>
                        <div class="cfilter-options">
                            <button class="cfilter-option {{ !$customer ? 'selected' : '' }}" 
                                    x-show="!search || 'all customers'.includes(search.toLowerCase())"
                                    wire:click="$set('customer', '')" @click="open = false; search = ''">
                                <i class="fas fa-users"></i>
                                All Customers
                                @if(!$customer)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
                            @foreach($this->customers as $c)
                                <button class="cfilter-option {{ $customer == $c->id ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="$set('customer', '{{ $c->id }}')" @click="open = false; search = ''">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if($customer == $c->id)<i class="fas fa-check cfilter-check"></i>@endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Season Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $season ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-snowflake cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($season)
                                {{ $this->seasons->firstWhere('id', $season)?->description ?? 'Season' }}
                            @else
                                All Seasons
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$season ? 'selected' : '' }}" 
                                wire:click="$set('season', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Seasons
                            @if(!$season)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        @foreach($this->seasons as $s)
                            <button class="cfilter-option {{ $season == $s->id ? 'selected' : '' }}" 
                                    wire:click="$set('season', '{{ $s->id }}')" @click="open = false">
                                <i class="fas fa-snowflake"></i>
                                {{ $s->description }}
                                @if($season == $s->id)<i class="fas fa-check cfilter-check"></i>@endif
                            </button>
                @endforeach
            </div>
        </div>
        
                {{-- Match Status Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $matchStatus ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-link cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($matchStatus === 'all_matched')
                                All Matched
                            @elseif($matchStatus === 'has_unmatched')
                                Has Unmatched
                            @else
                                Match Status
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        <button class="cfilter-option {{ !$matchStatus ? 'selected' : '' }}" 
                                wire:click="$set('matchStatus', '')" @click="open = false">
                            <i class="fas fa-layer-group"></i>
                            All Match Status
                            @if(!$matchStatus)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $matchStatus === 'all_matched' ? 'selected' : '' }}" 
                                wire:click="$set('matchStatus', 'all_matched')" @click="open = false">
                            <i class="fas fa-check-double"></i>
                            All Matched
                            @if($matchStatus === 'all_matched')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                        <button class="cfilter-option {{ $matchStatus === 'has_unmatched' ? 'selected' : '' }}" 
                                wire:click="$set('matchStatus', 'has_unmatched')" @click="open = false">
                            <i class="fas fa-exclamation-triangle"></i>
                            Has Unmatched
                            @if($matchStatus === 'has_unmatched')<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    </div>
                </div>

                {{-- Date Range Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ $dateFrom || $dateTo ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-calendar cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if($dateFrom && $dateTo)
                                {{ \Carbon\Carbon::parse($dateFrom)->format('d M') }} - {{ \Carbon\Carbon::parse($dateTo)->format('d M') }}
                            @elseif($dateFrom)
                                From {{ \Carbon\Carbon::parse($dateFrom)->format('d M') }}
                            @elseif($dateTo)
                                Until {{ \Carbon\Carbon::parse($dateTo)->format('d M') }}
                            @else
                                Date Range
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-date-menu" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="cfilter-date-row">
                            <label>From</label>
                            <input type="date" wire:model.live="dateFrom" class="cfilter-date-input">
                        </div>
                        <div class="cfilter-date-row">
                            <label>To</label>
                            <input type="date" wire:model.live="dateTo" class="cfilter-date-input">
                        </div>
                        @if($dateFrom || $dateTo)
                            <button class="cfilter-date-clear" wire:click="$set('dateFrom', ''); $set('dateTo', '')" @click="open = false">
                                <i class="fas fa-times"></i> Clear dates
                            </button>
                        @endif
                    </div>
                </div>
            </div>

            {{-- Active Filters Summary & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="cfilter-active">
                    <span class="cfilter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="cfilter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                    </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Content --}}
    <div class="csamp-content" x-ref="scrollContainer">
        {{-- Loading overlay --}}
        <div class="csamp-loading" wire:loading.delay wire:target="loadInitialOrders">
            <div class="spinner-border text-light" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>

        @if(empty($loadedOrders))
            {{-- Empty State --}}
            <div class="csamp-empty">
                <div class="csamp-empty-icon">
                    <i class="fas fa-shopping-cart"></i>
                </div>
                <h3>No orders found</h3>
                <p>Try adjusting your search or filters</p>
                @if($this->activeFiltersCount > 0)
                    <button class="btn btn-commission mt-3" wire:click="clearFilters">
                        Clear all filters
                    </button>
                @endif
            </div>
        @else
            {{-- Table --}}
            <div class="csamp-table-container">
                <table class="csamp-table co-orders-table">
                    <thead>
                        <tr>
                            <th class="csamp-th-sortable" wire:click="sort('id')" style="width: 80px;">
                                <span>Order</span>
                                @if($sortBy === 'id')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="csamp-th-sortable" wire:click="sort('customer_po')">
                                <span>Customer PO</span>
                                @if($sortBy === 'customer_po')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th>Customer</th>
                            <th>Season</th>
                            <th class="csamp-th-sortable" wire:click="sort('status')">
                                <span>Status</span>
                                @if($sortBy === 'status')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="text-center">Match</th>
                            <th class="text-center">Lines</th>
                            <th class="text-end">Qty</th>
                            <th class="csamp-th-sortable text-end" wire:click="sort('imported_at')">
                                <span>Imported</span>
                                @if($sortBy === 'imported_at')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="csamp-th-actions">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($loadedOrders as $order)
                            @php
                                $statusOpt = $this->statusOptions[$order['status']] ?? null;
                            @endphp
                            <tr class="csamp-row" 
                                wire:key="order-{{ $order['id'] }}"
                                wire:click="$dispatch('open-order-edit', { orderId: {{ $order['id'] }} })"
                                style="cursor: pointer;">
                                
                                {{-- Order ID --}}
                                <td>
                                    <span class="co-order-id">#{{ $order['id'] }}</span>
                                </td>
                                
                                {{-- Customer PO --}}
                                <td>
                                    <span class="csamp-rt">{{ $order['customer_po'] ?? '—' }}</span>
                                </td>
                                
                                {{-- Customer --}}
                                <td>
                                    <span class="csamp-desc">{{ $order['customer_name'] ?? '—' }}</span>
                                </td>
                                
                                {{-- Season --}}
                                <td>
                                    <span class="csamp-type-badge">{{ $order['season_description'] ?? '—' }}</span>
                                </td>
                                
                                {{-- Status Badge --}}
                                <td>
                                    @if($statusOpt)
                                        <span class="co-status-badge co-status-{{ $order['status'] }}">
                                            <i class="fas {{ $statusOpt['icon'] }}"></i>
                                            {{ $statusOpt['label'] }}
                                        </span>
                                    @endif
                                </td>
                                
                                {{-- Match Status --}}
                                <td class="text-center">
                                    <div class="co-match-indicator {{ $order['match_percent'] === 100 ? 'matched' : ($order['match_percent'] === 0 ? 'unmatched' : 'partial') }}"
                                         title="{{ $order['matched_lines'] }}/{{ $order['total_lines'] }} matched">
                                        <div class="co-match-bar">
                                            <div class="co-match-fill" style="width: {{ $order['match_percent'] }}%"></div>
                                        </div>
                                        <span class="co-match-text">{{ $order['match_percent'] }}%</span>
                                    </div>
                                    @if($order['unmatched_lines'] > 0)
                                        <span class="co-unmatched-count">{{ $order['unmatched_lines'] }} unmatched</span>
                                    @endif
                                </td>
                                
                                {{-- Lines --}}
                                <td class="text-center">
                                    <span class="co-lines-badge">{{ $order['total_lines'] }}</span>
                                </td>
                                
                                {{-- Qty --}}
                                <td class="text-end">
                                    <span class="csamp-tracking">—</span>
                                </td>
                                
                                {{-- Imported Date --}}
                                <td class="text-end">
                                    @if($order['imported_at'])
                                        <div class="csamp-style-info">
                                            <span class="csamp-desc">{{ $order['imported_at'] }}</span>
                                        </div>
                                        <div class="csamp-style-meta">
                                            <span class="csamp-season">{{ $order['imported_at_diff'] }}</span>
                                        </div>
                                    @else
                                        <span class="csamp-date-empty">—</span>
                                    @endif
                                </td>
                                
                                {{-- Actions --}}
                                <td class="csamp-td-actions" wire:click.stop>
                                    <div class="co-action-group">
                                        {{-- View/Edit --}}
                                        <button class="csamp-action-btn" title="View order" 
                                                wire:click="$dispatch('open-order-edit', { orderId: {{ $order['id'] }} })">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        
                                        {{-- Status-specific actions --}}
                                        @if($order['status'] === 'skeleton')
                                            <button class="csamp-action-btn co-action-primary" 
                                                    title="Forward to PD" 
                                                    wire:click="openForwardModal({{ $order['id'] }})">
                                                <i class="fas fa-share"></i>
                                            </button>
                                        @elseif($order['status'] === 'pending_pd')
                                            <button class="csamp-action-btn co-action-primary" 
                                                    title="{{ $order['unmatched_lines'] > 0 ? 'All lines must be matched first' : 'Approve (PD)' }}" 
                                                    wire:click="openApprovalModal({{ $order['id'] }}, 'pd')"
                                                    @if($order['unmatched_lines'] > 0) disabled @endif>
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @elseif($order['status'] === 'pending_merch')
                                            <button class="csamp-action-btn co-action-warning" 
                                                    title="Send back to PD" 
                                                    wire:click="openSendBackModal({{ $order['id'] }})">
                                                <i class="fas fa-undo"></i>
                                            </button>
                                            <button class="csamp-action-btn co-action-success" 
                                                    title="Confirm Order" 
                                                    wire:click="openApprovalModal({{ $order['id'] }}, 'merch')"
                                                    @if($order['unmatched_lines'] > 0) disabled @endif>
                                                <i class="fas fa-check-double"></i>
                                            </button>
                                        @endif
                                        
                                        {{-- Delete (except confirmed) --}}
                                        @if($order['status'] !== 'confirmed')
                                            <button class="csamp-action-btn csamp-action-danger" 
                                                    title="Delete order"
                                                    wire:click="deleteOrder({{ $order['id'] }})"
                                                    wire:confirm="Are you sure you want to delete this order?">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Loading More Indicator --}}
            @if($hasMore)
                <div class="csamp-load-more" wire:loading.remove wire:target="loadMore">
                    <div class="csamp-load-more-trigger" x-intersect="$wire.loadMore()">
                        <i class="fas fa-circle-notch fa-spin"></i>
                        <span>Loading more...</span>
                    </div>
                </div>
            @else
                <div class="csamp-end-of-list">
                    <span>{{ count($loadedOrders) }} orders loaded</span>
                </div>
            @endif

            {{-- Loading indicator when fetching more --}}
            <div class="csamp-load-more" wire:loading wire:target="loadMore">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>Loading more...</span>
            </div>
        @endif
    </div>

    {{-- Order Edit Panel --}}
    @livewire('commission.order-edit')

    {{-- Forward to PD Modal --}}
    @if($showForwardModal)
        <div class="cse-confirm-overlay" wire:click.self="closeForwardModal">
            <div class="cse-confirm-modal">
                <div class="cse-confirm-header">
                    <i class="fas fa-share text-info"></i>
                    <h4>Forward to PD</h4>
                </div>
                <p class="text-muted">Select a PD user to review this order.</p>

                <div class="cso-forward-form">
                    <div class="mb-3">
                        <label class="form-label">Assign to <span class="text-danger">*</span></label>
                        <select class="form-select" wire:model="forwardToUserId" @if($forwardSelfCertified) disabled @endif>
                            <option value="">Select PD user...</option>
                            @foreach($this->pdUsers as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                        @error('forwardToUserId') 
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Notes (optional)</label>
                        <textarea class="form-control" wire:model="forwardNotes" rows="2" 
                                  placeholder="Add any notes for the PD reviewer..."></textarea>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="co-forward-self-certify"
                                   wire:model="forwardSelfCertified">
                            <label class="form-check-label" for="co-forward-self-certify">
                                I certify this order is approved to move to the next stage.
                            </label>
                        </div>
                        @error('forwardSelfCertified')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                        @if($forwardSelfCertified)
                            <div class="text-muted small mt-1">
                                You will be assigned as the PD reviewer.
                            </div>
                        @endif
                    </div>
                </div>

                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeForwardModal">
                        Cancel
                    </button>
                    <button class="cse-btn cse-btn-primary" wire:click="forwardToPd"
                            @if(!$forwardSelfCertified && !$forwardToUserId) disabled @endif>
                        <i class="fas fa-share"></i>
                        Forward
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Approval Modal --}}
    @if($showApprovalModal)
        <div class="cse-confirm-overlay" wire:click.self="closeApprovalModal">
            <div class="cse-confirm-modal">
                <div class="cse-confirm-header">
                    @if($approvalType === 'pd')
                        <i class="fas fa-check text-info"></i>
                        <h4>PD Approval</h4>
                    @else
                        <i class="fas fa-check-double text-success"></i>
                        <h4>Confirm Order</h4>
                    @endif
                </div>
                
                @if($approvalError)
                    <div class="alert alert-danger d-flex align-items-center gap-2 mb-3" style="font-size: 0.875rem;">
                        <i class="fas fa-exclamation-circle"></i>
                        {{ $approvalError }}
                    </div>
                @endif
                
                @if($approvalType === 'pd')
                    <p class="text-muted">Approve this order to send it to Merch for final confirmation.</p>
                @else
                    <p class="text-muted">Confirm this order? It will become visible in the shipment schedule.</p>
                @endif

                <div class="cso-approval-form">
                    <div class="mb-3">
                        <label class="form-label">Notes (optional)</label>
                        <textarea class="form-control" wire:model="approvalNotes" rows="2" 
                                  placeholder="Add any notes..."></textarea>
                    </div>
                </div>

                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeApprovalModal">
                        Cancel
                    </button>
                    <button class="cse-btn cse-btn-{{ $approvalType === 'merch' ? 'success' : 'primary' }}" 
                            wire:click="submitApproval"
                            wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="submitApproval">
                            <i class="fas fa-{{ $approvalType === 'merch' ? 'check-double' : 'check' }}"></i>
                            {{ $approvalType === 'pd' ? 'Approve' : 'Confirm Order' }}
                        </span>
                        <span wire:loading wire:target="submitApproval">
                            <i class="fas fa-spinner fa-spin"></i> Processing...
                        </span>
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Send Back to PD Modal --}}
    @if($showSendBackModal)
        <div class="cse-confirm-overlay" wire:click.self="closeSendBackModal">
            <div class="cse-confirm-modal">
                <div class="cse-confirm-header">
                    <i class="fas fa-undo text-warning"></i>
                    <h4>Send Back to PD</h4>
                </div>
                <p class="text-muted">This order will be sent back to PD for further review.</p>

                <div class="cso-forward-form">
                    <div class="mb-3">
                        <label class="form-label">Send to <span class="text-danger">*</span></label>
                        <select class="form-select" wire:model.live="sendBackToUserId">
                            <option value="">Select PD user...</option>
                            @foreach($this->pdUsers as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                        @error('sendBackToUserId') 
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Reason / Notes</label>
                        <textarea class="form-control" wire:model="sendBackNotes" rows="3" 
                                  placeholder="Explain why this is being sent back..."></textarea>
                    </div>
                </div>

                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeSendBackModal">
                        Cancel
                    </button>
                    <button class="cse-btn cse-btn-warning" wire:click="sendBackToPd" @if(!$sendBackToUserId) disabled @endif>
                        <i class="fas fa-undo"></i>
                        Send Back
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Batch Filter Toast --}}
    @if($this->batch)
        <div class="comm-selection-toast" 
             x-data
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform translate-y-4"
             x-transition:enter-end="opacity-100 transform translate-y-0">
            <div class="comm-selection-toast-content">
                <div class="comm-selection-toast-icon">
                    <i class="fas fa-file-import"></i>
                </div>
                <div class="comm-selection-toast-text">
                    <span class="comm-selection-toast-title">Viewing Import Batch #{{ $this->batch }}</span>
                    <span class="comm-selection-toast-desc">Showing only orders from this import</span>
                </div>
                <button class="comm-selection-toast-btn" wire:click="$set('batch', null)">
                    <i class="fas fa-list"></i>
                    Show All
                </button>
            </div>
        </div>
    @endif

    {{-- Single Order Filter Toast --}}
    @if($this->order)
        <div class="comm-selection-toast" 
             x-data
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform translate-y-4"
             x-transition:enter-end="opacity-100 transform translate-y-0">
            <div class="comm-selection-toast-content">
                <div class="comm-selection-toast-icon">
                    <i class="fas fa-filter"></i>
                </div>
                <div class="comm-selection-toast-text">
                    <span class="comm-selection-toast-title">Viewing Order #{{ $this->order }}</span>
                    <span class="comm-selection-toast-desc">Filtered view</span>
                </div>
                <button class="comm-selection-toast-btn" wire:click="$set('order', null)">
                    <i class="fas fa-list"></i>
                    Show All
                </button>
            </div>
        </div>
    @endif

    {{-- Toast Notifications --}}
    <div class="csamp-toasts">
        <template x-for="toast in toasts" :key="toast.id">
            <div class="csamp-toast" 
                 :class="{ 
                     'csamp-toast-success': toast.type === 'success', 
                     'csamp-toast-error': toast.type === 'error' 
                 }"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0">
                <i class="fas" :class="{ 'fa-check-circle': toast.type === 'success', 'fa-exclamation-circle': toast.type === 'error' }"></i>
                <span x-text="toast.message"></span>
                <button class="csamp-toast-close" @click="removeToast(toast.id)">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </template>
    </div>
</div>
