<div x-data="{ showConfirm: false }" 
     x-on:confirm-close.window="showConfirm = true"
     x-on:keydown.escape.window="if ($wire.isOpen && !showConfirm && !$wire.showStylePicker) $wire.close()">
    
    {{-- Backdrop --}}
    @if($isOpen)
        <div class="cse-backdrop" wire:click="close"></div>
    @endif

    {{-- Unsaved Changes Confirmation --}}
    <div class="cse-confirm-overlay" x-show="showConfirm" x-cloak>
        <div class="cse-confirm-modal">
            <div class="cse-confirm-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h3>Unsaved Changes</h3>
            <p>You have unsaved changes. Are you sure you want to close?</p>
            <div class="cse-confirm-actions">
                <button class="cse-btn cse-btn-secondary" @click="showConfirm = false">
                    Keep Editing
                </button>
                <button class="cse-btn cse-btn-danger" @click="showConfirm = false; $wire.forceClose()">
                    Discard Changes
                </button>
            </div>
        </div>
    </div>

    {{-- Slide Panel with optional PDF viewer --}}
    <div class="cse-panel-wrapper {{ $isOpen ? 'open' : '' }} {{ $showPdfViewer ? 'with-pdf' : '' }}">
        {{-- PDF Viewer (left side) --}}
        @if($showPdfViewer && !empty($source_files))
            <div class="cse-pdf-viewer">
                <div class="cse-pdf-header">
                    <span><i class="fas fa-file-pdf"></i> Source Document</span>
                    <button class="cse-pdf-close" wire:click="togglePdfViewer" title="Hide PDF">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <iframe src="{{ $this->pdfUrl }}" class="cse-pdf-iframe"></iframe>
            </div>
        @endif

        {{-- Order Edit Panel --}}
        <div class="cse-panel {{ $isOpen ? 'open' : '' }} {{ $showPdfViewer ? 'with-pdf' : '' }}">
        @if($isOpen)
            {{-- Header --}}
            <header class="cse-header">
                <div class="cse-header-info">
                    @if($isNewOrder)
                        <span class="cse-badge cse-badge-new"><i class="fas fa-plus"></i></span>
                        <h2 class="cse-title">New Order</h2>
                    @else
                        <span class="cse-badge">{{ $customer_po ?: 'No PO' }}</span>
                        <h2 class="cse-title">Edit Order</h2>
                    @endif
                    @if($isDirty)
                        <span class="cse-dirty-badge">Unsaved</span>
                    @endif
                    {{-- PDF Toggle Button --}}
                    @if(!empty($source_files))
                        <button class="cse-pdf-toggle {{ $showPdfViewer ? 'active' : '' }}" 
                                wire:click="togglePdfViewer"
                                title="{{ $showPdfViewer ? 'Hide PDF' : 'Show PDF' }}">
                            <i class="fas fa-file-pdf"></i>
                        </button>
                    @endif
                </div>
                <button class="cse-close" wire:click="close">
                    <i class="fas fa-times"></i>
                </button>
            </header>

            {{-- Toast Notifications --}}
            @if(session()->has('co-message'))
                <div class="cse-toast cse-toast-success" 
                     x-data="{ show: true }" 
                     x-show="show" 
                     x-init="setTimeout(() => show = false, 3000)"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0">
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('co-message') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif
            @if(session()->has('co-error'))
                <div class="cse-toast cse-toast-error"
                     x-data="{ show: true }" 
                     x-show="show"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0">
                    <i class="fas fa-exclamation-circle"></i>
                    <span>{{ session('co-error') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif

            {{-- Tabs --}}
            <nav class="cse-tabs">
                <button 
                    class="cse-tab {{ $activeTab === 'details' ? 'active' : '' }}"
                    wire:click="$set('activeTab', 'details')"
                >
                    <i class="fas fa-info-circle"></i>
                    Details
                </button>
                <button 
                    class="cse-tab {{ $activeTab === 'lines' ? 'active' : '' }}"
                    wire:click="$set('activeTab', 'lines')"
                >
                    <i class="fas fa-list"></i>
                    Lines
                    @if(count($lines) > 0)
                        <span class="cse-tab-badge">{{ count($lines) }}</span>
                    @endif
                </button>
                @if(!$isNewOrder)
                    <button 
                        class="cse-tab {{ $activeTab === 'history' ? 'active' : '' }}"
                        wire:click="$set('activeTab', 'history')"
                    >
                        <i class="fas fa-history"></i>
                        History
                    </button>
                @endif
            </nav>

            {{-- Content --}}
            <div class="cse-content">
                
                {{-- Details Tab --}}
                @if($activeTab === 'details')
                    <div class="cse-section">
                        {{-- Summary Cards --}}
                        <div class="coe-summary">
                            <div class="coe-summary-card">
                                <span class="coe-summary-label">Total Qty</span>
                                <span class="coe-summary-value">{{ number_format($this->totalQty) }}</span>
                            </div>
                            <div class="coe-summary-card coe-summary-value-card">
                                <span class="coe-summary-label">Total Value</span>
                                <span class="coe-summary-value">£{{ number_format($this->totalValue, 2) }}</span>
                            </div>
                        </div>

                        {{-- Form Grid --}}
                        <div class="cse-grid">
                            <div class="cse-field">
                                <label class="cse-label">Season <span class="text-danger">*</span></label>
                                <select class="form-select @error('season_id') is-invalid @enderror {{ $this->hasLines ? 'bg-light' : '' }}" 
                                        wire:model.live="season_id"
                                        {{ $this->hasLines ? 'disabled' : '' }}>
                                    <option value="">Select Season</option>
                                    @foreach($this->seasons as $season)
                                        <option value="{{ $season->id }}">{{ $season->description }}</option>
                                    @endforeach
                                </select>
                                @if($this->hasLines)
                                    <small class="text-muted"><i class="fas fa-lock"></i> Locked - has lines</small>
                                @endif
                                @error('season_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Customer <span class="text-danger">*</span></label>
                                <select class="form-select @error('customer_id') is-invalid @enderror {{ $this->hasLines ? 'bg-light' : '' }}" 
                                        wire:model.live="customer_id"
                                        {{ $this->hasLines ? 'disabled' : '' }}>
                                    <option value="">Select Customer</option>
                                    @foreach($this->customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                                @if($this->hasLines)
                                    <small class="text-muted"><i class="fas fa-lock"></i> Locked - has lines</small>
                                @endif
                                @error('customer_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">PO Number <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('customer_po') is-invalid @enderror" 
                                       wire:model.blur="customer_po" placeholder="Customer PO">
                                @error('customer_po') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Order Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('order_date') is-invalid @enderror" 
                                       wire:model.blur="order_date">
                                @error('order_date') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>
                            
                            @if(!$isNewOrder && $status)
                                <div class="cse-field">
                                    <label class="cse-label">Status</label>
                                    <div class="coe-status-display">
                                        <span class="co-status-badge co-status-{{ $status }}">
                                            {{ ucwords(str_replace('_', ' ', $status)) }}
                                        </span>
                                    </div>
                                </div>
                            @endif
                            
                            {{-- Source Files (left column) --}}
                            <div class="cse-field">
                                @if(count($source_files) > 0)
                                    <label class="cse-label">Source Files</label>
                                    <div class="coe-source-files-list">
                                        @foreach($source_files as $index => $filePath)
                                            <a href="{{ route('commission.orders.download', ['order' => $orderId, 'fileIndex' => $index]) }}" 
                                               class="coe-source-file-link" 
                                               target="_blank"
                                               title="Download {{ basename($filePath) }}">
                                                <i class="fas fa-file-pdf"></i>
                                                <span>{{ basename($filePath) }}</span>
                                            </a>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                            
                            {{-- Order History (right column) --}}
                            <div class="cse-field">
                                @if($imported_by_name || $forwarded_to_name || $pd_reviewed_by_name || $confirmed_by_name || $this->workflowHistory->count() > 0)
                                    <label class="cse-label">Order History</label>
                                    <div class="coe-approval-history">
                                        @php
                                            // Check which actions we have in workflow history
                                            $hasForwardInHistory = $this->workflowHistory->where('action', 'forward_to_pd')->count() > 0;
                                            $hasPdApprovedInHistory = $this->workflowHistory->where('action', 'pd_approved')->count() > 0;
                                            $hasMerchApprovedInHistory = $this->workflowHistory->where('action', 'merch_approved')->count() > 0;
                                        @endphp
                                        
                                        {{-- Initial import (from order record) --}}
                                        @if($imported_by_name)
                                            <div class="coe-approval-item coe-approval-import">
                                                <div class="coe-approval-header">
                                                    <i class="fas fa-file-import"></i>
                                                    <strong>Imported</strong>
                                                    <span class="coe-approval-by">by {{ $imported_by_name }}</span>
                                                    <span class="coe-approval-date">{{ $imported_at }}</span>
                                                </div>
                                            </div>
                                        @endif
                                        
                                        {{-- Legacy: Forward to PD (if not in workflow history) --}}
                                        @if($forwarded_to_name && !$hasForwardInHistory)
                                            <div class="coe-approval-item coe-approval-forward">
                                                <div class="coe-approval-header">
                                                    <i class="fas fa-paper-plane"></i>
                                                    <strong>Forwarded to PD</strong>
                                                    <span class="coe-approval-by">to {{ $forwarded_to_name }}</span>
                                                    <span class="coe-approval-date">{{ $forwarded_at }}</span>
                                                </div>
                                                @if($forward_notes)
                                                    <div class="coe-approval-notes">
                                                        <i class="fas fa-comment"></i> {{ $forward_notes }}
                                                    </div>
                                                @endif
                                            </div>
                                        @endif
                                        
                                        {{-- Legacy: PD Approved (if not in workflow history but order was approved) --}}
                                        @if($pd_reviewed_by_name && !$hasPdApprovedInHistory)
                                            <div class="coe-approval-item coe-approval-pd">
                                                <div class="coe-approval-header">
                                                    <i class="fas fa-user-check"></i>
                                                    <strong>PD Approved</strong>
                                                    <span class="coe-approval-by">by {{ $pd_reviewed_by_name }}</span>
                                                    <span class="coe-approval-date">{{ $pd_reviewed_at }}</span>
                                                </div>
                                                @if($pd_notes)
                                                    <div class="coe-approval-notes">
                                                        <i class="fas fa-comment"></i> {{ $pd_notes }}
                                                    </div>
                                                @endif
                                            </div>
                                        @endif
                                        
                                        {{-- Workflow history from database --}}
                                        @foreach($this->workflowHistory as $event)
                                            @php
                                                $actionClass = match($event->action) {
                                                    'forward_to_pd' => 'coe-approval-forward',
                                                    'pd_approved' => 'coe-approval-pd',
                                                    'merch_approved' => 'coe-approval-confirmed',
                                                    'sent_back_to_pd' => 'coe-approval-sendback',
                                                    default => 'coe-approval-default',
                                                };
                                                $actionIcon = match($event->action) {
                                                    'forward_to_pd' => 'fa-paper-plane',
                                                    'pd_approved' => 'fa-user-check',
                                                    'merch_approved' => 'fa-check-double',
                                                    'sent_back_to_pd' => 'fa-undo',
                                                    default => 'fa-circle',
                                                };
                                            @endphp
                                            <div class="coe-approval-item {{ $actionClass }}">
                                                <div class="coe-approval-header">
                                                    <i class="fas {{ $actionIcon }}"></i>
                                                    <strong>{{ $event->action_label }}</strong>
                                                    @if($event->action === 'forward_to_pd' || $event->action === 'sent_back_to_pd')
                                                        <span class="coe-approval-by">to {{ $event->toUser?->name ?? 'Unknown' }}</span>
                                                    @else
                                                        <span class="coe-approval-by">by {{ $event->fromUser?->name ?? 'Unknown' }}</span>
                                                    @endif
                                                    <span class="coe-approval-date">{{ $event->created_at->format('d M Y H:i') }}</span>
                                                </div>
                                                @if($event->notes)
                                                    <div class="coe-approval-notes">
                                                        <i class="fas fa-comment"></i> {{ $event->notes }}
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                        
                                        {{-- Legacy: Merch Confirmed (if not in workflow history but order was confirmed) --}}
                                        @if($confirmed_by_name && !$hasMerchApprovedInHistory)
                                            <div class="coe-approval-item coe-approval-confirmed">
                                                <div class="coe-approval-header">
                                                    <i class="fas fa-check-double"></i>
                                                    <strong>Merch Confirmed</strong>
                                                    <span class="coe-approval-by">by {{ $confirmed_by_name }}</span>
                                                    <span class="coe-approval-date">{{ $confirmed_at }}</span>
                                                </div>
                                                @if($merch_notes)
                                                    <div class="coe-approval-notes">
                                                        <i class="fas fa-comment"></i> {{ $merch_notes }}
                                                    </div>
                                                @endif
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                {{-- Lines Tab --}}
                @elseif($activeTab === 'lines')
                    <div class="cse-section coe-lines-section">
                        {{-- PD notice --}}
                        @if($this->isPdReviewer)
                            <div class="coe-pd-notice">
                                <i class="fas fa-info-circle"></i>
                                <span>As PD reviewer, you can change styles and colourways but not quantities.</span>
                            </div>
                        @endif

                        {{-- Header --}}
                        <div class="coe-lines-header">
                            <button class="cse-btn cse-btn-primary" wire:click="openStylePicker" {{ !$customer_id || !$season_id ? 'disabled' : '' }}>
                                <i class="fas fa-plus"></i> Add Style
                            </button>
                            @if(count($lines) > 0 && $this->canEditQuantities)
                                <button class="cse-btn cse-btn-outline" wire:click="addQuickSizeInput" title="Add a new size column">
                                    <i class="fas fa-plus-circle"></i> Size
                                </button>
                            @endif
                            @if(!$customer_id || !$season_id)
                                <span class="text-muted small ms-2">Select season and customer first</span>
                            @endif
                            @if(count($lines) > 0)
                                <div class="coe-bulk-actions">
                                    <div class="coe-bulk-item">
                                        <label class="coe-bulk-label"><i class="fas fa-percent"></i> Comm%:</label>
                                        <input type="number" step="0.01" min="0" max="100" class="form-control form-control-sm coe-bulk-input" wire:model.blur="default_commission_percent" placeholder="0">
                                        <button type="button" class="cse-btn cse-btn-secondary cse-btn-sm" wire:click="applyCommissionToAllLines" title="Apply to all"><i class="fas fa-check"></i></button>
                                    </div>
                                    <div class="coe-bulk-item">
                                        <label class="coe-bulk-label"><i class="fas fa-tag"></i> Disc%:</label>
                                        <input type="number" step="0.01" min="0" max="100" class="form-control form-control-sm coe-bulk-input" wire:model.blur="default_discount_percent" placeholder="0">
                                        <button type="button" class="cse-btn cse-btn-secondary cse-btn-sm" wire:click="applyDiscountToAllLines" title="Apply to all"><i class="fas fa-check"></i></button>
                                    </div>
                                    <div class="coe-bulk-item">
                                        <label class="coe-bulk-label"><i class="fas fa-calendar-alt"></i> Ex-Fty:</label>
                                        <input type="date" class="form-control form-control-sm coe-bulk-input" wire:change="setAllLinesExfty($event.target.value)">
                                        <button type="button" class="cse-btn cse-btn-secondary cse-btn-sm" wire:click="clearAllLinesExfty" title="Clear all"><i class="fas fa-times"></i></button>
                                    </div>
                                </div>
                            @endif
                        </div>

                        @if(count($lines) === 0)
                            <div class="cse-cw-empty">
                                <i class="fas fa-box-open"></i>
                                <p>No lines added yet</p>
                                <span>Click "Add Style" to add order lines</span>
                            </div>
                        @else
                            @php
                                // Collect all unique sizes across all lines
                                $allSizes = collect($lines)->flatMap(fn($l) => collect($l['sizes'] ?? []))->pluck('size_name', 'size_id')->unique()->filter()->sortBy(fn($name) => match(strtoupper($name)) {
                                    'XXS' => 1, 'XS' => 2, 'S' => 3, 'M' => 4, 'L' => 5, 'XL' => 6, 'XXL' => 7, '2XL' => 7, '3XL' => 8,
                                    default => ord(strtoupper($name[0] ?? 'Z'))
                                });
                            @endphp
                            
                            <div class="coe-simple-table-wrap">
                                <table class="coe-simple-table">
                                    <thead>
                                        <tr>
                                            <th class="coe-st-rt">RT</th>
                                            <th class="coe-st-ref">Ref</th>
                                            <th class="coe-st-desc">Description</th>
                                            <th class="coe-st-colour">Colour</th>
                                            @foreach($allSizes as $sizeId => $sizeName)
                                                <th class="coe-st-size">{{ $sizeName }}</th>
                                            @endforeach
                                            @if(count($lines) > 0 && $this->canEditQuantities)
                                                @foreach($quickAddSizeInputs as $inputIndex => $inputData)
                                                    <th class="coe-st-size-add">
                                                        <input type="text" 
                                                               class="coe-size-add-input" 
                                                               wire:model.live="quickAddSizeInputs.{{ $inputIndex }}.name"
                                                               wire:keydown.enter.prevent="addQuickSize({{ $inputIndex }})"
                                                               wire:keydown.escape.prevent="removeQuickSizeInput({{ $inputIndex }})"
                                                               placeholder="e.g. XXL"
                                                               maxlength="20">
                                                    </th>
                                                @endforeach
                                            @endif
                                            <th class="coe-st-total">Total</th>
                                            <th class="coe-st-comm" title="Commission %">Comm%</th>
                                            <th class="coe-st-disc" title="Discount %">Disc%</th>
                                            <th class="coe-st-exfty">Ex-Factory</th>
                                            <th class="coe-st-del"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($lines as $lineIndex => $line)
                                            <tr wire:key="line-{{ $lineIndex }}">
                                                {{-- RT Number (clickable to change) --}}
                                                <td class="coe-st-rt">
                                                    @if($this->isSkeletonOrder)
                                                        <button class="coe-rt-btn {{ !$line['colourway_id'] ? 'coe-rt-unmatched' : '' }}" 
                                                                wire:click="openColourwayPicker({{ $lineIndex }})"
                                                                title="Click to change">
                                                            @if($line['colourway_id'])
                                                                {{ $line['rt_number'] }}
                                                            @else
                                                                <i class="fas fa-exclamation-triangle"></i>
                                                            @endif
                                                        </button>
                                                    @else
                                                        <span class="coe-rt-display">{{ $line['rt_number'] ?? '—' }}</span>
                                                    @endif
                                                </td>
                                                
                                                {{-- Customer Ref --}}
                                                <td class="coe-st-ref">
                                                    @if($line['colourway_id'])
                                                        {{ $line['customer_ref'] ?? '—' }}
                                                    @else
                                                        <span class="coe-unmatched-text" title="AI extracted: {{ $line['imported_style_ref'] ?? 'Unknown' }}">
                                                            {{ $line['imported_style_ref'] ?? '—' }}
                                                        </span>
                                                    @endif
                                                </td>
                                                
                                                {{-- Description --}}
                                                <td class="coe-st-desc" title="{{ $line['description'] ?? $line['imported_description'] ?? '' }}">
                                                    @if($line['colourway_id'])
                                                        {{ Str::limit($line['description'] ?? '', 25) }}
                                                    @else
                                                        <span class="coe-unmatched-text">
                                                            {{ Str::limit($line['imported_description'] ?? '', 25) }}
                                                        </span>
                                                    @endif
                                                </td>
                                                
                                                {{-- Colour --}}
                                                <td class="coe-st-colour">
                                                    @if($line['colourway_id'])
                                                        {{ $line['colourway_name'] ?? '—' }}
                                                    @else
                                                        <span class="coe-unmatched-text" title="AI extracted: {{ $line['imported_colour'] ?? 'Unknown' }}">
                                                            {{ $line['imported_colour'] ?? '—' }}
                                                        </span>
                                                    @endif
                                                </td>
                                                
                                                {{-- Size quantities --}}
                                                @foreach($allSizes as $sizeId => $sizeName)
                                                    @php
                                                        $sizeData = collect($line['sizes'] ?? [])->firstWhere('size_id', $sizeId);
                                                        $qty = $sizeData['qty'] ?? 0;
                                                        $price = $sizeData['price'] ?? 0;
                                                        $sizeIndex = collect($line['sizes'] ?? [])->search(fn($s) => $s['size_id'] == $sizeId);
                                                    @endphp
                                                    <td class="coe-st-size">
                                                        <div class="coe-size-cell">
                                                            @if($sizeIndex !== false)
                                                                <input type="number" 
                                                                       class="coe-size-input" 
                                                                       wire:model.live.debounce.300ms="lines.{{ $lineIndex }}.sizes.{{ $sizeIndex }}.qty"
                                                                       min="0"
                                                                       {{ !$this->canEditQuantities ? 'disabled' : '' }}>
                                                                <input type="number" 
                                                                       class="coe-price-input" 
                                                                       wire:model.live.debounce.300ms="lines.{{ $lineIndex }}.sizes.{{ $sizeIndex }}.price"
                                                                       step="0.01"
                                                                       min="0"
                                                                       placeholder="0.00"
                                                                       title="Price">
                                                            @else
                                                                <input type="number" 
                                                                       class="coe-size-input" 
                                                                       value="0"
                                                                       min="0"
                                                                       x-data="{ val: 0 }"
                                                                       x-model.number="val"
                                                                       @input.debounce.300ms="$wire.updateLineQty({{ $lineIndex }}, {{ $sizeId }}, val)"
                                                                       {{ !$this->canEditQuantities ? 'disabled' : '' }}>
                                                                <input type="number" 
                                                                       class="coe-price-input" 
                                                                       value="0.00"
                                                                       step="0.01"
                                                                       min="0"
                                                                       placeholder="0.00"
                                                                       x-data="{ val: 0 }"
                                                                       x-model.number="val"
                                                                       @input.debounce.300ms="$wire.updateLinePrice({{ $lineIndex }}, {{ $sizeId }}, val)"
                                                                       title="Price">
                                                            @endif
                                                        </div>
                                                    </td>
                                                @endforeach
                                                
                                                {{-- Quick add size columns with editable qty/price --}}
                                                @if(count($lines) > 0 && $this->canEditQuantities)
                                                    @foreach($quickAddSizeInputs as $inputIndex => $inputData)
                                                        <td class="coe-st-size-add">
                                                            <div class="coe-size-cell">
                                                                <input type="number" 
                                                                       class="coe-size-input" 
                                                                       wire:model.live.debounce.300ms="quickAddSizeInputs.{{ $inputIndex }}.values.{{ $lineIndex }}.qty"
                                                                       min="0"
                                                                       placeholder="0">
                                                                <input type="number" 
                                                                       class="coe-price-input" 
                                                                       wire:model.live.debounce.300ms="quickAddSizeInputs.{{ $inputIndex }}.values.{{ $lineIndex }}.price"
                                                                       step="0.01"
                                                                       min="0"
                                                                       placeholder="0.00">
                                                            </div>
                                                        </td>
                                                    @endforeach
                                                @endif
                                                
                                                {{-- Total --}}
                                                <td class="coe-st-total">
                                                    {{ (int) collect($line['sizes'] ?? [])->sum('qty') }}
                                                </td>
                                                
                                                {{-- Commission % --}}
                                                <td class="coe-st-comm">
                                                    <input type="number" 
                                                           class="coe-comm-input" 
                                                           wire:model.live.debounce.300ms="lines.{{ $lineIndex }}.commission_percent"
                                                           step="0.01"
                                                           min="0"
                                                           max="100"
                                                           placeholder="0"
                                                           title="Commission %">
                                                </td>
                                                
                                                {{-- Discount % --}}
                                                <td class="coe-st-disc">
                                                    <input type="number" 
                                                           class="coe-disc-input" 
                                                           wire:model.live.debounce.300ms="lines.{{ $lineIndex }}.discount_percent"
                                                           step="0.01"
                                                           min="0"
                                                           max="100"
                                                           placeholder="0"
                                                           title="Discount %">
                                                </td>
                                                
                                                {{-- Ex-Factory Date --}}
                                                <td class="coe-st-exfty">
                                                    @php
                                                        $firstDrop = collect($line['drops'] ?? [])->first();
                                                        $exftyDate = $firstDrop['due_date'] ?? '';
                                                    @endphp
                                                    <input type="date" 
                                                           class="form-control form-control-sm coe-exfty-input"
                                                           value="{{ $exftyDate }}"
                                                           wire:change="setLineExfty({{ $lineIndex }}, $event.target.value)">
                                                </td>
                                                
                                                {{-- Delete --}}
                                                <td class="coe-st-del">
                                                    <button class="coe-del-btn" wire:click="removeLine({{ $lineIndex }})" title="Remove">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @endif
                    </div>

                {{-- History Tab --}}
                @elseif($activeTab === 'history')
                    @if(!$isNewOrder)
                        <div class="cse-history-container">
                            @if($this->auditHistory->isEmpty())
                                <div class="cse-history-empty">
                                    <i class="fas fa-history"></i>
                                    <p>No history available</p>
                                    <small class="text-muted">History tracking was enabled in December 2023</small>
                                </div>
                            @else
                                @php
                                    $hasCreationRecord = $this->auditHistory->contains(fn($a) => $a->event === 'Created' && $a->model_type === 'Order');
                                @endphp
                                @if(!$hasCreationRecord)
                                    <div class="cse-history-notice">
                                        <i class="fas fa-info-circle"></i>
                                        <span>This order was created before history tracking was enabled (Dec 2023)</span>
                                    </div>
                                @endif
                                <div class="cse-history-timeline">
                                    @foreach($this->auditHistory as $audit)
                                        <div class="cse-history-item" wire:key="audit-{{ $audit->id }}">
                                            <div class="cse-history-icon cse-history-icon-{{ strtolower($audit->event) }}">
                                                @if($audit->event === 'Created')
                                                    <i class="fas fa-plus"></i>
                                                @elseif($audit->event === 'Updated')
                                                    <i class="fas fa-edit"></i>
                                                @elseif($audit->event === 'Deleted')
                                                    <i class="fas fa-trash"></i>
                                                @else
                                                    <i class="fas fa-circle"></i>
                                                @endif
                                            </div>
                                            <div class="cse-history-content">
                                                <div class="cse-history-header">
                                                    <span class="cse-history-event">
                                                        @if(($audit->type ?? 'single') === 'quantity_batch')
                                                            <span class="cse-history-qty-badge">{{ $audit->count }}</span> Quantities {{ $audit->event }}
                                                        @else
                                                            {{ $audit->model_type }}@if($audit->item_name) <span class="cse-history-item-name" title="{{ $audit->item_name }}">"{{ Str::limit($audit->item_name, 10) }}"</span>@endif {{ $audit->event }}
                                                        @endif
                                                    </span>
                                                    <span class="cse-history-meta">
                                                        <span class="cse-history-user">
                                                            <i class="fas fa-user"></i> {{ $audit->user_name }}
                                                        </span>
                                                        <span class="cse-history-time" title="{{ $audit->created_at->format('d M Y H:i:s') }}">
                                                            {{ $audit->created_at->diffForHumans() }}
                                                        </span>
                                                    </span>
                                                </div>
                                                
                                                @if(($audit->type ?? 'single') === 'quantity_batch')
                                                    <div class="cse-history-qty-table">
                                                        <table>
                                                            <thead>
                                                                <tr>
                                                                    <th>Colourway</th>
                                                                    <th>Size</th>
                                                                    <th>Qty</th>
                                                                    @if($audit->event === 'Updated')<th></th>@endif
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($audit->quantities as $qty)
                                                                    <tr>
                                                                        <td>{{ Str::limit($qty['line_name'], 12) }}</td>
                                                                        <td>{{ $qty['size'] }}</td>
                                                                        @if($audit->event === 'Updated')
                                                                            <td class="cse-history-old">{{ $qty['old_qty'] ?? '—' }}</td>
                                                                            <td class="cse-history-new">{{ $qty['new_qty'] ?? '—' }}</td>
                                                                        @else
                                                                            <td class="cse-history-new">{{ $qty['new_qty'] ?? $qty['old_qty'] ?? '—' }}</td>
                                                                        @endif
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                @elseif(!empty($audit->changes))
                                                    <div class="cse-history-changes">
                                                        @foreach($audit->changes as $change)
                                                            <div class="cse-history-change">
                                                                <span class="cse-history-field">{{ $change['field'] }}:</span>
                                                                @if($audit->event !== 'Created')
                                                                    <span class="cse-history-old">{{ $change['old'] }}</span>
                                                                    <i class="fas fa-arrow-right cse-history-arrow"></i>
                                                                @endif
                                                                <span class="cse-history-new">{{ $change['new'] }}</span>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    @endif
                @endif
            </div>

            {{-- Footer --}}
            <footer class="cse-footer">
                <button class="cse-btn cse-btn-secondary" wire:click="close">
                    Close
                </button>
                
                <div class="coe-footer-actions">
                    <button class="cse-btn cse-btn-primary" 
                            wire:click="save"
                            wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="save">
                            @if($isNewOrder)
                                <i class="fas fa-plus"></i> Create Order
                            @else
                                <i class="fas fa-save"></i> Save
                            @endif
                        </span>
                        <span wire:loading wire:target="save">
                            <i class="fas fa-spinner fa-spin"></i> Saving...
                        </span>
                    </button>
                    
                    {{-- Workflow buttons based on status --}}
                    @if(!$isNewOrder)
                        @if($orderStatus === 'skeleton')
                            <button class="cse-btn cse-btn-success" 
                                    wire:click="saveAndForwardToPd"
                                    wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="saveAndForwardToPd">
                                    <i class="fas fa-paper-plane"></i> Save & Send to PD
                                </span>
                                <span wire:loading wire:target="saveAndForwardToPd">
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>
                            </button>
                        @elseif($orderStatus === 'pending_pd')
                            <button class="cse-btn cse-btn-success" 
                                    wire:click="openApprovalModal('pd')">
                                <i class="fas fa-check"></i> PD Approve
                            </button>
                        @elseif($orderStatus === 'pending_merch')
                            <button class="cse-btn cse-btn-warning" 
                                    wire:click="openSendBackModal">
                                <i class="fas fa-undo"></i> Back to PD
                            </button>
                            <button class="cse-btn cse-btn-success" 
                                    wire:click="openApprovalModal('merch')">
                                <i class="fas fa-check-double"></i> Confirm Order
                            </button>
                        @endif
                    @endif
                </div>
            </footer>
        @endif
    </div>
    </div> {{-- End of cse-panel-wrapper --}}

    {{-- Style Picker Modal --}}
    @if($showStylePicker)
        <div class="cse-confirm-overlay" wire:click.self="closeStylePicker">
            <div class="coe-picker">
                <div class="coe-picker-header">
                    <h3>Add Style to Order</h3>
                    <button wire:click="closeStylePicker"><i class="fas fa-times"></i></button>
                </div>
                <div class="coe-picker-search">
                    <i class="fas fa-search"></i>
                    <input type="text" wire:model.live.debounce.300ms="styleSearch" 
                           placeholder="Search by RT, description, reference..." autofocus>
                </div>
                <div class="coe-picker-results">
                    @forelse($this->availableStyles as $style)
                        <div class="coe-picker-style">
                            <div class="coe-picker-style-header">
                                <span class="coe-picker-rt">{{ $style->designs?->id }}</span>
                                <span class="coe-picker-desc">{{ $style->designs?->description }}</span>
                                @if($style->customer_ref)
                                    <span class="coe-picker-ref">{{ $style->customer_ref }}</span>
                                @endif
                            </div>
                            <div class="coe-picker-colourways">
                                @foreach($style->style_versions as $version)
                                    @foreach($version->colourways as $colourway)
                                        <button class="coe-picker-cw" wire:click="addColourway({{ $colourway->id }})">
                                            {{ $colourway->name }}
                                        </button>
                                    @endforeach
                                @endforeach
                            </div>
                        </div>
                    @empty
                        <div class="coe-picker-empty">
                            <p>No styles found for this customer/season</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    @endif
    
    {{-- Colourway Picker Modal (for changing a line's colourway) --}}
    @if($showColourwayPicker)
        <div class="cse-confirm-overlay" wire:click.self="closeColourwayPicker">
            <div class="coe-picker">
                <div class="coe-picker-header">
                    <h3>Change Style / Colourway</h3>
                    <button wire:click="closeColourwayPicker"><i class="fas fa-times"></i></button>
                </div>
                
                @if($editingLineIndex !== null && isset($lines[$editingLineIndex]))
                    <div class="coe-picker-current">
                        <span class="coe-picker-current-label">Currently:</span>
                        @if($lines[$editingLineIndex]['colourway_id'])
                            <span class="coe-picker-current-value">
                                RT{{ $lines[$editingLineIndex]['rt_number'] }} - 
                                {{ $lines[$editingLineIndex]['colourway_name'] }}
                            </span>
                        @else
                            <span class="coe-picker-current-unmatched">
                                <i class="fas fa-exclamation-triangle"></i>
                                Unmatched: {{ $lines[$editingLineIndex]['imported_style_ref'] ?? 'Unknown' }} / 
                                {{ $lines[$editingLineIndex]['imported_colour'] ?? 'Unknown' }}
                            </span>
                        @endif
                    </div>
                @endif
                
                <div class="coe-picker-search">
                    <i class="fas fa-search"></i>
                    <input type="text" wire:model.live.debounce.300ms="colourwaySearch" 
                           placeholder="Search by RT, description, customer ref, colour..." autofocus>
                </div>
                
                <div class="coe-picker-results">
                    @if(strlen($colourwaySearch) < 2)
                        <div class="coe-picker-empty">
                            <p>Type at least 2 characters to search</p>
                        </div>
                    @else
                        @forelse($this->searchedStyles as $style)
                            <div class="coe-picker-style">
                                <div class="coe-picker-style-header">
                                    <span class="coe-picker-rt">{{ $style->designs?->id }}</span>
                                    <span class="coe-picker-desc">{{ $style->designs?->description }}</span>
                                    @if($style->customer_ref)
                                        <span class="coe-picker-ref">{{ $style->customer_ref }}</span>
                                    @endif
                                </div>
                                
                                @foreach($style->style_versions as $version)
                                    <div class="coe-picker-version-group">
                                        <div class="coe-picker-version-header">
                                            <span class="coe-picker-version-name">
                                                <i class="fas fa-layer-group"></i>
                                                {{ $version->name ?: 'V1' }}
                                            </span>
                                            @if($version->factories)
                                                <span class="coe-picker-version-factory">
                                                    <i class="fas fa-industry"></i>
                                                    {{ $version->factories->name }}
                                                </span>
                                            @endif
                                        </div>
                                        <div class="coe-picker-colourways">
                                            @foreach($version->colourways as $colourway)
                                                <button class="coe-picker-cw" wire:click="changeLineColourway({{ $colourway->id }})">
                                                    {{ $colourway->name }}
                                                </button>
                                            @endforeach
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @empty
                            <div class="coe-picker-empty">
                                <p>No matching styles found</p>
                            </div>
                        @endforelse
                    @endif
                </div>
                
                <div class="coe-picker-actions">
                    <button class="coe-picker-create" wire:click="openNewColourwayModal">
                        <i class="fas fa-plus"></i> Add Colourway to Existing Style
                    </button>
                    <button class="coe-picker-create" wire:click="openNewStyleModal">
                        <i class="fas fa-plus"></i> Create New Style
                    </button>
                </div>
            </div>
        </div>
    @endif
    
    {{-- Create New Colourway Modal --}}
    @if($showNewColourwayModal)
        <div class="cse-confirm-overlay" wire:click.self="closeNewColourwayModal">
            <div class="coe-create-modal">
                <div class="coe-create-header">
                    <h3>Add New Colourway</h3>
                    <button wire:click="closeNewColourwayModal"><i class="fas fa-times"></i></button>
                </div>
                <div class="coe-create-body">
                    <div class="coe-create-field">
                        <label>Select Style</label>
                        <select wire:model="newColourwayStyleId">
                            <option value="">Choose a style...</option>
                            @foreach($this->stylesForNewColourway as $style)
                                <option value="{{ $style->id }}">
                                    RT{{ $style->designs?->id }} - {{ $style->customer_ref }} - {{ $style->designs?->description }}
                                </option>
                            @endforeach
                        </select>
                        @error('newColourwayStyleId') <span class="coe-create-error">{{ $message }}</span> @enderror
                    </div>
                    <div class="coe-create-field">
                        <label>Colourway Name(s)</label>
                        <input type="text" wire:model="newColourwayName" placeholder="e.g. Navy, Multi, Pink (comma separated)">
                        <small class="text-muted">Separate multiple colourways with commas</small>
                        @error('newColourwayName') <span class="coe-create-error">{{ $message }}</span> @enderror
                    </div>
                    <div class="coe-create-field">
                        <label>Customer Ref (optional)</label>
                        <input type="text" wire:model="newColourwayCode" placeholder="e.g. K1250, K0834...">
                    </div>
                </div>
                <div class="coe-create-footer">
                    <button class="coe-btn-cancel" wire:click="closeNewColourwayModal">Cancel</button>
                    <button class="coe-btn-save" wire:click="createColourway">Create Colourway</button>
                </div>
            </div>
        </div>
    @endif
    
    {{-- Create New Style Modal --}}
    @if($showNewStyleModal)
        <div class="cse-confirm-overlay" wire:click.self="closeNewStyleModal">
            <div class="coe-create-modal">
                <div class="coe-create-header">
                    <h3>Create New Style</h3>
                    <button wire:click="closeNewStyleModal"><i class="fas fa-times"></i></button>
                </div>
                <div class="coe-create-body">
                    <p class="coe-create-note">
                        <i class="fas fa-info-circle"></i>
                        This will create a new design (RT), style, and colourway
                    </p>
                    <div class="coe-create-field">
                        <label>Customer Style Ref</label>
                        <input type="text" wire:model="newStyleCustomerRef" placeholder="e.g. K1250">
                        @error('newStyleCustomerRef') <span class="coe-create-error">{{ $message }}</span> @enderror
                    </div>
                    <div class="coe-create-field">
                        <label>Description</label>
                        <input type="text" wire:model="newStyleDescription" placeholder="e.g. Anastasia Cashmere Jumper">
                        @error('newStyleDescription') <span class="coe-create-error">{{ $message }}</span> @enderror
                    </div>
                    <div class="coe-create-field">
                        <label>Yarn</label>
                        <input type="text" wire:model="newStyleYarn" placeholder="e.g. 100% Cashmere">
                        @error('newStyleYarn') <span class="coe-create-error">{{ $message }}</span> @enderror
                    </div>
                    <div class="coe-create-field">
                        <label>Factory</label>
                        <select wire:model="newStyleFactoryId">
                            @foreach($this->commissionFactories as $factory)
                                <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                            @endforeach
                        </select>
                        @error('newStyleFactoryId') <span class="coe-create-error">{{ $message }}</span> @enderror
                    </div>
                    <div class="coe-create-field">
                        <label>Colourway Name(s)</label>
                        <input type="text" wire:model="newStyleColourName" placeholder="e.g. Navy, Multi, Pink (comma separated)">
                        <small class="text-muted">Separate multiple colourways with commas</small>
                        @error('newStyleColourName') <span class="coe-create-error">{{ $message }}</span> @enderror
                    </div>
                </div>
                <div class="coe-create-footer">
                    <button class="coe-btn-cancel" wire:click="closeNewStyleModal">Cancel</button>
                    <button class="coe-btn-save" wire:click="createStyle">Create Style</button>
                </div>
            </div>
        </div>
    @endif

    {{-- Forward to PD Modal --}}
    @if($showForwardModal)
        <div class="cse-confirm-overlay" wire:click.self="closeForwardModal">
            <div class="cse-confirm-modal">
                <div class="cse-confirm-header">
                    <i class="fas fa-paper-plane text-success"></i>
                    <h4>Send to PD</h4>
                </div>
                <p class="text-muted">Select a PD user to review this order.</p>
                
                <div class="mb-3">
                    <label class="form-label">Select PD User <span class="text-danger">*</span></label>
                    <select wire:model.live="forwardToUserId" class="form-select" @if($forwardSelfCertified) disabled @endif>
                        <option value="">-- Select --</option>
                        @foreach($this->pdUsers as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                    @error('forwardToUserId') <div class="text-danger small">{{ $message }}</div> @enderror
                </div>
                <div class="mb-3">
                    <label class="form-label">Notes (optional)</label>
                    <textarea wire:model="forwardNotes" class="form-control" rows="2" 
                              placeholder="Add any notes for the PD reviewer..."></textarea>
                </div>
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="coe-forward-self-certify"
                               wire:model="forwardSelfCertified">
                        <label class="form-check-label" for="coe-forward-self-certify">
                            I certify this order is approved to move to the next stage.
                        </label>
                    </div>
                    @error('forwardSelfCertified')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                    @if($forwardSelfCertified)
                        <div class="text-muted small mt-1">
                            You will be assigned as the PD reviewer.
                        </div>
                    @endif
                </div>
                
                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeForwardModal">Cancel</button>
                    <button class="cse-btn cse-btn-success" wire:click="forwardToPd"
                            wire:loading.attr="disabled"
                            @if(!$forwardSelfCertified && !$forwardToUserId) disabled @endif>
                        <span wire:loading.remove wire:target="forwardToPd">
                            <i class="fas fa-paper-plane"></i> Send to PD
                        </span>
                        <span wire:loading wire:target="forwardToPd">
                            <i class="fas fa-spinner fa-spin"></i> Sending...
                        </span>
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Approval Modal --}}
    @if($showApprovalModal)
        <div class="cse-confirm-overlay" wire:click.self="closeApprovalModal">
            <div class="cse-confirm-modal">
                <div class="cse-confirm-header">
                    @if($approvalType === 'pd')
                        <i class="fas fa-check text-info"></i>
                        <h4>PD Approval</h4>
                    @else
                        <i class="fas fa-check-double text-success"></i>
                        <h4>Confirm Order</h4>
                    @endif
                </div>
                
                @if($approvalError)
                    <div class="alert alert-danger d-flex align-items-center gap-2 mb-3" style="font-size: 0.875rem;">
                        <i class="fas fa-exclamation-circle"></i>
                        {{ $approvalError }}
                    </div>
                @endif
                
                @if($approvalType === 'pd')
                    <p class="text-muted">Approving this order will send it to Merch for final confirmation.</p>
                @else
                    <p class="text-muted">Confirming this order will make it visible in the main Orders list and Shipment Schedule.</p>
                @endif
                
                <div class="mb-3">
                    <label class="form-label">Notes (optional)</label>
                    <textarea wire:model="approvalNotes" class="form-control" rows="2" 
                              placeholder="Add any notes..."></textarea>
                </div>
                
                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeApprovalModal">Cancel</button>
                    <button class="cse-btn cse-btn-success" wire:click="submitApproval" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="submitApproval">
                            <i class="fas fa-check"></i> {{ $approvalType === 'pd' ? 'Approve' : 'Confirm' }}
                        </span>
                        <span wire:loading wire:target="submitApproval">
                            <i class="fas fa-spinner fa-spin"></i> Submitting...
                        </span>
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Send Back to PD Modal --}}
    @if($showSendBackModal)
        <div class="cse-confirm-overlay" wire:click.self="closeSendBackModal">
            <div class="cse-confirm-modal">
                <div class="cse-confirm-header">
                    <i class="fas fa-undo text-warning"></i>
                    <h4>Send Back to PD</h4>
                </div>
                <p class="text-muted">This order will be sent back to PD for further review.</p>
                
                <div class="mb-3">
                    <label class="form-label">Send to <span class="text-danger">*</span></label>
                    <select wire:model.live="sendBackToUserId" class="form-select">
                        <option value="">Select PD user...</option>
                        @foreach($this->pdUsers as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                    @error('sendBackToUserId') 
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Reason / Notes</label>
                    <textarea wire:model="sendBackNotes" class="form-control" rows="2" 
                              placeholder="Explain why this is being sent back..."></textarea>
                </div>
                
                <div class="cse-confirm-actions">
                    <button class="cse-btn cse-btn-secondary" wire:click="closeSendBackModal">Cancel</button>
                    <button class="cse-btn cse-btn-warning" wire:click="sendBackToPd" wire:loading.attr="disabled"
                            @if(!$sendBackToUserId) disabled @endif>
                        <span wire:loading.remove wire:target="sendBackToPd">
                            <i class="fas fa-undo"></i> Send Back
                        </span>
                        <span wire:loading wire:target="sendBackToPd">
                            <i class="fas fa-spinner fa-spin"></i> Sending...
                        </span>
                    </button>
                </div>
            </div>
        </div>
    @endif

</div>
