<div class="commission-orders"
     x-init="
         const container = $refs.scrollContainer;
         if (container) {
             container.addEventListener('scroll', () => {
                 if (container.scrollTop + container.clientHeight >= container.scrollHeight - 200) {
                     if ($wire.hasMore && !$wire.isLoading) {
                         $wire.loadMore();
                     }
                 }
             });
         }
     ">
    {{-- Header --}}
    <x-commission.page-header 
        title="Invoices"
        :stats="[
            ['label' => 'Draft', 'value' => $this->stats['draft'], 'class' => 'pending'],
            ['label' => 'Sent', 'value' => $this->stats['ready'] + $this->stats['sent_to_zoho'] + $this->stats['complete'], 'class' => 'confirmed'],
        ]"
        searchPlaceholder="Search by reference, customer..."
        searchModel="search"
        :search="$search"
    >
        <x-slot name="actions">
            <button class="comm-create-btn" wire:click="$dispatch('create-new-invoice')">
                <i class="fas fa-plus"></i>
                <span>New Invoice</span>
            </button>
        </x-slot>
    </x-commission.page-header>

    {{-- Filters Bar --}}
    <x-commission.filters-bar :activeFiltersCount="$this->activeFiltersCount" clearAction="clearFilters">
        {{-- Status Dropdown --}}
        <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
            <button class="cfilter-dropdown-btn {{ $status ? 'has-value' : '' }}" @click="open = !open">
                <i class="fas fa-tag cfilter-icon"></i>
                <span class="cfilter-label">
                    @if($status)
                        {{ $this->statusOptions[$status]['label'] ?? 'Status' }}
                    @else
                        All Statuses
                    @endif
                </span>
                <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
            </button>
            <div class="cfilter-dropdown-menu" x-show="open" x-cloak
                 x-transition:enter="transition ease-out duration-150"
                 x-transition:enter-start="opacity-0 transform -translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-100"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0">
                <button class="cfilter-option {{ !$status ? 'selected' : '' }}" 
                        wire:click="$set('status', '')" @click="open = false">
                    <i class="fas fa-layer-group"></i>
                    All Statuses
                    @if(!$status)<i class="fas fa-check cfilter-check"></i>@endif
                </button>
                @foreach($this->statusOptions as $key => $opt)
                    <button class="cfilter-option {{ $status === $key ? 'selected' : '' }}" 
                            wire:click="$set('status', '{{ $key }}')" @click="open = false">
                        <i class="fas {{ $opt['icon'] }}"></i>
                        {{ $opt['label'] }}
                        @if($status === $key)<i class="fas fa-check cfilter-check"></i>@endif
                    </button>
                @endforeach
            </div>
        </div>

        {{-- Customer Dropdown --}}
        <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
            <button class="cfilter-dropdown-btn {{ $customer ? 'has-value' : '' }}" @click="open = !open">
                <i class="fas fa-building cfilter-icon"></i>
                <span class="cfilter-label">
                    @if($customer)
                        {{ $this->customers->firstWhere('id', $customer)?->name ?? 'Customer' }}
                    @else
                        All Customers
                    @endif
                </span>
                <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
            </button>
            <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                 x-transition:enter="transition ease-out duration-150"
                 x-transition:enter-start="opacity-0 transform -translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-100"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0">
                <div class="cfilter-search">
                    <i class="fas fa-search"></i>
                    <input type="text" placeholder="Search customers..." x-model="search" @click.stop>
                </div>
                <div class="cfilter-options">
                    <button class="cfilter-option {{ !$customer ? 'selected' : '' }}" 
                            x-show="!search || 'all customers'.includes(search.toLowerCase())"
                            wire:click="$set('customer', '')" @click="open = false; search = ''">
                        <i class="fas fa-users"></i>
                        All Customers
                        @if(!$customer)<i class="fas fa-check cfilter-check"></i>@endif
                    </button>
                    @foreach($this->customers as $c)
                        <button class="cfilter-option {{ $customer == $c->id ? 'selected' : '' }}" 
                                x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                wire:click="$set('customer', '{{ $c->id }}')" @click="open = false; search = ''">
                            <i class="fas fa-building"></i>
                            {{ $c->name }}
                            @if($customer == $c->id)<i class="fas fa-check cfilter-check"></i>@endif
                        </button>
                    @endforeach
                </div>
            </div>
        </div>

        {{-- Date Range --}}
        <div class="cfilter-dropdown" x-data="{ open: false }" @click.away="open = false">
            <button class="cfilter-dropdown-btn {{ $dateFrom || $dateTo ? 'has-value' : '' }}" @click="open = !open">
                <i class="fas fa-calendar cfilter-icon"></i>
                <span class="cfilter-label">
                    @if($dateFrom && $dateTo)
                        {{ \Carbon\Carbon::parse($dateFrom)->format('d M') }} - {{ \Carbon\Carbon::parse($dateTo)->format('d M') }}
                    @elseif($dateFrom)
                        From {{ \Carbon\Carbon::parse($dateFrom)->format('d M') }}
                    @elseif($dateTo)
                        Until {{ \Carbon\Carbon::parse($dateTo)->format('d M') }}
                    @else
                        Date Range
                    @endif
                </span>
                <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
            </button>
            <div class="cfilter-dropdown-menu cfilter-date-menu" x-show="open" x-cloak
                 x-transition:enter="transition ease-out duration-150"
                 x-transition:enter-start="opacity-0 transform -translate-y-2"
                 x-transition:enter-end="opacity-100 transform translate-y-0"
                 x-transition:leave="transition ease-in duration-100"
                 x-transition:leave-start="opacity-100"
                 x-transition:leave-end="opacity-0"
                 @click.stop>
                <div class="cfilter-date-row">
                    <label>From</label>
                    <input type="date" wire:model.live="dateFrom" class="cfilter-date-input">
                </div>
                <div class="cfilter-date-row">
                    <label>To</label>
                    <input type="date" wire:model.live="dateTo" class="cfilter-date-input">
                </div>
                @if($dateFrom || $dateTo)
                    <button class="cfilter-date-clear" wire:click="$set('dateFrom', ''); $set('dateTo', '')" @click="open = false">
                        <i class="fas fa-times"></i> Clear dates
                    </button>
                @endif
            </div>
        </div>

        {{-- Show Sent Toggle --}}
        <button class="cfilter-toggle {{ $showCompleted ? 'active' : '' }}" wire:click="toggleShowCompleted">
            <i class="fas {{ $showCompleted ? 'fa-eye' : 'fa-eye-slash' }}"></i>
            <span>Show Sent</span>
        </button>
    </x-commission.filters-bar>

    {{-- Content --}}
    <div class="csamp-content" x-ref="scrollContainer">
        {{-- Loading overlay --}}
        <div class="csamp-loading" wire:loading.delay wire:target="loadInitialInvoices">
            <div class="spinner-border text-light" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>

        @if(empty($loadedInvoices))
            {{-- Empty State --}}
            <div class="csamp-empty">
                <div class="csamp-empty-icon">
                    <i class="fas fa-file-invoice"></i>
                </div>
                <h3>No invoices found</h3>
                <p>Try adjusting your search or filters</p>
                @if($this->activeFiltersCount > 0)
                    <button class="btn btn-commission mt-3" wire:click="clearFilters">
                        Clear all filters
                    </button>
                @endif
            </div>
        @else
            {{-- Table --}}
            <div class="csamp-table-container">
                <table class="csamp-table co-orders-table">
                    <thead>
                        <tr>
                            <th class="csamp-th-sortable" wire:click="sort('id')" style="width: 80px;">
                                <span>ID</span>
                                @if($sortBy === 'id')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="csamp-th-sortable" wire:click="sort('reference')">
                                <span>Reference</span>
                                @if($sortBy === 'reference')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th>Customer</th>
                            <th class="csamp-th-sortable" wire:click="sort('invoice_date')">
                                <span>Date</span>
                                @if($sortBy === 'invoice_date')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="csamp-th-sortable" wire:click="sort('status')">
                                <span>Status</span>
                                @if($sortBy === 'status')
                                    <i class="fas fa-sort-{{ $sortDir === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="fas fa-sort csamp-sort-inactive"></i>
                                @endif
                            </th>
                            <th class="text-center">Drops</th>
                            <th class="text-end">Qty</th>
                            <th class="text-end">Value</th>
                            <th class="csamp-th-actions">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($loadedInvoices as $invoice)
                            @php
                                $statusOpt = $this->statusOptions[$invoice['status']] ?? null;
                            @endphp
                            <tr class="csamp-row" 
                                wire:key="invoice-{{ $invoice['id'] }}"
                                @click="$wire.$dispatch('open-invoice-edit', { invoiceId: {{ $invoice['id'] }} })"
                                style="cursor: pointer;">
                                
                                {{-- ID --}}
                                <td>
                                    <span class="co-order-id">#{{ $invoice['id'] }}</span>
                                </td>
                                
                                {{-- Reference --}}
                                <td>
                                    <span class="csamp-rt">{{ $invoice['reference'] ?? '—' }}</span>
                                    @if($invoice['supplier_invoice_ref'])
                                        <div class="co-source-file">
                                            <i class="fas fa-tag"></i>
                                            {{ $invoice['supplier_invoice_ref'] }}
                                        </div>
                                    @endif
                                </td>
                                
                                {{-- Customer --}}
                                <td>
                                    <span class="csamp-desc">{{ $invoice['customer_name'] ?? '—' }}</span>
                                </td>
                                
                                {{-- Date --}}
                                <td>
                                    @if($invoice['invoice_date'])
                                        <span class="csamp-desc">{{ $invoice['invoice_date'] }}</span>
                                    @else
                                        <span class="csamp-date-empty">—</span>
                                    @endif
                                </td>
                                
                                {{-- Status Badge --}}
                                <td>
                                    @if($statusOpt)
                                        <span class="co-status-badge co-status-{{ $invoice['status'] }}">
                                            <i class="fas {{ $statusOpt['icon'] }}"></i>
                                            {{ $statusOpt['label'] }}
                                        </span>
                                    @endif
                                </td>
                                
                                {{-- Drops --}}
                                <td class="text-center">
                                    <span class="co-lines-badge">{{ $invoice['drops_count'] }}</span>
                                    @if($invoice['status'] === 'draft' && $invoice['unshipped_drops_count'] > 0)
                                        <div class="co-unmatched-count">{{ $invoice['unshipped_drops_count'] }} unshipped</div>
                                    @endif
                                </td>
                                
                                {{-- Qty --}}
                                <td class="text-end">
                                    <span class="csamp-tracking">{{ number_format($invoice['total_qty']) }}</span>
                                </td>
                                
                                {{-- Value --}}
                                <td class="text-end">
                                    <span class="co-value">{{ $invoice['customer_currency'] }}{{ number_format($invoice['total_value'], 2) }}</span>
                                </td>
                                
                                {{-- Actions --}}
                                <td class="csamp-td-actions" wire:click.stop>
                                    <div class="co-action-group">
                                        {{-- View/Edit --}}
                                        <button class="csamp-action-btn" title="View/Edit"
                                                wire:click="$dispatch('open-invoice-edit', { invoiceId: {{ $invoice['id'] }} })">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        
                                        {{-- Download File --}}
                                        @if($invoice['invoice_file_path'])
                                            <button class="csamp-action-btn" 
                                                    title="Download file"
                                                    wire:click="downloadFile({{ $invoice['id'] }})">
                                                <i class="fas fa-download"></i>
                                            </button>
                                        @endif
                                        
                                        {{-- Status-specific actions --}}
                                        @if($invoice['status'] === 'draft')
                                            @if($invoice['drops_count'] === 0)
                                                <button class="csamp-action-btn co-action-primary"
                                                        title="Add drops"
                                                        wire:click="$dispatch('open-invoice-edit', { invoiceId: {{ $invoice['id'] }} })">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            @elseif($invoice['unshipped_drops_count'] > 0)
                                                <button class="csamp-action-btn co-action-warning" 
                                                        title="Mark {{ $invoice['unshipped_drops_count'] }} drop(s) shipped & send to finance" 
                                                        wire:click="markShippedAndReady({{ $invoice['id'] }})"
                                                        wire:confirm="Mark {{ $invoice['unshipped_drops_count'] }} drop(s) as shipped and send to finance?">
                                                    <i class="fas fa-truck"></i>
                                                </button>
                                            @else
                                                <button class="csamp-action-btn co-action-success" 
                                                        title="Send to Finance" 
                                                        wire:click="markReady({{ $invoice['id'] }})"
                                                        wire:confirm="Send this invoice to finance?">
                                                    <i class="fas fa-paper-plane"></i>
                                                </button>
                                            @endif
                                        @endif
                                        
                                        {{-- Sent indicator for completed invoices --}}
                                        @if(in_array($invoice['status'], ['ready', 'sent_to_zoho', 'complete']))
                                            <span class="csamp-action-btn co-action-done" title="Sent" style="cursor: default; opacity: 0.7;">
                                                <i class="fas fa-check"></i>
                                            </span>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Loading More Indicator --}}
            @if($hasMore)
                <div class="csamp-load-more" wire:loading.remove wire:target="loadMore">
                    <div class="csamp-load-more-trigger" x-intersect="$wire.loadMore()">
                        <i class="fas fa-circle-notch fa-spin"></i>
                        <span>Loading more...</span>
                    </div>
                </div>
            @else
                <div class="csamp-end-of-list">
                    <span>{{ count($loadedInvoices) }} invoices loaded</span>
                </div>
            @endif

            {{-- Loading indicator when fetching more --}}
            <div class="csamp-load-more" wire:loading wire:target="loadMore">
                <i class="fas fa-circle-notch fa-spin"></i>
                <span>Loading more...</span>
            </div>
        @endif
    </div>

    {{-- Invoice Edit Panel --}}
    @livewire('commission.invoice-edit')
</div>
