<div x-data="{ showConfirm: false }" 
     x-on:confirm-close.window="showConfirm = true"
     x-on:keydown.escape.window="if ($wire.isOpen && !showConfirm) $wire.close()">
    
    {{-- Backdrop --}}
    @if($isOpen)
        <div class="cse-backdrop" wire:click="close"></div>
    @endif

    {{-- Unsaved Changes Confirmation --}}
    <div class="cse-confirm-modal" x-show="showConfirm" x-cloak>
        <div class="cse-confirm-backdrop" @click="showConfirm = false"></div>
        <div class="cse-confirm-dialog">
            <div class="cse-confirm-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h3>Unsaved Changes</h3>
            <p>You have unsaved changes. Are you sure you want to close?</p>
            <div class="cse-confirm-actions">
                <button class="cse-btn cse-btn-secondary" @click="showConfirm = false">
                    Keep Editing
                </button>
                <button class="cse-btn cse-btn-danger" @click="showConfirm = false; $wire.forceClose()">
                    Discard Changes
                </button>
            </div>
        </div>
    </div>

    {{-- Slide Panel --}}
    <div class="cse-panel {{ $isOpen ? 'open' : '' }}">
        @if($isOpen)
            {{-- Header --}}
            <header class="cse-header">
                <div class="cse-header-info">
                    @if($isNewInvoice)
                        <span class="cse-badge cse-badge-new"><i class="fas fa-plus"></i></span>
                        <h2 class="cse-title">New Invoice</h2>
                    @else
                        <span class="cse-badge">{{ $reference ?: 'No Ref' }}</span>
                        <h2 class="cse-title">Edit Invoice</h2>
                    @endif
                    @if($isDirty)
                        <span class="cse-dirty-badge">Unsaved</span>
                    @endif
                </div>
                <button class="cse-close" wire:click="close">
                    <i class="fas fa-times"></i>
                </button>
            </header>

            {{-- Toast Notifications --}}
            @if(session()->has('inv-message'))
                <div class="cse-toast cse-toast-success" 
                     x-data="{ show: true }" 
                     x-show="show" 
                     x-init="setTimeout(() => show = false, 3000)"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0">
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('inv-message') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif
            @if(session()->has('inv-error'))
                <div class="cse-toast cse-toast-error"
                     x-data="{ show: true }" 
                     x-show="show"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0">
                    <i class="fas fa-exclamation-circle"></i>
                    <span>{{ session('inv-error') }}</span>
                    <button type="button" @click="show = false" class="cse-toast-close">&times;</button>
                </div>
            @endif

            {{-- Tabs --}}
            <nav class="cse-tabs">
                <button 
                    class="cse-tab {{ $activeTab === 'details' ? 'active' : '' }}"
                    wire:click="$set('activeTab', 'details')"
                >
                    <i class="fas fa-info-circle"></i>
                    Details
                </button>
                <button 
                    class="cse-tab {{ $activeTab === 'drops' ? 'active' : '' }}"
                    wire:click="$set('activeTab', 'drops')"
                >
                    <i class="fas fa-truck"></i>
                    Drops
                    @if(count($selectedDrops) > 0)
                        <span class="cse-tab-badge">{{ count($selectedDrops) }}</span>
                    @endif
                </button>
            </nav>

            {{-- Content --}}
            <div class="cse-content">
                
                {{-- Details Tab --}}
                @if($activeTab === 'details')
                    <div class="cse-section">
                        {{-- Summary Cards --}}
                        <div class="coe-summary">
                            <div class="coe-summary-card">
                                <span class="coe-summary-label">Drops</span>
                                <span class="coe-summary-value">{{ count($selectedDrops) }}</span>
                            </div>
                            <div class="coe-summary-card">
                                <span class="coe-summary-label">Total Qty</span>
                                <span class="coe-summary-value">{{ number_format($this->totalQty) }}</span>
                            </div>
                            <div class="coe-summary-card coe-summary-value-card">
                                <span class="coe-summary-label">Total Value</span>
                                <span class="coe-summary-value">{{ $this->currencySymbol }}{{ number_format($this->totalValue, 2) }}</span>
                            </div>
                        </div>

                        {{-- Form Grid --}}
                        <div class="cse-grid">
                            <div class="cse-field">
                                <label class="cse-label">Customer <span class="text-danger">*</span></label>
                                <select class="form-select @error('customer_id') is-invalid @enderror" 
                                        wire:model.live="customer_id"
                                        {{ $invoiceId ? 'disabled' : '' }}>
                                    <option value="">Select Customer</option>
                                    @foreach($this->customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                                @if($invoiceId)
                                    <small class="text-muted"><i class="fas fa-lock"></i> Locked</small>
                                @endif
                                @error('customer_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Invoice Date</label>
                                <input type="date" class="form-control @error('invoiceDate') is-invalid @enderror" 
                                       wire:model.blur="invoiceDate">
                                @error('invoiceDate') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Reference</label>
                                <input type="text" class="form-control @error('reference') is-invalid @enderror" 
                                       wire:model.blur="reference" placeholder="Invoice reference">
                                @error('reference') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="cse-field">
                                <label class="cse-label">Supplier Invoice Ref</label>
                                <input type="text" class="form-control @error('supplierInvoiceRef') is-invalid @enderror" 
                                       wire:model.blur="supplierInvoiceRef" placeholder="Supplier reference">
                                @error('supplierInvoiceRef') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            @if(!$isNewInvoice && $status)
                                <div class="cse-field">
                                    <label class="cse-label">Status</label>
                                    <div class="coe-status-display">
                                        <span class="co-status-badge co-status-{{ $status }}">
                                            @if(in_array($status, ['ready', 'sent_to_zoho', 'complete']))
                                                Sent to Finance
                                            @else
                                                {{ ucwords(str_replace('_', ' ', $status)) }}
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            @endif

                            <div class="cse-field cse-field-full">
                                <label class="cse-label">Notes</label>
                                <textarea class="form-control" wire:model.blur="notes" rows="3" 
                                          placeholder="Additional notes..."></textarea>
                            </div>

                            <div class="cse-field cse-field-full">
                                <label class="cse-label">Invoice File</label>
                                @if($existingFileName)
                                    <div class="cinv-existing-file mb-2">
                                        <i class="fas fa-file-pdf text-danger"></i>
                                        <span>{{ $existingFileName }}</span>
                                        <button type="button" class="btn btn-sm btn-outline-primary ms-2" wire:click="downloadFile">
                                            <i class="fas fa-download"></i> Download
                                        </button>
                                    </div>
                                @endif
                                <input type="file" class="form-control @error('invoiceFile') is-invalid @enderror" 
                                       wire:model="invoiceFile" accept=".pdf,.jpg,.jpeg,.png,.gif">
                                <small class="text-muted">PDF, JPG, PNG or GIF (max 10MB)</small>
                                @error('invoiceFile') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                
                                <div wire:loading wire:target="invoiceFile" class="mt-2">
                                    <span class="spinner-border spinner-border-sm"></span> Uploading...
                                </div>
                            </div>
                        </div>
                    </div>

                {{-- Drops Tab --}}
                @elseif($activeTab === 'drops')
                    <div class="cse-section cinv-drops-section">
                        {{-- Header with search --}}
                        <div class="cinv-drops-header">
                            <div class="cinv-drops-search">
                                <i class="fas fa-search"></i>
                                <input type="text" wire:model.live.debounce.300ms="dropSearch" 
                                       placeholder="Search PO, style, colour...">
                            </div>
                            <div class="cinv-drops-actions">
                                <button class="cse-btn cse-btn-sm" wire:click="selectAllDrops">Select All</button>
                                <button class="cse-btn cse-btn-sm cse-btn-secondary" wire:click="deselectAllDrops">Clear</button>
                            </div>
                        </div>

                        @if(!$customer_id)
                            <div class="cse-cw-empty">
                                <i class="fas fa-user"></i>
                                <p>Select a customer first</p>
                                <span>Customer is required to view available drops</span>
                            </div>
                        @elseif($this->availableDrops->isEmpty())
                            <div class="cse-cw-empty">
                                <i class="fas fa-truck"></i>
                                <p>No shipped drops available</p>
                                <span>Only shipped drops can be added to an invoice</span>
                            </div>
                        @else
                            <div class="cinv-drops-list">
                                @foreach($this->availableDrops as $drop)
                                    @php
                                        $line = $drop->line;
                                        $order = $line?->order;
                                        $colourway = $line?->colourway;
                                        $design = $colourway?->style_versions?->styles?->designs;
                                        $isSelected = in_array($drop->id, $selectedDrops);
                                        $totalQty = $drop->sizes->sum('qty');
                                    @endphp
                                    <div class="cinv-drop-row {{ $isSelected ? 'selected' : '' }}"
                                         wire:click="toggleDrop({{ $drop->id }})"
                                         wire:key="drop-{{ $drop->id }}">
                                        <div class="cinv-checkbox {{ $isSelected ? 'checked' : '' }}">
                                            @if($isSelected)
                                                <i class="fas fa-check"></i>
                                            @endif
                                        </div>
                                        <div class="cinv-drop-info">
                                            <div class="cinv-drop-main">
                                                <span class="cinv-drop-rt">RT{{ $design?->id ?? '—' }}</span>
                                                <span class="cinv-drop-style">{{ $colourway?->name ?? $line?->imported_colour ?? '—' }}</span>
                                            </div>
                                            <div class="cinv-drop-meta">
                                                <span class="cinv-drop-po"><i class="fas fa-file-alt"></i> {{ $order?->customer_po ?? '—' }}</span>
                                                <span class="cinv-drop-qty"><i class="fas fa-cubes"></i> {{ $totalQty }} pcs</span>
                                                @if($drop->shipped_date)
                                                    <span class="cinv-drop-date"><i class="fas fa-calendar"></i> {{ $drop->shipped_date->format('d M') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        {{-- Selected summary --}}
                        @if(count($selectedDrops) > 0)
                            <div class="cinv-drops-summary">
                                <div class="cinv-summary-stats">
                                    <div class="cinv-summary-stat">
                                        <span class="cinv-summary-value">{{ count($selectedDrops) }}</span>
                                        <span class="cinv-summary-label">Drops</span>
                                    </div>
                                    <div class="cinv-summary-divider"></div>
                                    <div class="cinv-summary-stat">
                                        <span class="cinv-summary-value">{{ number_format($this->totalShippedPcs) }}</span>
                                        <span class="cinv-summary-label">Total Shipped Pcs</span>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                @endif
            </div>

            {{-- Footer --}}
            <footer class="cse-footer">
                <button class="cse-btn cse-btn-secondary" wire:click="close">
                    Close
                </button>
                
                <div class="coe-footer-actions">
                    <button class="cse-btn cse-btn-primary" 
                            wire:click="save"
                            wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="save">
                            @if($isNewInvoice)
                                <i class="fas fa-plus"></i> Create Invoice
                            @else
                                <i class="fas fa-save"></i> Save
                            @endif
                        </span>
                        <span wire:loading wire:target="save">
                            <i class="fas fa-spinner fa-spin"></i> Saving...
                        </span>
                    </button>
                    
                    {{-- Workflow buttons based on status --}}
                    @if(!$isNewInvoice && $status === 'draft')
                        @if($this->unshippedDropsCount > 0)
                            <button class="cse-btn cse-btn-warning" 
                                    wire:click="markShippedAndReady"
                                    wire:loading.attr="disabled"
                                    wire:confirm="Mark {{ $this->unshippedDropsCount }} drop(s) as shipped and send to finance?">
                                <span wire:loading.remove wire:target="markShippedAndReady">
                                    <i class="fas fa-truck"></i> Ship & Send
                                </span>
                                <span wire:loading wire:target="markShippedAndReady">
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>
                            </button>
                        @else
                            <button class="cse-btn cse-btn-success" 
                                    wire:click="markReady"
                                    wire:loading.attr="disabled"
                                    wire:confirm="Send this invoice to finance?">
                                <span wire:loading.remove wire:target="markReady">
                                    <i class="fas fa-paper-plane"></i> Send to Finance
                                </span>
                                <span wire:loading wire:target="markReady">
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>
                            </button>
                        @endif
                    @endif
                </div>
            </footer>
        @endif
    </div>
</div>

