<div class="commission-orders">
    {{-- Header --}}
    <header class="comm-header">
        <div class="comm-header-content">
            <div class="comm-title-section">
                <a href="{{ route('commission.invoices') }}" class="comm-back-btn">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <div class="comm-title-info">
                    <h1 class="comm-page-title">
                        @if($invoiceGroupId)
                            Invoice #{{ $invoiceGroupId }}
                        @elseif($mode === 'create')
                            New Invoice
                        @else
                            Import Invoice
                        @endif
                    </h1>
                    @if($this->currentInvoiceGroup)
                        <span class="co-status-badge co-status-{{ $this->currentInvoiceGroup->status }}">
                            {{ ucfirst(str_replace('_', ' ', $this->currentInvoiceGroup->status)) }}
                        </span>
                    @endif
                </div>
            </div>
            
            <div class="comm-actions">
                @if($invoiceGroupId && $this->currentInvoiceGroup?->status === 'draft')
                    @php
                        $unshippedCount = $this->unshippedDropsCount;
                        $hasDrops = count($selectedDrops) > 0;
                    @endphp
                    
                    @if($unshippedCount > 0 && $hasDrops)
                        <button class="comm-create-btn comm-btn-warning" 
                                wire:click="markShippedAndReady" 
                                wire:confirm="Mark {{ $unshippedCount }} drop(s) as shipped and send to finance?">
                            <i class="fas fa-truck"></i>
                            <span>Ship & Send to Finance</span>
                        </button>
                    @elseif($hasDrops)
                        <button class="comm-create-btn comm-btn-success" 
                                wire:click="markReady" 
                                wire:confirm="Send this invoice to finance?">
                            <i class="fas fa-paper-plane"></i>
                            <span>Send to Finance</span>
                        </button>
                    @endif
                @endif
            </div>
        </div>
    </header>

    {{-- Content --}}
    <div class="csamp-content">
        <div class="cinv-layout">
            {{-- Left Column: Invoice Details --}}
            <div class="cinv-form-card">
                <div class="cinv-form-section">
                    <h3 class="cinv-section-title">
                        <i class="fas fa-file-invoice"></i>
                        Invoice Details
                    </h3>
                    
                    {{-- Customer --}}
                    <div class="cinv-form-group">
                        <label class="cinv-form-label">Customer <span class="text-danger">*</span></label>
                        <select class="comm-filter-select w-100" 
                                wire:model.live="selectedCustomer" 
                                @if($invoiceGroupId && $this->currentInvoiceGroup?->status !== 'draft') disabled @endif>
                            <option value="">Select customer...</option>
                            @foreach($this->customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Reference --}}
                    <div class="cinv-form-group">
                        <label class="cinv-form-label">Reference</label>
                        <input type="text" class="comm-filter-input w-100" wire:model="reference" placeholder="e.g. INV-001">
                    </div>

                    {{-- Row: Date + Supplier Ref --}}
                    <div class="cinv-form-row">
                        <div class="cinv-form-group">
                            <label class="cinv-form-label">Invoice Date</label>
                            <input type="date" class="comm-filter-input w-100" wire:model="invoiceDate">
                        </div>
                        <div class="cinv-form-group">
                            <label class="cinv-form-label">Supplier Ref</label>
                            <input type="text" class="comm-filter-input w-100" wire:model="supplierInvoiceRef" placeholder="Optional">
                        </div>
                    </div>

                    {{-- Notes --}}
                    <div class="cinv-form-group">
                        <label class="cinv-form-label">Notes</label>
                        <textarea class="comm-filter-input w-100" wire:model="notes" rows="2" placeholder="Optional notes..."></textarea>
                    </div>
                </div>

                {{-- File Upload Section --}}
                <div class="cinv-form-section">
                    <h3 class="cinv-section-title">
                        <i class="fas fa-paperclip"></i>
                        Attachment
                        <span class="cinv-optional">(optional)</span>
                    </h3>
                    
                    <div class="cinv-file-zone" 
                         x-data="{ dragOver: false }"
                         x-on:dragover.prevent="dragOver = true"
                         x-on:dragleave.prevent="dragOver = false"
                         x-on:drop.prevent="dragOver = false"
                         :class="{ 'drag-over': dragOver }">
                        
                        @if($this->currentInvoiceGroup?->invoice_file_path && !$invoiceFile)
                            <div class="cinv-file-attached">
                                <i class="fas fa-file-pdf"></i>
                                <div class="cinv-file-info">
                                    <span class="cinv-file-name">{{ $this->currentInvoiceGroup->invoice_file_name }}</span>
                                    <span class="cinv-file-meta">{{ $this->currentInvoiceGroup->invoice_uploaded_at?->diffForHumans() }}</span>
                                </div>
                                <label for="invoiceFileInput" class="cinv-file-action">Replace</label>
                            </div>
                        @elseif($invoiceFile)
                            <div class="cinv-file-attached">
                                <i class="fas fa-file"></i>
                                <div class="cinv-file-info">
                                    <span class="cinv-file-name">{{ $invoiceFile->getClientOriginalName() }}</span>
                                    <span class="cinv-file-meta">{{ round($invoiceFile->getSize() / 1024) }} KB</span>
                                </div>
                                <button type="button" class="cinv-file-action danger" wire:click="$set('invoiceFile', null)">
                                    Remove
                                </button>
                            </div>
                        @else
                            <label for="invoiceFileInput" class="cinv-file-dropzone">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span>Drop file or click to upload</span>
                                <small>PDF, JPG, PNG (max 10MB)</small>
                            </label>
                        @endif
                        
                        <input type="file" 
                               id="invoiceFileInput" 
                               class="d-none" 
                               wire:model="invoiceFile"
                               accept=".pdf,.jpg,.jpeg,.png,.gif">
                    </div>
                    @error('invoiceFile') 
                        <span class="text-danger small mt-1 d-block">{{ $message }}</span> 
                    @enderror
                </div>

                {{-- Actions --}}
                <div class="cinv-form-actions">
                    <button class="btn btn-outline-secondary" wire:click="cancel">Cancel</button>
                    <button class="btn btn-commission" wire:click="saveInvoiceGroup" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="saveInvoiceGroup">
                            <i class="fas fa-save me-1"></i>
                            {{ $invoiceGroupId ? 'Save Changes' : 'Create Invoice' }}
                        </span>
                        <span wire:loading wire:target="saveInvoiceGroup">
                            <i class="fas fa-spinner fa-spin me-1"></i> Saving...
                        </span>
                    </button>
                </div>
            </div>

            {{-- Right Column: Drops --}}
            <div class="cinv-drops-panel">
                <div class="cinv-drops-header">
                    <h3 class="cinv-section-title">
                        <i class="fas fa-boxes"></i>
                        Drops
                        @if(count($selectedDrops) > 0)
                            <span class="cinv-count-badge">{{ count($selectedDrops) }}</span>
                        @endif
                    </h3>
                    @if($selectedCustomer && $this->availableDrops->isNotEmpty())
                        <div class="cinv-drops-actions">
                            <button class="cinv-link-btn" wire:click="selectAllDrops">Select all</button>
                            <button class="cinv-link-btn" wire:click="deselectAllDrops">Clear</button>
                        </div>
                    @endif
                </div>

                @if(!$selectedCustomer)
                    <div class="cinv-drops-empty">
                        <i class="fas fa-arrow-left"></i>
                        <p>Select a customer first</p>
                    </div>
                @elseif($this->availableDrops->isEmpty())
                    <div class="cinv-drops-empty">
                        <i class="fas fa-truck"></i>
                        <p>No shipped drops available</p>
                        <small>Only shipped drops can be invoiced</small>
                    </div>
                @else
                    {{-- Search --}}
                    <div class="cinv-drops-search">
                        <i class="fas fa-search"></i>
                        <input type="text" 
                               placeholder="Search drops..."
                               wire:model.live.debounce.300ms="dropSearch">
                    </div>

                    {{-- Drops List --}}
                    <div class="cinv-drops-list">
                        @foreach($this->availableDrops as $drop)
                            @php
                                $isSelected = in_array($drop->id, $selectedDrops);
                                $order = $drop->line?->order;
                                $line = $drop->line;
                            @endphp
                            <div class="cinv-drop-item {{ $isSelected ? 'selected' : '' }}"
                                 wire:click="toggleDrop({{ $drop->id }})"
                                 wire:key="drop-{{ $drop->id }}">
                                <div class="cinv-drop-check">
                                    <input type="checkbox" {{ $isSelected ? 'checked' : '' }}>
                                </div>
                                <div class="cinv-drop-content">
                                    <div class="cinv-drop-main">
                                        <span class="cinv-drop-po">{{ $order?->customer_po ?? 'N/A' }}</span>
                                        <span class="cinv-drop-style">{{ $line?->imported_style_ref ?? 'N/A' }}</span>
                                    </div>
                                    <div class="cinv-drop-sub">
                                        <span>{{ $line?->imported_colour ?? $line?->colourway?->name ?? '—' }}</span>
                                        <span class="cinv-drop-qty">{{ number_format($drop->total_shipped_qty ?: $drop->total_qty) }} pcs</span>
                                        @if($drop->shipped_date)
                                            <span class="cinv-drop-date">{{ $drop->shipped_date->format('d M') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif

                {{-- Summary Footer --}}
                @if(count($selectedDrops) > 0 && $this->currentInvoiceGroup)
                    <div class="cinv-drops-summary">
                        <div class="cinv-summary-item">
                            <span>Total Quantity</span>
                            <strong>{{ number_format($this->currentInvoiceGroup->total_qty ?? 0) }}</strong>
                        </div>
                        <div class="cinv-summary-item total">
                            <span>Total Value</span>
                            <strong>£{{ number_format($this->currentInvoiceGroup->total_value ?? 0, 2) }}</strong>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
