<div class="cdash">
    {{-- Hero Stats Section --}}
    <div class="cdash-hero">
        <div class="cdash-container">
            <div class="cdash-hero-actions">
                <select 
                    id="seasonSelect" 
                    wire:model.live="selectedSeason" 
                    class="cdash-season-select"
                >
                    <option value="">All Seasons</option>
                    @foreach($this->seasons as $season)
                        <option value="{{ $season->id }}">{{ $season->description }}</option>
                    @endforeach
                </select>
                <button type="button" wire:click="$refresh" class="cdash-refresh-btn" title="Refresh data">
                    <i class="fas fa-sync-alt" wire:loading.class="fa-spin" wire:target="$refresh"></i>
                </button>
            </div>
        </div>
    </div>

    <div class="cdash-container">
    {{-- Orders Pipeline --}}
    <div class="cdash-pipeline">
        <div class="cdash-pipeline-header">
            <h3><i class="fas fa-clipboard-list"></i> Orders Pipeline</h3>
        </div>
        <div class="cdash-pipeline-stages">
            <a href="{{ route('commission.orders', ['status' => ['skeleton']]) }}" class="cdash-pipeline-stage">
                <div class="cdash-pipeline-icon cdash-pipeline-imported">
                    <i class="fas fa-file-import"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->orderStats['skeleton']) }}</span>
                    <span class="cdash-pipeline-label">Imported Orders</span>
                </div>
            </a>
            <div class="cdash-pipeline-arrow"><i class="fas fa-chevron-right"></i></div>
            <a href="{{ route('commission.orders', ['status' => ['pending_pd']]) }}" class="cdash-pipeline-stage {{ $this->orderStats['pending_pd'] > 0 ? 'cdash-pipeline-alert' : '' }}">
                <div class="cdash-pipeline-icon cdash-pipeline-pending-pd">
                    <i class="fas fa-pencil-ruler"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->orderStats['pending_pd']) }}</span>
                    <span class="cdash-pipeline-label">Pending PD</span>
                </div>
            </a>
            <div class="cdash-pipeline-arrow"><i class="fas fa-chevron-right"></i></div>
            <a href="{{ route('commission.orders', ['status' => ['pending_merch']]) }}" class="cdash-pipeline-stage {{ $this->orderStats['pending_merch'] > 0 ? 'cdash-pipeline-alert' : '' }}">
                <div class="cdash-pipeline-icon cdash-pipeline-pending-merch">
                    <i class="fas fa-user-check"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->orderStats['pending_merch']) }}</span>
                    <span class="cdash-pipeline-label">Pending Merch</span>
                </div>
            </a>
            <div class="cdash-pipeline-arrow"><i class="fas fa-chevron-right"></i></div>
            <a href="{{ route('commission.orders', ['status' => ['confirmed']]) }}" class="cdash-pipeline-stage">
                <div class="cdash-pipeline-icon cdash-pipeline-confirmed">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->orderStats['confirmed']) }}</span>
                    <span class="cdash-pipeline-label">Active Orders</span>
                </div>
            </a>
        </div>
    </div>

    {{-- Shipment Pipeline --}}
    <div class="cdash-pipeline">
        <div class="cdash-pipeline-header">
            <h3><i class="fas fa-stream"></i> Shipment Pipeline</h3>
        </div>
        <div class="cdash-pipeline-stages">
            <a href="{{ route('commission.shipment-schedule', ['view' => 'unshipped']) }}" class="cdash-pipeline-stage">
                <div class="cdash-pipeline-icon cdash-pipeline-waiting">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->pipelineStats['waiting_to_ship']) }}</span>
                    <span class="cdash-pipeline-label">Waiting to Ship</span>
                </div>
            </a>
            <div class="cdash-pipeline-arrow"><i class="fas fa-chevron-right"></i></div>
            <a href="{{ route('commission.shipment-schedule', ['view' => 'overdue']) }}" class="cdash-pipeline-stage {{ $this->pipelineStats['past_ship_date'] > 0 ? 'cdash-pipeline-alert' : '' }}">
                <div class="cdash-pipeline-icon cdash-pipeline-overdue">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->pipelineStats['past_ship_date']) }}</span>
                    <span class="cdash-pipeline-label">Past Ship Date</span>
                </div>
            </a>
            <div class="cdash-pipeline-arrow"><i class="fas fa-chevron-right"></i></div>
            <a href="{{ route('commission.shipment-schedule', ['view' => 'needsInvoice']) }}" class="cdash-pipeline-stage">
                <div class="cdash-pipeline-icon cdash-pipeline-shipped">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->pipelineStats['shipped_no_invoice']) }}</span>
                    <span class="cdash-pipeline-label">Shipped, No Invoice</span>
                </div>
            </a>
            <div class="cdash-pipeline-arrow"><i class="fas fa-chevron-right"></i></div>
            <a href="{{ route('commission.invoices', ['status' => 'notSentToZoho']) }}" class="cdash-pipeline-stage">
                <div class="cdash-pipeline-icon cdash-pipeline-invoice">
                    <i class="fas fa-file-invoice"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->pipelineStats['in_invoice_not_sent']) }}</span>
                    <span class="cdash-pipeline-label">Invoice Not Sent</span>
                </div>
            </a>
            <div class="cdash-pipeline-arrow"><i class="fas fa-chevron-right"></i></div>
            <a href="{{ route('commission.invoices') }}" class="cdash-pipeline-stage">
                <div class="cdash-pipeline-icon cdash-pipeline-complete">
                    <i class="fas fa-check-double"></i>
                </div>
                <div class="cdash-pipeline-info">
                    <span class="cdash-pipeline-count">{{ number_format($this->shipmentStats['invoiced_drops']) }}</span>
                    <span class="cdash-pipeline-label">Invoiced</span>
                </div>
            </a>
        </div>
    </div>

    {{-- Action Items & Activity --}}
    <div class="cdash-main-grid">
        {{-- Left Column --}}
        <div class="cdash-column">
            {{-- Pending Actions --}}
            @if(count($this->pendingActions) > 0)
            <div class="cdash-card cdash-actions-card">
                <div class="cdash-card-header">
                    <h3><i class="fas fa-bell"></i> Action Required</h3>
                </div>
                <div class="cdash-card-body">
                    <div class="cdash-action-list">
                        @foreach($this->pendingActions as $action)
                        <a href="{{ $action['link'] }}" class="cdash-action-item cdash-action-{{ $action['type'] }}">
                            <div class="cdash-action-icon">
                                <i class="fas {{ $action['icon'] }}"></i>
                            </div>
                            <span class="cdash-action-text">{{ $action['title'] }}</span>
                            <i class="fas fa-chevron-right cdash-action-arrow"></i>
                        </a>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif

            {{-- Top Customers --}}
            <div class="cdash-card">
                <div class="cdash-card-header">
                    <h3><i class="fas fa-trophy"></i> Top Customers (by Value)</h3>
                </div>
                <div class="cdash-card-body">
                    <div class="cdash-customer-list">
                        @forelse($this->topCustomers as $index => $customer)
                        <div class="cdash-customer-item">
                            <div class="cdash-customer-rank">{{ $index + 1 }}</div>
                            <div class="cdash-customer-info">
                                <span class="cdash-customer-name">{{ $customer->name }}</span>
                                <span class="cdash-customer-stats">{{ $customer->order_count }} orders · {{ number_format($customer->total_qty) }} units</span>
                            </div>
                            <div class="cdash-customer-value">
                                ${{ number_format($customer->total_value, 0) }}
                            </div>
                        </div>
                        @empty
                        <div class="cdash-empty">No customer data</div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        {{-- Right Column --}}
        <div class="cdash-column">
            {{-- Units Ordered Chart --}}
            <div class="cdash-card">
                <div class="cdash-card-header">
                    <h3><i class="fas fa-chart-bar"></i> Units Ordered (Last 6 Months)</h3>
                </div>
                <div class="cdash-card-body">
                    <div class="cdash-chart">
                        <div class="cdash-chart-bars">
                            @foreach($this->ordersByMonth as $month)
                            @php
                                $maxVal = max(array_column($this->ordersByMonth, 'qty')) ?: 1;
                                $height = ($month['qty'] / $maxVal) * 100;
                            @endphp
                            <div class="cdash-chart-bar-wrapper">
                                <div class="cdash-chart-bar" style="height: {{ max($height, 5) }}%">
                                    <span class="cdash-chart-value">{{ number_format($month['qty']) }}</span>
                                </div>
                                <span class="cdash-chart-label">{{ $month['label'] }}</span>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            {{-- Shipments Chart --}}
            <div class="cdash-card">
                <div class="cdash-card-header">
                    <h3><i class="fas fa-truck"></i> Units Shipped (Last 6 Months)</h3>
                </div>
                <div class="cdash-card-body">
                    <div class="cdash-chart">
                        <div class="cdash-chart-bars">
                            @foreach($this->shipmentsByMonth as $month)
                            @php
                                $maxVal = max(array_column($this->shipmentsByMonth, 'qty')) ?: 1;
                                $height = ($month['qty'] / $maxVal) * 100;
                            @endphp
                            <div class="cdash-chart-bar-wrapper">
                                <div class="cdash-chart-bar cdash-chart-bar-shipped" style="height: {{ max($height, 5) }}%">
                                    <span class="cdash-chart-value">{{ number_format($month['qty']) }}</span>
                                </div>
                                <span class="cdash-chart-label">{{ $month['label'] }}</span>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            {{-- Upcoming Shipments --}}
            <div class="cdash-card">
                <div class="cdash-card-header">
                    <h3><i class="fas fa-calendar-alt"></i> Upcoming Shipments</h3>
                    <a href="{{ route('commission.shipment-schedule') }}" class="cdash-card-link">View Schedule</a>
                </div>
                <div class="cdash-card-body cdash-card-body-table">
                    <table class="cdash-table">
                        <thead>
                            <tr>
                                <th>Customer</th>
                                <th>Style</th>
                                <th>Ex-Fty</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($this->upcomingShipments as $drop)
                            <tr class="{{ $drop->exfty < now() ? 'cdash-row-overdue' : '' }}">
                                <td>{{ Str::limit($drop->line?->order?->customer?->name ?? '-', 15) }}</td>
                                <td>{{ Str::limit($drop->line?->colourway?->style_versions?->styles?->customer_ref ?? '-', 12) }}</td>
                                <td class="cdash-date {{ $drop->exfty < now() ? 'cdash-overdue' : '' }}">
                                    {{ $drop->exfty?->format('d M') }}
                                    @if($drop->exfty < now())
                                        <i class="fas fa-exclamation-circle"></i>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="3" class="cdash-empty">No upcoming shipments</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    </div>
</div>
