<div class="ccal-page" x-data="{ 
    showFilters: true,
    modalAnimation: false
}">
    {{-- Header - matches orders page style --}}
    <header class="comm-header">
        <div class="comm-header-content">
            {{-- Stats --}}
            <div class="comm-title-section">
                <div class="comm-stats">
                    <span class="comm-stat total">
                        <span class="comm-stat-value">{{ $this->monthStats['total'] }}</span>
                        <span class="comm-stat-label">Drops</span>
                    </span>
                    <span class="comm-stat pending">
                        <span class="comm-stat-value">{{ $this->monthStats['unshipped'] }}</span>
                        <span class="comm-stat-label">Unshipped</span>
                    </span>
                    <span class="comm-stat shipped">
                        <span class="comm-stat-value">{{ $this->monthStats['shipped'] }}</span>
                        <span class="comm-stat-label">Shipped</span>
                    </span>
                    <span class="comm-stat qty">
                        <span class="comm-stat-value">{{ number_format($this->monthStats['totalQty']) }}</span>
                        <span class="comm-stat-label">Units</span>
                    </span>
                </div>
            </div>

            {{-- Month Navigation --}}
            <div class="ccal-month-nav">
                <button class="ccal-nav-btn" wire:click="previousMonth" title="Previous Month">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <span class="ccal-current-month">
                    {{ $this->currentMonth->format('F Y') }}
                </span>
                <button class="ccal-nav-btn" wire:click="nextMonth" title="Next Month">
                    <i class="fas fa-chevron-right"></i>
                </button>
                <button class="ccal-today-btn" wire:click="goToToday">
                    Today
                </button>
            </div>

            {{-- Actions --}}
            <div class="comm-actions">
                <button class="comm-refresh-btn" wire:click="$refresh" title="Refresh">
                    <i class="fas fa-sync-alt"></i>
                </button>
            </div>
        </div>
    </header>

    {{-- Filters Bar - matches orders page style --}}
    <div class="cfilter-bar">
        <div class="cfilter-content">
            {{-- Mobile Toggle --}}
            <button class="cfilter-mobile-toggle" @click="showFilters = !showFilters">
                <i class="fas fa-sliders-h"></i>
                <span>Filters</span>
                @if($this->activeFiltersCount > 0)
                    <span class="cfilter-mobile-count">{{ $this->activeFiltersCount }}</span>
                @endif
            </button>

            {{-- Filters --}}
            <div class="cfilter-items" :class="{ 'show': showFilters }">
                {{-- Status Chips --}}
                <div class="css-view-selector">
                    <button class="css-view-chip {{ $shipped === '' ? 'active' : '' }}" 
                            wire:click="$set('shipped', '')">
                        <i class="fas fa-layer-group"></i>
                        All
                    </button>
                    <button class="css-view-chip {{ $shipped === 'unshipped' ? 'active' : '' }}" 
                            wire:click="$set('shipped', 'unshipped')">
                        <i class="fas fa-box"></i>
                        Unshipped
                    </button>
                    <button class="css-view-chip {{ $shipped === 'shipped' ? 'active' : '' }}" 
                            wire:click="$set('shipped', 'shipped')">
                        <i class="fas fa-check-circle"></i>
                        Shipped
                    </button>
                </div>

                <div class="cfilter-divider"></div>

                {{-- Customer Multi-Select Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ count($customers) > 0 ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-building cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if(count($customers) > 0)
                                {{ count($customers) }} Customer{{ count($customers) > 1 ? 's' : '' }}
                            @else
                                All Customers
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search customers..." x-model="search" x-ref="customerSearch">
                        </div>
                        <div class="cfilter-options">
                            @if(count($customers) > 0)
                                <button class="cfilter-option cfilter-clear-option" 
                                        wire:click="$set('customers', [])">
                                    <i class="fas fa-times-circle"></i>
                                    Clear selection
                                </button>
                            @endif
                            @foreach($this->customerList as $c)
                                <button class="cfilter-option {{ in_array($c->id, $customers) ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($c->name) }}'.includes(search.toLowerCase())"
                                        wire:click="toggleCustomer({{ $c->id }})">
                                    <i class="fas fa-building"></i>
                                    {{ $c->name }}
                                    @if(in_array($c->id, $customers))
                                        <i class="fas fa-check cfilter-check"></i>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Season Multi-Select Dropdown --}}
                <div class="cfilter-dropdown" x-data="{ open: false, search: '' }" @click.away="open = false">
                    <button class="cfilter-dropdown-btn {{ count($seasons) > 0 ? 'has-value' : '' }}" @click="open = !open">
                        <i class="fas fa-calendar-check cfilter-icon"></i>
                        <span class="cfilter-label">
                            @if(count($seasons) > 0)
                                {{ count($seasons) }} Season{{ count($seasons) > 1 ? 's' : '' }}
                            @else
                                All Seasons
                            @endif
                        </span>
                        <i class="fas fa-chevron-down cfilter-chevron" :class="{ 'rotate': open }"></i>
                    </button>
                    <div class="cfilter-dropdown-menu cfilter-dropdown-searchable" x-show="open" x-cloak
                         x-transition:enter="transition ease-out duration-150"
                         x-transition:enter-start="opacity-0 transform -translate-y-2"
                         x-transition:enter-end="opacity-100 transform translate-y-0"
                         x-transition:leave="transition ease-in duration-100"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0"
                         @click.stop>
                        <div class="cfilter-search">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="Search seasons..." x-model="search">
                        </div>
                        <div class="cfilter-options">
                            @if(count($seasons) > 0)
                                <button class="cfilter-option cfilter-clear-option" 
                                        wire:click="$set('seasons', [])">
                                    <i class="fas fa-times-circle"></i>
                                    Clear selection
                                </button>
                            @endif
                            @foreach($this->seasonList as $s)
                                <button class="cfilter-option {{ in_array($s->id, $seasons) ? 'selected' : '' }}" 
                                        x-show="!search || '{{ strtolower($s->description) }}'.includes(search.toLowerCase())"
                                        wire:click="toggleSeason({{ $s->id }})">
                                    <i class="fas fa-tag"></i>
                                    {{ $s->description }}
                                    @if(in_array($s->id, $seasons))
                                        <i class="fas fa-check cfilter-check"></i>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            {{-- Active Filters Count & Clear --}}
            @if($this->activeFiltersCount > 0)
                <div class="cfilter-active">
                    <span class="cfilter-active-count">
                        <i class="fas fa-filter"></i>
                        {{ $this->activeFiltersCount }} active
                    </span>
                    <button class="cfilter-clear" wire:click="clearFilters">
                        <i class="fas fa-times"></i>
                        Clear all
                    </button>
                </div>
            @endif
        </div>
    </div>

    {{-- Calendar Grid --}}
    <div class="ccal-container">
        {{-- Weekday Headers --}}
        <div class="ccal-weekdays">
            @foreach(['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'] as $day)
                <div class="ccal-weekday">{{ $day }}</div>
            @endforeach
        </div>

        {{-- Calendar Days --}}
        <div class="ccal-grid">
            @foreach($this->calendarDays as $day)
                @php
                    $dayDrops = $this->dropsByDate->get($day['date'], collect());
                    $hasDrops = $dayDrops->count() > 0;
                    $shippedCount = $dayDrops->where('shipped', true)->count();
                    $unshippedCount = $dayDrops->where('shipped', false)->count();
                    $overdueCount = $dayDrops->filter(fn($d) => !$d->shipped && $d->exfty < now()->startOfDay())->count();
                @endphp
                <div 
                    class="ccal-day {{ !$day['isCurrentMonth'] ? 'other-month' : '' }} {{ $day['isToday'] ? 'today' : '' }} {{ $day['isWeekend'] ? 'weekend' : '' }} {{ $hasDrops ? 'has-events' : '' }}"
                    @if($hasDrops)
                        wire:click="openDayModal('{{ $day['date'] }}')"
                        style="cursor: pointer;"
                    @endif
                >
                    <div class="ccal-day-header">
                        <span class="ccal-day-number">{{ $day['day'] }}</span>
                        @if($hasDrops)
                            <span class="ccal-day-count">{{ $dayDrops->count() }}</span>
                        @endif
                    </div>
                    
                    @if($hasDrops)
                        <div class="ccal-day-events">
                            @foreach($dayDrops->take(3) as $drop)
                                @php
                                    $statusClass = $this->getDropStatusClass($drop);
                                    $styleRef = $drop->line?->colourway?->style_versions?->styles?->customer_ref ?? $drop->line?->imported_style_ref ?? 'Unknown';
                                    $customer = $drop->line?->order?->customer?->name ?? 'Unknown';
                                @endphp
                                <div class="ccal-event {{ $statusClass }}">
                                    <span class="ccal-event-style">{{ Str::limit($styleRef, 12) }}</span>
                                    <span class="ccal-event-customer">{{ Str::limit($customer, 10) }}</span>
                                </div>
                            @endforeach
                            @if($dayDrops->count() > 3)
                                <div class="ccal-event-more">
                                    +{{ $dayDrops->count() - 3 }} more
                                </div>
                            @endif
                        </div>

                        {{-- Status indicators --}}
                        <div class="ccal-day-status">
                            @if($overdueCount > 0)
                                <span class="ccal-status-dot overdue" title="{{ $overdueCount }} overdue"></span>
                            @endif
                            @if($unshippedCount > 0 && $overdueCount !== $unshippedCount)
                                <span class="ccal-status-dot pending" title="{{ $unshippedCount - $overdueCount }} pending"></span>
                            @endif
                            @if($shippedCount > 0)
                                <span class="ccal-status-dot shipped" title="{{ $shippedCount }} shipped"></span>
                            @endif
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>

    {{-- Quick Month/Year Jump --}}
    <div class="ccal-month-jump">
        <div class="ccal-year-nav">
            <button class="ccal-year-btn" wire:click="goToMonth({{ $year - 1 }}, {{ $month }})" title="Previous Year">
                <i class="fas fa-chevron-left"></i>
            </button>
            <span class="ccal-year-label">{{ $year }}</span>
            <button class="ccal-year-btn" wire:click="goToMonth({{ $year + 1 }}, {{ $month }})" title="Next Year">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
        <div class="ccal-months-row">
            @for($m = 1; $m <= 12; $m++)
                <button 
                    class="ccal-month-btn {{ $m === $month ? 'active' : '' }}"
                    wire:click="goToMonth({{ $year }}, {{ $m }})"
                >
                    {{ Carbon\Carbon::create(null, $m, 1)->format('M') }}
                </button>
            @endfor
        </div>
    </div>

    {{-- Day Detail Modal --}}
    @if($showDayModal && $selectedDate)
        <div 
            class="ccal-modal-backdrop" 
            wire:click="closeDayModal"
            x-data
            x-init="$nextTick(() => modalAnimation = true)"
            x-show="modalAnimation"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div 
                class="ccal-modal" 
                wire:click.stop
                x-show="modalAnimation"
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100"
            >
                <div class="ccal-modal-header">
                    <h3 class="ccal-modal-title">
                        <i class="fas fa-calendar-day"></i>
                        {{ Carbon\Carbon::parse($selectedDate)->format('l, F j, Y') }}
                    </h3>
                    <button class="ccal-modal-close" wire:click="closeDayModal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>

                <div class="ccal-modal-body">
                    @if($this->selectedDateDrops->count() > 0)
                        <div class="ccal-drops-list">
                            @foreach($this->selectedDateDrops as $drop)
                                @php
                                    $statusClass = $this->getDropStatusClass($drop);
                                    $styleRef = $drop->line?->colourway?->style_versions?->styles?->customer_ref ?? $drop->line?->imported_style_ref ?? 'Unknown';
                                    $styleName = $drop->line?->colourway?->style_versions?->styles?->designs?->description ?? $drop->line?->imported_style_description ?? '';
                                    $colourway = $drop->line?->colourway?->name ?? $drop->line?->imported_colour ?? '';
                                    $customer = $drop->line?->order?->customer?->name ?? 'Unknown';
                                    $customerPo = $drop->line?->order?->customer_po ?? '';
                                    $season = $drop->line?->order?->season?->description ?? '';
                                    $totalQty = $drop->sizes->sum('qty');
                                    $shippedQty = $drop->sizes->sum('shipped_qty') ?: 0;
                                    $thumbUrl = $drop->line?->colourway?->img_thumb ? asset('storage/' . $drop->line->colourway->img_thumb) : null;
                                @endphp
                                <div class="ccal-drop-card {{ $statusClass }}">
                                    <div class="ccal-drop-thumb">
                                        @if($thumbUrl)
                                            <img src="{{ $thumbUrl }}" alt="{{ $styleRef }}" loading="lazy">
                                        @else
                                            <div class="ccal-drop-thumb-placeholder">
                                                <i class="fas fa-tshirt"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="ccal-drop-info">
                                        <div class="ccal-drop-title">
                                            <span class="ccal-drop-ref">{{ $styleRef }}</span>
                                            @if($colourway)
                                                <span class="ccal-drop-colour">{{ $colourway }}</span>
                                            @endif
                                        </div>
                                        @if($styleName)
                                            <div class="ccal-drop-name">{{ $styleName }}</div>
                                        @endif
                                        <div class="ccal-drop-meta">
                                            <span class="ccal-drop-customer">
                                                <i class="fas fa-building"></i> {{ $customer }}
                                            </span>
                                            @if($customerPo)
                                                <span class="ccal-drop-po">
                                                    <i class="fas fa-file-alt"></i> {{ $customerPo }}
                                                </span>
                                            @endif
                                            @if($season)
                                                <span class="ccal-drop-season">
                                                    <i class="fas fa-leaf"></i> {{ $season }}
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="ccal-drop-qty">
                                        <div class="ccal-drop-qty-main">
                                            {{ number_format($totalQty) }}
                                        </div>
                                        <div class="ccal-drop-qty-label">units</div>
                                        @if($drop->shipped)
                                            <span class="ccal-drop-badge shipped">
                                                <i class="fas fa-check"></i> Shipped
                                            </span>
                                        @elseif($drop->exfty < now()->startOfDay())
                                            <span class="ccal-drop-badge overdue">
                                                <i class="fas fa-exclamation-triangle"></i> Overdue
                                            </span>
                                        @else
                                            <span class="ccal-drop-badge pending">
                                                <i class="fas fa-clock"></i> Pending
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="ccal-empty">
                            <i class="fas fa-calendar-times"></i>
                            <p>No drops scheduled for this day</p>
                        </div>
                    @endif
                </div>

                <div class="ccal-modal-footer">
                    <span class="ccal-modal-summary">
                        {{ $this->selectedDateDrops->count() }} drop(s) · 
                        {{ number_format($this->selectedDateDrops->sum(fn($d) => $d->sizes->sum('qty'))) }} units
                    </span>
                    <a 
                        href="{{ route('commission.shipment-schedule', ['fromDate' => $selectedDate, 'toDate' => $selectedDate]) }}" 
                        class="ccal-btn ccal-btn-primary"
                    >
                        <i class="fas fa-external-link-alt"></i>
                        View in Schedule
                    </a>
                </div>
            </div>
        </div>
    @endif

    {{-- Loading Overlay --}}
    <div wire:loading.delay class="ccal-loading">
        <div class="ccal-loading-spinner"></div>
    </div>
</div>

