<div class="commission-batch-import">
    <x-commission.page-header 
        title="Import Orders"
        :stats="[]"
        :showSearch="false"
    >
        <x-slot name="actions">
            <a href="{{ route('commission.orders') }}" class="comm-create-btn">
                <i class="fas fa-list"></i>
                <span>View Orders</span>
            </a>
        </x-slot>
    </x-commission.page-header>

    <div class="cbi-content">
        <div class="cbi-grid">
            {{-- Upload Form --}}
            <div class="cbi-upload-card">
                <div class="cbi-card-header">
                    <h3><i class="fas fa-file-import"></i> New Batch Import</h3>
                </div>
                
                <form wire:submit="startImport" class="cbi-form">
                    {{-- Batch Name --}}
                    <div class="cbi-field">
                        <label class="cbi-label">Batch Name <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control @error('batchName') is-invalid @enderror" 
                               wire:model="batchName"
                               placeholder="e.g., Mr Porter SS25 Order 1">
                        @error('batchName')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Customer --}}
                    <div class="cbi-field">
                        <label class="cbi-label">Customer <span class="text-danger">*</span></label>
                        <select class="form-select @error('customerId') is-invalid @enderror" 
                                wire:model.live="customerId">
                            <option value="">Select Customer</option>
                            @foreach($this->customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                            @endforeach
                        </select>
                        @error('customerId')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        
                        @if($this->selectedCustomer && $this->selectedCustomer->commission_gemini_instructions)
                            <div class="cbi-custom-prompt-notice">
                                <i class="fas fa-robot"></i> Custom instructions will be added to extraction
                            </div>
                        @endif
                    </div>

                    {{-- Season --}}
                    <div class="cbi-field">
                        <label class="cbi-label">Season <span class="text-danger">*</span></label>
                        <select class="form-select @error('seasonId') is-invalid @enderror" 
                                wire:model="seasonId">
                            <option value="">Select Season</option>
                            @foreach($this->seasons as $season)
                                <option value="{{ $season->id }}">{{ $season->description }}</option>
                            @endforeach
                        </select>
                        @error('seasonId')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- File Upload --}}
                    <div class="cbi-field">
                        <label class="cbi-label">Files <span class="text-danger">*</span></label>
                        <div class="cbi-dropzone" 
                             x-data="{ isDragging: false }"
                             @dragover.prevent="isDragging = true"
                             @dragleave.prevent="isDragging = false"
                             @drop.prevent="isDragging = false; $refs.fileInput.files = $event.dataTransfer.files; $refs.fileInput.dispatchEvent(new Event('change'))"
                             :class="{ 'dragging': isDragging }">
                            
                            <input type="file" 
                                   x-ref="fileInput"
                                   wire:model="files" 
                                   multiple 
                                   accept=".pdf,.xlsx,.xls,.csv"
                                   class="cbi-file-input">
                            
                            <div class="cbi-dropzone-content">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <p>Drag & drop files here or click to browse</p>
                                <span class="cbi-dropzone-hint">PDF, Excel, or CSV files (max 20MB each)</span>
                            </div>
                        </div>
                        @error('files')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                        @error('files.*')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- File List --}}
                    @if(count($files) > 0)
                        <div class="cbi-file-list">
                            @foreach($files as $index => $file)
                                <div class="cbi-file-item" wire:key="file-{{ $index }}">
                                    <div class="cbi-file-info">
                                        <i class="fas fa-file-{{ Str::endsWith($file->getClientOriginalName(), '.pdf') ? 'pdf' : 'excel' }}"></i>
                                        <span>{{ $file->getClientOriginalName() }}</span>
                                        <span class="cbi-file-size">{{ number_format($file->getSize() / 1024, 1) }} KB</span>
                                    </div>
                                    <button type="button" class="cbi-file-remove" wire:click="removeFile({{ $index }})">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Submit --}}
                    <div class="cbi-actions">
                        <button type="submit" 
                                class="cbi-submit-btn"
                                wire:loading.attr="disabled"
                                {{ $isUploading ? 'disabled' : '' }}>
                            <span wire:loading.remove wire:target="startImport">
                                <i class="fas fa-upload"></i> Start Import
                            </span>
                            <span wire:loading wire:target="startImport">
                                <i class="fas fa-spinner fa-spin"></i> Uploading...
                            </span>
                        </button>
                    </div>

                    {{-- Processing Notice --}}
                    <div class="cbi-notice">
                        <i class="fas fa-info-circle"></i>
                        <div>
                            <strong>Processing runs in background</strong>
                            <p>Files are processed using AI. You'll receive an email when complete.</p>
                        </div>
                    </div>
                </form>
            </div>

            {{-- Recent Batches --}}
            <div class="cbi-recent-card">
                <div class="cbi-card-header">
                    <h3><i class="fas fa-history"></i> Recent Imports</h3>
                    @if($this->isAdmin)
                        <label class="cbi-toggle-label">
                            <input type="checkbox" wire:model.live="showAllBatches" class="cbi-toggle-input">
                            <span class="cbi-toggle-switch"></span>
                            <span class="cbi-toggle-text">Show All</span>
                        </label>
                    @endif
                </div>
                
                @if($this->recentBatches->isEmpty())
                    <div class="cbi-empty">
                        <i class="fas fa-inbox"></i>
                        <p>No recent imports</p>
                    </div>
                @else
                    <div class="cbi-batch-list">
                        @foreach($this->recentBatches as $batch)
                            <div class="cbi-batch-item">
                                <div class="cbi-batch-main">
                                    <span class="cbi-batch-name">{{ $batch->batch_name }}</span>
                                    <span class="cbi-batch-customer">{{ $batch->customer_name }}</span>
                                    @if($showAllBatches && $this->isAdmin)
                                        <span class="cbi-batch-user"><i class="fas fa-user"></i> {{ $batch->user?->name ?? 'Unknown' }}</span>
                                    @endif
                                </div>
                                <div class="cbi-batch-meta">
                                    <span class="cbi-batch-status cbi-status-{{ $batch->status }}">
                                        @if($batch->status === 'pending')
                                            <i class="fas fa-clock"></i>
                                        @elseif($batch->status === 'processing')
                                            <i class="fas fa-spinner fa-spin"></i>
                                        @elseif($batch->status === 'completed')
                                            <i class="fas fa-check"></i>
                                        @elseif($batch->status === 'completed_with_warnings')
                                            <i class="fas fa-exclamation-triangle"></i>
                                        @elseif($batch->status === 'failed')
                                            <i class="fas fa-times-circle"></i>
                                        @endif
                                        {{ ucfirst(str_replace('_', ' ', $batch->status)) }}
                                    </span>
                                    <span class="cbi-batch-date">{{ $batch->created_at->diffForHumans() }}</span>
                                </div>
                                <div class="cbi-batch-stats">
                                    <span title="Files"><i class="fas fa-file"></i> {{ $batch->processed_files ?? 0 }}/{{ $batch->total_files }}</span>
                                    @if($batch->failed_files > 0)
                                        <span class="text-danger" title="Failed files"><i class="fas fa-times-circle"></i> {{ $batch->failed_files }}</span>
                                    @endif
                                </div>
                                <div class="cbi-batch-actions">
                                    @if($batch->commission_orders_count > 0)
                                        <span class="badge bg-success me-1" title="{{ $batch->commission_orders_count }} order(s) created">
                                            {{ $batch->commission_orders_count }} {{ Str::plural('PO', $batch->commission_orders_count) }}
                                        </span>
                                    @endif
                                    <button type="button" class="cbi-action-btn" wire:click="openDetails({{ $batch->id }})" title="View Details">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    @if($batch->commissionOrder || $batch->commission_orders_count > 0)
                                        <button type="button" class="cbi-action-btn cbi-action-success" wire:click="viewBatch({{ $batch->id }})" title="View Orders">
                                            <i class="fas fa-external-link-alt"></i>
                                        </button>
                                    @endif
                                    <button type="button" class="cbi-action-btn cbi-action-danger" wire:click="deleteBatch({{ $batch->id }})" wire:confirm="Delete this batch and all related orders?" title="Delete Batch">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- Backdrop for Side Panel --}}
    @if($showDetailModal)
        <div class="cse-backdrop" wire:click="closeDetails"></div>
    @endif

    {{-- Detail Side Panel --}}
    <div class="cse-panel {{ $showDetailModal ? 'open' : '' }}" x-data @keydown.escape.window="$wire.closeDetails()">
    @if($showDetailModal && $this->detailBatch)
            @php
                $batchHasApprovedOrders = $this->detailBatch->commissionOrders()->where('status', 'confirmed')->exists();
            @endphp
            {{-- Header --}}
            <header class="cse-header">
                <div class="cse-header-info">
                    <span class="cse-badge"><i class="fas fa-file-import"></i></span>
                    <h2 class="cse-title">{{ $this->detailBatch->batch_name }}</h2>
                </div>
                <button class="cse-close" wire:click="closeDetails">
                    <i class="fas fa-times"></i>
                </button>
            </header>

            {{-- Content --}}
            <div class="cse-content">
                    {{-- Batch Info --}}
                <div class="cse-section">
                        <div class="cbi-detail-grid">
                            <div class="cbi-detail-item">
                                <span class="cbi-detail-label">Customer</span>
                                <span class="cbi-detail-value">{{ $this->detailBatch->customer_name }}</span>
                            </div>
                            <div class="cbi-detail-item">
                                <span class="cbi-detail-label">Season</span>
                                <span class="cbi-detail-value">{{ $this->detailBatch->season?->description ?? 'N/A' }}</span>
                            </div>
                            <div class="cbi-detail-item">
                                <span class="cbi-detail-label">Uploaded By</span>
                                <span class="cbi-detail-value">{{ $this->detailBatch->user?->name ?? 'Unknown' }}</span>
                            </div>
                            <div class="cbi-detail-item">
                                <span class="cbi-detail-label">Uploaded</span>
                                <span class="cbi-detail-value">{{ $this->detailBatch->created_at->format('d M Y H:i') }}</span>
                            </div>
                            <div class="cbi-detail-item">
                                <span class="cbi-detail-label">Status</span>
                                <span class="cbi-detail-value">
                                    <span class="cbi-batch-status cbi-status-{{ $this->detailBatch->status }}">
                                        @if($this->detailBatch->status === 'completed_with_warnings')
                                            <i class="fas fa-exclamation-triangle"></i>
                                        @endif
                                        {{ ucfirst(str_replace('_', ' ', $this->detailBatch->status)) }}
                                    </span>
                                </span>
                            </div>
                            <div class="cbi-detail-item">
                                <span class="cbi-detail-label">Progress</span>
                                <span class="cbi-detail-value">
                                    {{ $this->detailBatch->processed_files ?? 0 }} / {{ $this->detailBatch->total_files }} files
                                    @if($this->detailBatch->failed_files > 0)
                                        <span class="text-danger small ms-1">({{ $this->detailBatch->failed_files }} failed)</span>
                                    @endif
                                </span>
                            </div>
                        </div>

                        @if($this->detailBatch->error_message)
                        <div class="cbi-error-box mt-3">
                                <i class="fas fa-exclamation-circle"></i>
                                <div>
                                    <strong>Error</strong>
                                <p class="mb-0">{{ $this->detailBatch->error_message }}</p>
                                </div>
                            </div>
                        @endif
                    </div>

                    {{-- Files --}}
                <div class="cse-section">
                    <h4 class="cse-section-title"><i class="fas fa-files"></i> Files</h4>
                        <div class="cbi-files-table">
                            @foreach($this->detailBatch->files as $file)
                                <div class="cbi-file-row cbi-file-{{ $file->status }}">
                                    <div class="cbi-file-icon">
                                        @if(Str::endsWith($file->original_filename, '.pdf'))
                                            <i class="fas fa-file-pdf"></i>
                                        @else
                                            <i class="fas fa-file-excel"></i>
                                        @endif
                                    </div>
                                    <div class="cbi-file-details">
                                        <span class="cbi-file-name">{{ $file->original_filename }}</span>
                                        <span class="cbi-file-status">
                                            @if($file->status === 'pending')
                                                <i class="fas fa-clock text-muted"></i> Pending
                                            @elseif($file->status === 'processing')
                                                <i class="fas fa-spinner fa-spin text-primary"></i> Processing
                                            @elseif($file->status === 'extracted')
                                                <i class="fas fa-check text-info"></i> Extracted
                                            @elseif($file->status === 'matched')
                                                <i class="fas fa-check text-success"></i> Matched
                                            @elseif($file->status === 'verified')
                                                <i class="fas fa-check-double text-success"></i> Verified
                                            @elseif($file->status === 'completed')
                                                <i class="fas fa-check-circle text-success"></i> Completed
                                            @elseif($file->status === 'failed')
                                                <i class="fas fa-times-circle text-danger"></i> Failed
                                            @endif
                                        </span>
                                    </div>
                                    <div class="cbi-file-actions">
                                        @if(!in_array($file->status, ['pending', 'processing']) && !$batchHasApprovedOrders)
                                            <button type="button" class="cbi-action-btn cbi-action-warning" wire:click="retryFile({{ $file->id }})" title="Retry this file">
                                                <i class="fas fa-redo"></i>
                                            </button>
                                        @endif
                                    </div>
                                </div>
                                @if($file->error_message)
                                    <div class="cbi-file-error">
                                        <i class="fas fa-exclamation-triangle"></i>
                                        {{ $file->error_message }}
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>

                    {{-- AI Processing Results --}}
                    @if($this->detailBatch->extraction_result || $this->detailBatch->matching_result || $this->detailBatch->verification_result)
                    <div class="cse-section">
                        <h4 class="cse-section-title"><i class="fas fa-robot"></i> AI Processing</h4>
                            <div class="cbi-agent-results">
                                @if($this->detailBatch->extraction_result)
                                    <div class="cbi-agent-result">
                                        <span class="cbi-agent-label">Extraction</span>
                                        <span class="cbi-agent-status cbi-status-{{ $this->detailBatch->extraction_result['status'] ?? 'pending' }}">
                                            {{ ucfirst($this->detailBatch->extraction_result['status'] ?? 'Pending') }}
                                        </span>
                                        @if(isset($this->detailBatch->extraction_result['orders_found']))
                                            <span class="cbi-agent-detail">{{ $this->detailBatch->extraction_result['orders_found'] }} orders found</span>
                                        @endif
                                    </div>
                                @endif
                                @if($this->detailBatch->matching_result)
                                    <div class="cbi-agent-result">
                                        <span class="cbi-agent-label">Matching</span>
                                        <span class="cbi-agent-status cbi-status-{{ $this->detailBatch->matching_result['status'] ?? 'pending' }}">
                                            {{ ucfirst($this->detailBatch->matching_result['status'] ?? 'Pending') }}
                                        </span>
                                        @if(isset($this->detailBatch->matching_result['matched_lines']))
                                            <span class="cbi-agent-detail">{{ $this->detailBatch->matching_result['matched_lines'] }}/{{ $this->detailBatch->matching_result['total_lines'] ?? '?' }} matched</span>
                                        @endif
                                    </div>
                                @endif
                                @if($this->detailBatch->verification_result)
                                    <div class="cbi-agent-result">
                                        <span class="cbi-agent-label">Verification</span>
                                        <span class="cbi-agent-status cbi-status-{{ $this->detailBatch->verification_result['status'] ?? 'pending' }}">
                                            {{ ucfirst($this->detailBatch->verification_result['status'] ?? 'Pending') }}
                                        </span>
                                        @if(isset($this->detailBatch->verification_result['confidence']))
                                            <span class="cbi-agent-detail">{{ $this->detailBatch->verification_result['confidence'] }}% confidence</span>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                    {{-- Created Orders --}}
                    @if($this->detailBatch->commissionOrders->count() > 0)
                    <div class="cse-section">
                        <h4 class="cse-section-title"><i class="fas fa-shopping-cart"></i> Created Orders ({{ $this->detailBatch->commissionOrders->count() }})</h4>
                        <div class="cbi-orders-list">
                            @foreach($this->detailBatch->commissionOrders as $order)
                                <div class="cbi-order-item">
                                    <div class="cbi-order-info">
                                        <span class="cbi-order-po">{{ $order->customer_po }}</span>
                                        <span class="cbi-order-id">#{{ $order->id }}</span>
                                    </div>
                                    <span class="cbi-batch-status cbi-status-{{ $order->status }}">
                                        {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                                    </span>
                                    <span class="cbi-order-lines">{{ $order->lines->count() }} lines</span>
                                    <a href="{{ route('commission.orders', ['order' => $order->id]) }}" class="cse-btn cse-btn-sm cse-btn-primary">
                                        <i class="fas fa-external-link-alt"></i>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        </div>
                    @elseif($this->detailBatch->commissionOrder)
                        {{-- Fallback for legacy single order link --}}
                    <div class="cse-section">
                        <h4 class="cse-section-title"><i class="fas fa-shopping-cart"></i> Created Order</h4>
                        <div class="cbi-order-item">
                            <div class="cbi-order-info">
                                <span class="cbi-order-po">Order #{{ $this->detailBatch->commissionOrder->id }}</span>
                            </div>
                                <span class="cbi-batch-status cbi-status-{{ $this->detailBatch->commissionOrder->status }}">
                                    {{ ucfirst(str_replace('_', ' ', $this->detailBatch->commissionOrder->status)) }}
                                </span>
                            <span class="cbi-order-lines">{{ $this->detailBatch->commissionOrder->lines->count() }} lines</span>
                            <button type="button" class="cse-btn cse-btn-sm cse-btn-primary" wire:click="viewBatch({{ $this->detailBatch->id }})">
                                <i class="fas fa-external-link-alt"></i>
                                </button>
                            </div>
                        </div>
                    @endif
                </div>

            {{-- Footer --}}
            <footer class="cse-footer">
                <button class="cse-btn cse-btn-secondary" wire:click="closeDetails">
                    Close
                </button>
                <div class="cse-footer-actions">
                    @if(in_array($this->detailBatch->status, ['failed', 'completed', 'completed_with_warnings']) && !$batchHasApprovedOrders)
                        <button class="cse-btn cse-btn-warning" wire:click="retryBatch({{ $this->detailBatch->id }})">
                            <i class="fas fa-redo"></i> Retry {{ $this->detailBatch->status === 'completed_with_warnings' ? 'Failed' : 'All' }}
                        </button>
                    @endif
                    <button class="cse-btn cse-btn-danger" wire:click="deleteBatch({{ $this->detailBatch->id }})" wire:confirm="Are you sure you want to delete this batch?">
                        <i class="fas fa-trash"></i> Delete
                    </button>
                </div>
            </footer>
        @endif
        </div>
</div>

