<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Yarn
        </x-slot:title>
        <x-slot:end>
            @if(Gate::check('design:create') || Gate::check('style:create'))
                <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'new'})" wire:click="$dispatch('new-yarn')">New</button>
            @endif
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr>
                            <th>ID</th>
                            <th>Spinner</th>
                            <th>Description</th>
                            <th>Count</th>
                            <th>Materials</th>
                            {{-- <th>Colours</th> --}}
                            <th style="width:150px"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($yarns as $yarn)
                            <tr>
                                <td>{{ $yarn->id }}</td>
                                <td>{{ $yarn->suppliers->name }}</td>
                                <td>{{ $yarn->description }}</td>
                                <td>{{ $yarn->counts->count }}</td>
                                <td>
                                    @foreach($yarn->yarn_compositions as $material)
                                        {{$material->percentage}}% {{$material->materials->material}},
                                    @endforeach
                                </td>
                                {{-- <td>
                                    @foreach($yarn->yarn_colours as $colour)
                                        {{$colour->reference}} {{$colour->description}}<br>
                                    @endforeach
                                </td> --}}
                                <td>
                                    @can('style:update')
                                        <button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-yarn', { yarn: {{$yarn->id}}})">Edit</button>
                                        <button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'colours'})" wire:click="$dispatch('edit-yarn-colours', { yarn: {{$yarn->id}}})">Colours</button>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <x-modal name="edit" title="Edit yarn" size="modal-sm">
            <x-slot:body>
                <livewire:admin.yarn.yarn-edit wire:key="editYarn">
            </x-slot:body>
        </x-modal>

        <x-modal name="colours" title="Edit Colours" size="modal-sm">
            <x-slot:body>
                <livewire:admin.yarn.yarn-colours wire:key="editColours">
            </x-slot:body>
        </x-modal>


        <x-modal name="new" title="New yarn" size="modal-sm">
            <x-slot:body>
                <livewire:admin.yarn.yarn-edit wire:key="new">
            </x-slot:body>
        </x-modal>
    </div>

    <x-footer>
        <x-slot:center>
            {{ $yarns->links() }}
        </x-slot:center>
    </x-footer>
</div>
