<div>
	<div class="modal-body">
		@if (Session::get('message'))
		<div class="alert {{ Session::get('alert-class') }}" role="alert">
			<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
				{{ $error }}<br>
				@endforeach
			</div>
			@endif

			<form wire:submit="save">
				<div class="row">
					<div class="col">
						@if($yarn || $new)
                        <div class="row">
							<div class="col-lg">
								<div class="row align-items-center">
									<div class="col-5">
										<h6 class="mb-0 fw-bold">Spinner</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('style:update')
											<select class="form-select" wire:model="form.suppliers_id">
												<option value=""></option>
												@foreach($this->suppliers as $supplier)
													<option value="{{$supplier->id}}">{{$supplier->name}}</option>
												@endforeach
											</select>
                                        @else
                                            {{$form->suppliers->name ?? ""}}
                                        @endcan
                                    </div>
								</div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">Description</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('style:update')
                                            <input type="text" class="form-control" wire:model="form.description">
                                        @else
                                            {{$form->description ?? ""}}
                                        @endcan
                                    </div>
								</div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">Count</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('style:update')
											<select class="form-select" wire:model="form.counts_id">
												<option value=""></option>
												@foreach($this->counts as $count)
													<option value="{{$count->id}}">{{$count->count}}</option>
												@endforeach
											</select>
                                        @else
                                            {{$form->counts->count ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
						<hr>
						<div class="row">
							<div class="col"><h6 class="mb-0 fw-bold">Composition</h6></div>
						</div>
						@foreach($form->materials ?? [] as $m=>$material)
							<div class="row mt-3">
								<div class="col-6"><input type="number" class="form-control" placeholder="%" wire:model="form.materials.{{$m}}.percentage"></div>
								<div class="col-6">
									<select class="form-select" wire:model="form.materials.{{$m}}.materials_id">
										<option value=""></option>
										@foreach($this->materials as $material)
											<option value="{{$material->id}}">{{$material->material}}</option>
										@endforeach
									</select>
								</div>
							</div>
						@endforeach
                    @endif
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>
		<button class="btn btn-primary" wire:click="addComp">Add Material</button>
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
	</div>
</div>
