<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
			<div class="row">
				<div class="col">
                    @if($yarn)
						@foreach($form->colours as $c=>$colour)
							<div class="row mt-3">
								<div class="col-lg">
									<div class="row align-items-center">
										<div class="col">
											@can('style:update')
												<input type="text" class="form-control" wire:model="form.colours.{{$c}}.reference">
												{{$colour->reference ?? ""}}
											@else
											@endcan
										</div>
										<div class="col">
											@can('style:update')
												<input type="text" class="form-control" wire:model="form.colours.{{$c}}.description">
												{{$colour->description ?? ""}}
											@else
											@endcan
										</div>
									</div>
								</div>
							</div>
						@endforeach
                    @endif
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>
		<button class="btn btn-primary" wire:click="addColour">Add Colour</button>
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
	</div>
</div>
