<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
			<div class="row">
				<div class="col">
                    @if($supplier || $new)
                        <hr>
                        <h5>Supplier Details</h5>
                        <hr>
                        <div class="row ms-5">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Name</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('supplier:update')
                                            <input type="text" class="form-control" wire:model="form.name">
                                        @else
                                            {{$form->name ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Country</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('supplier:update')
                                            <select class="form-select" wire:model="form.countries_id">
                                                <option value=""></option>
                                                @foreach($this->countries as $country)
                                                    <option value="{{$country->id}}">{{$country->country}}</option>
                                                @endforeach
                                            </select>
                                        @else
                                            {{$form->countries->country ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Type</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('supplier:update')
                                            <select class="form-select" wire:model="form.type">
                                                <option value=""></option>
                                                <option value="yarn">Yarn</option>
                                                <option value="fabric">Fabric</option>
                                                <option value="factory">Factory</option>
                                                <option value="accessory">Accessory</option>
                                                <option value="transporter">Transporter</option>
                                            </select>
                                        @else
                                            {{Str::title($form->type) }}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">MID</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('supplier:update')
                                            <input type="text" class="form-control" wire:model="form.mid">
                                        @else
                                            {{$form->mid ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h5>Primary Contact</h5>
                        <hr>
                        <div class="row ms-5">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Name</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('supplier:update')
                                            <input type="text" class="form-control" wire:model="form.contact">
                                        @else
                                            {{$form->contact ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Phone</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('supplier:update')
                                            <input type="text" class="form-control" wire:model="form.phone">
                                        @else
                                            {{$form->phone ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Email</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('supplier:update')
                                            <input type="text" class="form-control" wire:model="form.email">
                                        @else
                                            {{$form->email ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h5>Finanace Details</h5>
                        <hr>
                        <div class="row ms-5">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Contact Name</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('finance:update') || $new)
                                            <input type="text" class="form-control" wire:model="form.finance_contact">
                                        @else
                                            {{$form->finance_contact ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Phone</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('finance:update') || $new)
                                            <input type="text" class="form-control" wire:model="form.finance_phone">
                                        @else
                                            {{$form->finance_phone ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Email</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('finance:update') || $new)
                                            <input type="text" class="form-control" wire:model="form.finance_email">
                                        @else
                                            {{$form->finance_email ?? ""}}
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Payment Terms</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('finance:update') || $new)
                                            <input type="text" class="form-control" wire:model="form.payment_terms">
                                        @else
                                            {{$form->payment_terms ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Currency</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            NOTE THAT THIS WILL INVALIDATE PRICE YarnCostKg CACHE
                                            <select class="form-control" wire:model="form.currency">
                                                <option value=""></option>
                                                <option value="£">£</option>
                                                <option value="€">€</option>
                                                <option value="$">$</option>
                                            </select>
                                        @else
                                            {{$form->currency ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Customs Charge (Factory Only)</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="checkbox" class="form-check-input" wire:model="form.customs">
                                        @else
                                            {{$form->customs ? "Yes" : "No"}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h5>Addresses</h5>
                        <hr>
                        <div class="row ms-5">
                            @foreach($form->addresses as $a=>$address)
                            <div class="col-6" style="min-width:400px">
                                    <div class="card mb-3">
                                        <div class="card-header">{{$address['name']}}</div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Name of Address</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.name">
                                                    @else
                                                        {{$form->addresses[$a]['name']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Line 1</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.line1">
                                                    @else
                                                        {{$form->addresses[$a]['line1']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Line 2</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.line2">
                                                    @else
                                                        {{$form->addresses[$a]['line2']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Line 3</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.line3">
                                                    @else
                                                        {{$form->addresses[$a]['line3']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">City</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.city">
                                                    @else
                                                        {{$form->addresses[$a]['city']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Region</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.region">
                                                    @else
                                                        {{$form->addresses[$a]['region']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Postcode</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.postcode">
                                                    @else
                                                        {{$form->addresses[$a]['postcode']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Country</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('supplier:update')
                                                        <select class="form-select"wire:model.lazy="form.addresses.{{$a}}.countries_id">
                                                        <option disabled="" selected="" value="">Choose...</option>
                                                        @foreach($this->countries as $country)
                                                            <option value="{{$country->id}}">{{$country->country}}</option>
                                                        @endforeach
                                                    </select>
                                                    @else
                                                        {{$form->addresses[$a]['countries_id']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="d-grid gap-2">
                                                @can('supplier:update')
                                                    <button class="btn btn-danger" wire:click.prevent="deleteAddress({{$a}})">Delete Address</button>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>
		<button class="btn btn-primary" wire:click="newAddress">Add Address</button>
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
	</div>
</div>
