<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Sizes
        </x-slot:title>
        <x-slot:end>
            @if(Gate::check('design:create') || Gate::check('style:create'))
                <button class="btn btn-primary" x-data x-on:click="$dispatch('open-modal', {name:'new'})" wire:click="$dispatch('new-size')">New</button>
            @endif
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                    <tr>
                        <th>ID</th>
                        <th>Order</th>
                        <th>Name</th>
                        <th style="width:0px"></th>
                    </tr>
                    </thead>
                    <tbody id="size-list"> @foreach($sizes as $size)
                        <tr data-id="{{ $size->id }}">
                            <td>{{ $size->id }}</td>
                            <td>{{ $size->order }}</td>
                            <td>{{ $size->name }}</td>
                            <td>
                                <div class="btn-group">

                                    @can('order:update')
                                        <button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-size', { size: {{$size->id}}})">Edit</button>
                                    @endcan
                                    @can('admin')
                                        <button class="btn btn-danger" wire:click="delete({{$size->id}})">X</button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <x-modal name="edit" title="Edit size" size="modal-sm">
            <x-slot:body>
                <livewire:admin.sizes.size-edit wire:key="edit">
            </x-slot:body>
        </x-modal>


        <x-modal name="new" title="New size" size="modal-sm">
            <x-slot:body>
                <livewire:admin.sizes.size-edit wire:key="new">
            </x-slot:body>
        </x-modal>
    </div>
{{--
    <x-footer>
        <x-slot:center>
            {{ $sizes->links() }}
        </x-slot:center>
    </x-footer> --}}

    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <script>
        new Sortable(document.getElementById('size-list'), {
            animation: 150, // Animation during drag
            onEnd: function (evt) {
                let newOrder = Array.from(evt.to.children)
                    .map(item => item.dataset.id)
                    .join(',');
                // Send the new order to Livewire
                @this.call('reorderSizes', newOrder);
            }
        });
    </script>
</div>
