<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
			<div class="row">
				<div class="col">
                    @if($season || $new)
                        <div class="row">
                            <div class="col-lg">
                                <div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">Season</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="text" class="form-control" wire:model="form.description">
                                        @else
                                            {{$form->name ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">Start</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="date" class="form-control" wire:model="form.start_date">
                                        @else
                                            {{$form->start_date ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">End</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="date" class="form-control" wire:model="form.end_date">
                                        @else
                                            {{$form->end_date ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">Euro Rate</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="text" class="form-control" wire:model="form.euro_rate">
                                        @else
                                            {{$form->euro_rate ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">USD Rate</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="text" class="form-control" wire:model="form.usd_rate">
                                        @else
                                            {{$form->usd_rate ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">GBP Rate (1)</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="text" class="form-control" wire:model="form.gbp_rate">
                                        @else
                                            {{$form->gbp_rate ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">Markup</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="text" class="form-control" wire:model="form.markup">
                                        @else
                                            {{$form->markup ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">Locked</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="checkbox" class="form-check-input" wire:model="form.locked">
                                        @else
                                            {{$form->locked ? "Y" : "N"}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
								<div class="row align-items-center">
									<div class="col-5">
                                        <h6 class="mb-0 fw-bold">No. Days Yarn Interest</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('season:update')
                                            <input type="number" class="form-control" wire:model="form.no_days_yarn_interest" min="1" max="3650">
                                        @else
                                            {{$form->no_days_yarn_interest ?? "365"}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
	</div>
</div>
