<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
			<div class="row">
				<div class="col">
                    @if($sampleType || $new)
                        <div class="row">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Season</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('sample-type:update')
                                            <input type="text" class="form-control" wire:model="form.name">
                                        @else
                                            {{$form->name ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Charge</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('sample-type:update')
                                            <input type="checkbox" class="form-check-input" wire:model="form.charge">
                                        @else
                                            {{$form->charge ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Charge Proto</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('sample-type:update')
											<input type="checkbox" class="form-check-input" wire:model="form.charge_proto">
                                        @else
                                            {{$form->charge_proto ?? ""}}
                                        @endcan
                                    </div>
                                </div>
								<hr>
								<div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Surcharge</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('sample-type:update')
											<input type="checkbox" class="form-check-input" wire:model="form.charge_surcharge">
                                        @else
                                            {{$form->charge_surcharge ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>			
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>			
	</div>
</div>
