<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Invoice Layouts
        </x-slot:title>
        <x-slot:end>
            @can('finance:update')
                <button class="btn btn-light" wire:click="new">New</button>
            @endcan
        </x-slot:end>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                        @foreach($layouts as $l=>$layout)
                            <div class="p-3 row">
                                <div class="col">
                                    @can('finance:update')
                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3">ID</label>
                                            <div class="col-sm-9">
                                                {{ $layout['id'] }}
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="invoice_name_{{$l}}">Name</label>
                                            <div class="col-sm-9">
                                                <input id="invoice_name_{{$l}}" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.name">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="invoice_per_{{$l}}">Invoice Per</label>
                                            <div class="col-sm-9">
                                                <select id="invoice_per_{{$l}}" class="form-select" wire:model.live="layouts.{{$l}}.invoice_by">
                                                    <option value="">Select...</option>
                                                    <option value="allinone">All In One</option>
                                                    <option value="order">Order</option>
                                                    <option value="style">Style</option>
                                                    <option value="factory">Factory</option>
                                                    <option value="drop">Drop (colourway)</option>
                                                </select>
                                            </div>
                                        </div>


                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="invoice_comments_{{$l}}">Comments</label>
                                            <div class="col-sm-9">
                                                <textarea id="invoice_comments_{{$l}}" rows="10" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.invoice_comments"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="line_title_{{$l}}">Item Title</label>
                                            <div class="col-sm-9">
                                                <textarea id="line_title_{{$l}}" rows="2" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.line_title"></textarea>
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="line_description_{{$l}}">Item Description</label>
                                            <div class="col-sm-9">
                                                <textarea id="line_description_{{$l}}" rows="2" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.line_description"></textarea>
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="line_qty_{{$l}}">Item Qty</label>
                                            <div class="col-sm-9">
                                                <input id="line_qty_{{$l}}" type="text" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.line_qty">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="line_price_{{$l}}">Item Price</label>
                                            <div class="col-sm-9">
                                                <input id="line_price_{{$l}}" type="text" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.line_price">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="line_vat_{{$l}}">Item VAT</label>
                                            <div class="col-sm-9">
                                                <input id="line_vat_{{$l}}" type="checkbox" class="form-check-input" wire:model.live.debounce.500="layouts.{{$l}}.line_vat">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="invoice_layout_{{$l}}">Layout</label>
                                            <div class="col-sm-9">
                                                <input id="invoice_layout_{{$l}}" type="text" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.invoice_layout">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="invoice_account_{{$l}}">Zoho Account</label>
                                            <div class="col-sm-9">
                                                <input id="invoice_account_{{$l}}" type="text" class="form-control" wire:model.live.debounce.500="layouts.{{$l}}.zoho_account">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="default_{{$l}}">Default</label>
                                            <div class="col-sm-9">
                                                <input id="default_{{$l}}" type="checkbox" class="form-check-input" wire:model.live.debounce.500="layouts.{{$l}}.default">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="per_size_{{$l}}">Per Size</label>
                                            <div class="col-sm-9">
                                                <input id="per_size_{{$l}}" type="checkbox" class="form-check-input" wire:model.live.debounce.500="layouts.{{$l}}.per_size">
                                            </div>
                                        </div>

                                        <div class="form-group row mb-2">
                                            <label class="col-sm-3" for="separate_invoice_per_collection_date_{{$l}}">Separate Invoice Per Collection Date</label>
                                            <div class="col-sm-9">
                                                <input id="separate_invoice_per_collection_date_{{$l}}" type="checkbox" class="form-check-input" wire:model.live.debounce.500="layouts.{{$l}}.separate_invoice_per_collection_date">
                                            </div>
                                        </div>


                                    @else
                                        <td>{{ $layout['id'] }}</td>
                                        <td>{{ $layout['name'] }}</td>
                                        <td>{{ $layout['invoice_by'] }}</td>
                                        <td>{{ $layout['invoice_comments'] }}</td>
                                        <td>{{ $layout['line_title'] }}</td>
                                        <td>{{ $layout['line_description'] }}</td>
                                        <td>{{ $layout['line_qty'] }}</td>
                                        <td>{{ $layout['line_price'] }}</td>
                                        <td>{{ $layout['line_vat'] }}</td>
                                        <td>{{ $layout['invoice_layout'] }}</td>
                                        <td>{{ $layout['default'] ? 'Y' : 'N' }}</td>
                                    @endcan
                                </div>
                            </div>
                            <hr>
                        @endforeach
                    </tbody>
            </div>
        </div>
    </div>

    <x-footer>
        <x-slot:start>
            <b>Invoice Fields</b><br>

        </x-slot:start>
        <x-slot:center>
            {{-- {{ $layouts->links() }} --}}
        </x-slot:center>
        <x-slot:end>
            <b>Line Fields</b><br>
            line_customer_ref,
            line_sku,
            line_size,
            line_description,
            line_style_version,
            line_colourway,
            line_qty,
            line_price,
            line_vat,
            line_gross_weight,
            line_net_weight,
            line_no_cartons,
            line_shipment_mode
        </x-slot:end>
    </x-footer>
</div>
