<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
			<div class="row">
				<div class="col">
                    @if($gauge || $new)
                        <div class="row">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col">
                                        @can('gauge:update')
                                            <input type="text" class="form-control" wire:model="form.gauge">
                                        @else
                                            {{$form->gauge ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>			
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>			
	</div>
</div>
