<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Departments
        </x-slot:title>
        <x-slot:end>
            @can('design:create')
                <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'new'})" wire:click="$dispatch('new-department')">New</button>
            @endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Hidden</th>
                            <th style="width:0px"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($departments as $department)
                            <tr>
                                <td>{{ $department->id }}</td>
                                <td>{{ $department->description }}</td>
                                <td>{{Str::title($department->type ?? "")}}</td>
                                <td>@if($department->hidden) Yes @else No @endif</td>
                                <td>
                                    @can('department:update')
                                        <button class="btn btn-text" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-department', { department: {{$department->id}}})">Edit</button>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <x-modal name="edit" title="Edit department" size="modal-sm">
            <x-slot:body>
                <livewire:admin.departments.department-edit wire:key="edit">
            </x-slot:body>
        </x-modal>


        <x-modal name="new" title="New department" size="modal-sm">
            <x-slot:body>
                <livewire:admin.departments.department-edit wire:key="new">
            </x-slot:body>
        </x-modal>
    </div>

    <x-footer>
        <x-slot:center>
            {{ $departments->links() }}
        </x-slot:center>
    </x-footer>
</div>
