<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
			<div class="row">
				<div class="col">
                    @if($department || $new)
                        <div class="row">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col">
                                        @can('department:update')
                                            <input type="text" class="form-control" wire:model="form.description">
                                        @else
                                            {{$form->description ?? ""}}
                                        @endcan
                                    </div>
                                </div>

                                <div class="row align-items-center mt-3">
                                    <div class="col">
                                        @can('department:update')
                                            <select class="form-select" wire:model="form.type">
                                                <option value="wholesale">Wholesale</option>
                                                <option value="commission">Commission</option>
                                            </select>
                                        @else
                                            {{Str::title($form->type ?? "")}}
                                        @endcan
                                    </div>
                                </div>
                                <div class="row align-items-center mt-3">
                                    <div class="col">
                                        @can('department:update')
                                            <select class="form-select" wire:model="form.hidden">
                                                <option value="0">Active</option>
                                                <option value="1">Hidden</option>
                                            </select>
                                        @else
                                            @if($form->hidden) Yes @else No @endif
                                        @endcan
                                    </div>
                                </div>
                                <div class="row align-items-center">
                                    <div class="col">
                                        Zoho Name
                                        @can('department:update')
                                            <input type="text" class="form-control" wire:model="form.zoho_name">
                                        @else
                                            {{$form->zoho_name ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
	</div>
</div>
