<div>
    @if($isOpen)
    <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5);">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="bi bi-person-plus me-2"></i>New Customer
                    </h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="close"></button>
                </div>
                <form wire:submit="save">
                    <div class="modal-body">
                        {{-- Validation Errors --}}
                        @if($errors->any())
                            <div class="alert alert-danger py-2 mb-3">
                                <ul class="mb-0 small">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="row">
                            {{-- Left Column: Customer Details --}}
                            <div class="col-md-6">
                                <h6 class="text-muted text-uppercase small fw-bold mb-3">Customer Details</h6>
                                
                                {{-- Name --}}
                                <div class="form-floating mb-3">
                                    <input type="text" 
                                           class="form-control @error('name') is-invalid @enderror" 
                                           id="name" 
                                           wire:model="name" 
                                           placeholder="Customer Name"
                                           autofocus>
                                    <label for="name">Customer Name *</label>
                                    @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Country --}}
                                <div class="form-floating mb-3">
                                    <select class="form-select @error('countries_id') is-invalid @enderror" 
                                            id="countries_id" 
                                            wire:model="countries_id">
                                        <option value="">Select country...</option>
                                        @foreach($this->countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->country }}</option>
                                        @endforeach
                                    </select>
                                    <label for="countries_id">Country *</label>
                                    @error('countries_id')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Currency --}}
                                <div class="mb-3">
                                    <label class="form-label small text-muted">Currency *</label>
                                    <div class="btn-group w-100" role="group">
                                        <button type="button" 
                                                class="btn {{ $currency === '£' ? 'btn-primary' : 'btn-outline-primary' }}"
                                                wire:click="setCurrency('£')">
                                            £ GBP
                                        </button>
                                        <button type="button" 
                                                class="btn {{ $currency === '€' ? 'btn-primary' : 'btn-outline-primary' }}"
                                                wire:click="setCurrency('€')">
                                            € EUR
                                        </button>
                                        <button type="button" 
                                                class="btn {{ $currency === '$' ? 'btn-primary' : 'btn-outline-primary' }}"
                                                wire:click="setCurrency('$')">
                                            $ USD
                                        </button>
                                    </div>
                                </div>

                                {{-- VAT --}}
                                <div class="form-floating mb-3">
                                    <input type="text" 
                                           class="form-control @error('vat') is-invalid @enderror" 
                                           id="vat" 
                                           wire:model="vat" 
                                           placeholder="VAT Number"
                                           style="text-transform: uppercase;">
                                    <label for="vat">VAT Number *</label>
                                    @error('vat')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Finance Email --}}
                                <div class="form-floating mb-3">
                                    <input type="email" 
                                           class="form-control @error('finance_email') is-invalid @enderror" 
                                           id="finance_email" 
                                           wire:model="finance_email" 
                                           placeholder="finance@example.com">
                                    <label for="finance_email">Finance Email *</label>
                                    @error('finance_email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Finance Phone --}}
                                <div class="form-floating mb-3">
                                    <input type="tel" 
                                           class="form-control @error('phone') is-invalid @enderror" 
                                           id="phone" 
                                           wire:model="phone" 
                                           placeholder="+44 20 1234 5678">
                                    <label for="phone">Finance Phone *</label>
                                    @error('phone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Payment Terms --}}
                                <div class="form-floating mb-3">
                                    <input type="number" 
                                           class="form-control @error('payment_terms') is-invalid @enderror" 
                                           id="payment_terms" 
                                           wire:model="payment_terms" 
                                           min="0" 
                                           max="365"
                                           placeholder="30">
                                    <label for="payment_terms">Payment Terms (days) *</label>
                                    @error('payment_terms')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>

                            {{-- Right Column: Address --}}
                            <div class="col-md-6">
                                <h6 class="text-muted text-uppercase small fw-bold mb-3">Finance Address</h6>
                                
                                {{-- Address Name --}}
                                <div class="form-floating mb-3">
                                    <input type="text" 
                                           class="form-control @error('address_name') is-invalid @enderror" 
                                           id="address_name" 
                                           wire:model="address_name" 
                                           placeholder="Head Office">
                                    <label for="address_name">Address Name *</label>
                                    @error('address_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Address Line 1 --}}
                                <div class="form-floating mb-3">
                                    <input type="text" 
                                           class="form-control @error('address_line1') is-invalid @enderror" 
                                           id="address_line1" 
                                           wire:model="address_line1" 
                                           placeholder="123 Main Street">
                                    <label for="address_line1">Address Line 1</label>
                                    @error('address_line1')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- City --}}
                                <div class="form-floating mb-3">
                                    <input type="text" 
                                           class="form-control @error('address_city') is-invalid @enderror" 
                                           id="address_city" 
                                           wire:model="address_city" 
                                           placeholder="London">
                                    <label for="address_city">City</label>
                                    @error('address_city')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Postcode --}}
                                <div class="form-floating mb-3">
                                    <input type="text" 
                                           class="form-control @error('address_postcode') is-invalid @enderror" 
                                           id="address_postcode" 
                                           wire:model="address_postcode" 
                                           placeholder="SW1A 1AA">
                                    <label for="address_postcode">Postcode</label>
                                    @error('address_postcode')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Address Country --}}
                                <div class="form-floating mb-3">
                                    <select class="form-select @error('address_countries_id') is-invalid @enderror" 
                                            id="address_countries_id" 
                                            wire:model="address_countries_id">
                                        <option value="">Select country...</option>
                                        @foreach($this->countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->country }}</option>
                                        @endforeach
                                    </select>
                                    <label for="address_countries_id">Country *</label>
                                    @error('address_countries_id')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                                {{-- Copy from Customer Country --}}
                                @if($countries_id)
                                <div class="mb-3">
                                    <button type="button" 
                                            class="btn btn-outline-secondary btn-sm"
                                            wire:click="$set('address_countries_id', {{ $countries_id }})">
                                        <i class="bi bi-arrow-left me-1"></i>Same as customer country
                                    </button>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="close">
                            Cancel
                        </button>
                        <button type="submit" class="btn btn-success" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="save">
                                <i class="bi bi-check-lg me-1"></i>Create Customer
                            </span>
                            <span wire:loading wire:target="save">
                                <span class="spinner-border spinner-border-sm me-1" role="status"></span>
                                Creating...
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>





