<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Customers
        </x-slot:title>
        <x-slot:end>
            @if(Gate::allows('style:update') || Gate::allows('order:update') || Gate::allows('finance:update'))
                <button class="btn btn-success me-2" wire:click="$dispatch('open-new-customer-quick')">
                    <i class="bi bi-plus-lg me-1"></i>New Customer
                </button>
            @endif
            @can('customer:create')
                <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'new'})" wire:click="$dispatch('new-customer')">Full Form</button>
            @endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Country</th>
                            <th>Currency</th>
                            <th>Payment Terms</th>
                            <th>Factored</th>
                            <th style="width:0px"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($customers as $customer)
                            <tr>
                                <td>{{ $customer->id }}</td>
                                <td>{{ $customer->name }}</td>
                                <td>{{ Str::upper($customer->countries->code) }}</td>
                                <td>{{ $customer->currency }}</td>
                                <td>
                                    @foreach($customer->customer_payment_terms as $term)
                                        <span class="badge bg-secondary">{{ $term->percentage }}% @ {{ $term->days }}d</span>
                                    @endforeach
                                </td>
                                <td>
                                    @can('finance:update')
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               {{ $customer->factored ? 'checked' : '' }}
                                               wire:click="updateFactored({{ $customer->id }})">
                                    @else
                                        <span class="badge {{ $customer->factored ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $customer->factored ? 'Yes' : 'No' }}
                                        </span>
                                    @endcan
                                </td>
                                <td>
                                    @can('customer:update')
                                        <button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-customer', { customer: {{$customer->id}}})">Edit</button>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <x-modal name="edit" title="Edit Customer">
            <x-slot:body>
                <livewire:admin.customers.customer-edit wire:key="edit">
            </x-slot:body>
        </x-modal>


        <x-modal name="new" title="New Customer">
            <x-slot:body>
                <livewire:admin.customers.customer-edit wire:key="new">
            </x-slot:body>
        </x-modal>

        {{-- Quick New Customer Form --}}
        <livewire:admin.customers.new-customer />
    </div>

    {{-- Auto-open customer edit modal if ID provided via route --}}
    @if($openCustomerId)
    <script>
        document.addEventListener('livewire:initialized', function() {
            // Dispatch events to open the edit modal for the specified customer
            Livewire.dispatch('edit-customer', { customer: {{ $openCustomerId }} });
            Livewire.dispatch('open-modal', { name: 'edit' });
        });
    </script>
    @endif

    <x-footer>
        <x-slot:center>
            {{ $customers->links() }}
        </x-slot:center>
    </x-footer>
</div>
