<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
            <div class="row">
                <div class="col">
                    @if($customer || $new)
                        <hr>
                        <h5>Customer Details</h5>
                        <hr>
                        <div class="row ms-5">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Name</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <input type="text" class="form-control" wire:model="form.name">
                                        @else
                                            {{$form->name ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Country</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <select class="form-select" wire:model="form.countries_id">
                                                <option value=""></option>
                                                @foreach($this->countries as $country)
                                                    <option value="{{$country->id}}">{{$country->country}}</option>
                                                @endforeach
                                            </select>
                                        @else
                                            {{$form->countries->country ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Show MID on Quotes</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <input type="checkbox" class="form-check-input" wire:model="form.show_mid">
                                        @else
                                            {{$form->show_mid ? "Yes" : "No"}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Logo</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <input type="file" class="form-control" wire:model="form.newLogo">
                                        @else

                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Notes</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <textarea rows="4" class="form-control" wire:model="form.notes"></textarea>
                                        @else
                                            {{$form->notes ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h5>Primary Contact</h5>
                        <hr>
                        <div class="row ms-5">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Name</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <input type="text" class="form-control" wire:model="form.contact">
                                        @else
                                            {{$form->contact ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Phone</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <input type="text" class="form-control" wire:model="form.phone">
                                        @else
                                            {{$form->phone ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Email</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <input type="text" class="form-control" wire:model="form.email">
                                        @else
                                            {{$form->email ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h5>Finanace Details</h5>
                        <hr>
                        <div class="row ms-5">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Contact Name</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="text" class="form-control" wire:model="form.finance_contact">
                                        @else
                                            {{$form->finance_contact ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Phone</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="text" class="form-control" wire:model="form.finance_phone">
                                        @else
                                            {{$form->finance_phone ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Email</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="text" class="form-control" wire:model="form.finance_email">
                                        @else
                                            {{$form->finance_email ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">VAT Number</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="text" class="form-control" wire:model="form.vat">
                                        @else
                                            {{$form->vat ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">EORI</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <input type="text" class="form-control" wire:model="form.eori">
                                        @else
                                            {{$form->eori ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Payment Terms</h6>
                                    </div>
                                    <div class="col-7">
                                        <div class="row mb-2">
                                            <div class="col">
                                                Days
                                            </div>
                                            <div class="col">
                                                %
                                            </div>
                                            <div class="col">
                                            </div>
                                        </div>
                                        @foreach($form->customer_payment_terms as $index => $term)
                                            <div class="row mb-2">
                                                <div class="col">
                                                    <input type="number" class="form-control" placeholder="Days" wire:model="form.customer_payment_terms.{{ $index }}.days">
                                                </div>
                                                <div class="col">
                                                    <input type="number" class="form-control" placeholder="Percentage" wire:model="form.customer_payment_terms.{{ $index }}.percentage">
                                                </div>
                                                <div class="col-auto">
                                                    <button type="button" class="btn btn-danger" wire:click="removePaymentTerm({{ $index }})">Remove</button>
                                                </div>
                                            </div>
                                        @endforeach
                                        <button type="button" class="btn btn-primary mt-2" wire:click="addPaymentTerm">Add Payment Term</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Default Commission</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="email" class="form-control" wire:model="form.default_commission">
                                        @else
                                            {{$form->default_commission ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Default Discount</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="email" class="form-control" wire:model="form.default_discount">
                                        @else
                                            {{$form->default_discount ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Currency</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('customer:update')
                                            <select class="form-control" wire:model="form.currency">
                                                <option value=""></option>
                                                <option value="£">£</option>
                                                <option value="€">€</option>
                                                <option value="$">$</option>
                                            </select>
                                        @else
                                            {{$form->currency ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Notify on New Order</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <input type="email" class="form-control" wire:model="form.notifyNewOrder">
                                        @else
                                            {{$form->notifyNewOrder ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Factored</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::Check('finance:update') || $new)
                                            <input type="checkbox" class="form-check-input" wire:model="form.factored">
                                            {{$form->factored ?? ""}}
                                        @else
                                            {{$form->factored ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Charge Customs</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::Check('finance:update') || $new)
                                            <input type="checkbox" class="form-check-input" wire:model="form.customs">
                                        @else
                                            {{$form->customs ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Notes</h6>
                                    </div>
                                    <div class="col-7">
                                        @can('finance:update')
                                            <textarea rows="5" class="form-control" wire:model="form.finance_notes"></textarea>
                                        @else
                                            {{$form->finance_notes ?? ""}}
                                        @endcan
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <h5>Addresses</h5>
                        <hr>
                        <div class="row ms-5">
                            @foreach($form->addresses ?? [] as $a=>$address)
                                <div class="col-6" style="min-width:400px">
                                    <div class="card mb-3" wire:key="address-{{$a}}">
                                        <div class="card-header">{{$address['name']}}</div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Name of Address</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <input type="text" class="form-control  " wire:model.lazy="form.addresses.{{$a}}.name">
                                                    @else
                                                        {{$form->addresses[$a]['name']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Line 1</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.line1">
                                                    @else
                                                        {{$form->addresses[$a]['line1']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Line 2</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.line2">
                                                    @else
                                                        {{$form->addresses[$a]['line2']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Line 3</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.line3">
                                                    @else
                                                        {{$form->addresses[$a]['line3']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">City</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.city">
                                                    @else
                                                        {{$form->addresses[$a]['city']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Region</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.region">
                                                    @else
                                                        {{$form->addresses[$a]['region']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Postcode</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <input type="text" class="form-control  "wire:model.lazy="form.addresses.{{$a}}.postcode">
                                                    @else
                                                        {{$form->addresses[$a]['postcode']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <h6 class="mb-0 fw-bold">Country</h6>
                                                </div>
                                                <div class="col-sm-8">
                                                    @can('customer:update')
                                                        <select class="form-select"wire:model.lazy="form.addresses.{{$a}}.countries_id">
                                                        <option disabled="" selected="" value="">Choose...</option>
                                                        @foreach($this->countries as $country)
                                                            <option value="{{$country->id}}">{{$country->country}}</option>
                                                        @endforeach
                                                    </select>
                                                    @else
                                                        {{$form->addresses[$a]['countries_id']}}
                                                    @endif
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="d-grid gap-2">
                                                @can('customer:update')
                                                    <button class="btn btn-danger" wire:click.prevent="deleteAddress({{$a}})">Delete Address</button>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <hr>
                        <h5>Sample Rules</h5>
                        <hr>
                        <div class="row ms-5">
                            <div class="col-lg">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Sample Type</th>
                                            <th>Required</th>
                                            <th>Required if Carryover</th>
                                            <th>Discount</th>
                                            <th>Surcharge</th>
                                            <th>Development Fee</th>
                                            <th>Freight</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($this->sampleTypes as $type)
                                            <tr>
                                                <td>{{$type->name}}</td>
                                                <td>
                                                    @can('style:update')
                                                        <input type="checkbox" class="form-check-input" wire:model.live="form.samples_required.{{$type->id}}">
                                                    @else
                                                        {{$form->samples_required[$type->id] ?? NULL ? "Yes" : "No"}}
                                                    @endcan

                                                </td>
                                                <td>
                                                    @can('style:update')
                                                        <input type="checkbox" class="form-check-input" wire:model.live="form.carryoverSamples.{{$type->id}}">
                                                    @else
                                                        {{$form->carryoverSamples[$type->id] ?? NULL ? "Yes" : "No"}}
                                                    @endcan

                                                </td>
                                                <td>
                                                    @can('finance:update')
                                                        <input type="numeric" class="form-control" wire:model.live="form.sampleCharge.{{$type->id}}.discount">
                                                    @else
                                                        {{$form->sampleCharge[$type->id]['discount'] ?? ""}}
                                                    @endcan
                                                </td>
                                                <td>
                                                    @can('finance:update')
                                                        <input type="numeric" class="form-control" wire:model.lazy="form.sampleCharge.{{$type->id}}.surcharge">
                                                    @else
                                                        {{$form->sampleCharge[$type->id]['surcharge'] ?? ""}}
                                                    @endcan
                                                </td>
                                                <td>
                                                    @can('finance:update')
                                                        <input type="numeric" class="form-control" wire:model.lazy="form.sampleCharge.{{$type->id}}.development">
                                                    @else
                                                        {{$form->sampleCharge[$type->id]['development'] ?? ""}}
                                                    @endcan
                                                </td>
                                                <td>
                                                    @can('finance:update')
                                                        <input type="checkbox" class="form-check-input" wire:model.lazy="form.sampleCharge.{{$type->id}}.freight">
                                                    @else
                                                        {{$form->sampleCharge[$type->id]['freight'] ?? "" ? "Yes" : "No"}}
                                                    @endcan
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <h5>Size Defaults</h5>
                        <hr>
                        <div class="row ms-5">
                            @foreach($form->sizeDefaults as $s=>$size)
                                <div class="col-sm">
                                    <select class="form-select" wire:model.live="form.sizeDefaults.{{$s}}">
                                        <option value="">Size</option>
                                        @foreach($this->sizes as $size)
                                            <option value="{{$size->id}}">{{$size->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endforeach
                        </div>
                        <div class="row">
                            <div class="col mt-3 text-end">
                                <button class="btn btn-primary" wire:click.prevent="newSize">Add</button>
                            </div>
                        </div>
                        @can('finance:update')
                            <h5>Invoice Layout</h5>
                            <hr>
                            <div class="row ms-5">
                                <div class="input-group">
                                    <span class="form-control">EXW</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.EXW">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">FCA</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.FCA">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">CPT</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.CPT">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">CIP</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.CIP">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">DAP</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.DAP">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">DPU</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.DPU">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">DDP</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.DDP">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">FAS</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.FAS">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">FOB</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.FOB">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">CFR</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.CFR">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="form-control">CIF</span>
                                    <select class="form-select" wire:model="form.customerInvoiceLayouts.CIF">
                                        <option value=""></option>
                                        @foreach($this->invoiceLayouts as $layout)
                                            <option value="{{$layout->id}}">{{$layout->id}} {{$layout->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col">
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Zoho Name</h6>
                                        </div>
                                        <div class="col-7">
                                            @can('customer:update')
                                                <input type="text" class="form-control" wire:model="form.zoho_customer">
                                            @else
                                                {{$form->zoho_customer ?? ""}}
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Zoho Reporting Tag Name</h6>
                                        </div>
                                        <div class="col-7">
                                            @can('customer:update')
                                                <input type="text" class="form-control" wire:model="form.zoho_customer_tag">
                                            @else
                                                {{$form->zoho_customer_tag ?? ""}}
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="row align-items-center">
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Zoho Factoring Tag</h6>
                                        </div>
                                        <div class="col-7">
                                            @can('customer:update')
                                                <input type="text" class="form-control" wire:model="form.zoho_factored">
                                            @else
                                                {{$form->zoho_factored ?? ""}}
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endcan
                    @endif
                </div>
            </div>
            
            <!-- Commission Import AI Instructions -->
            <div class="row">
                <div class="col">
                    <hr>
                    <h5><i class="fas fa-robot me-2"></i>Commission Import AI Instructions</h5>
                    <hr>
                    <div class="row ms-5">
                        <div class="col-12">
                            <div class="row align-items-start">
                                <div class="col-3">
                                    <h6 class="mb-0 fw-bold">Customer-Specific Instructions</h6>
                                    <small class="text-muted">These instructions are <strong>added to</strong> the default extraction prompt</small>
                                </div>
                                <div class="col-9">
                                    @can('customer:update')
                                        <textarea 
                                            class="form-control" 
                                            wire:model="form.commission_gemini_instructions" 
                                            rows="8" 
                                            placeholder="Add customer-specific extraction rules here. Examples:&#10;&#10;• Use the invoice number at the top of the file as the PO number&#10;• Ignore line-by-line invoice numbers with 0X suffix&#10;• Style codes are in the format ABC-123&#10;• Combine lines with the same style but different drops"
                                        ></textarea>
                                        <div class="alert alert-info mt-2 py-2">
                                            <i class="fas fa-info-circle me-1"></i>
                                            <strong>How it works:</strong> The default extraction prompt is always used first. 
                                            Any instructions you add here will be appended as customer-specific rules at the end.
                                            Leave empty if no special handling is needed.
                                        </div>
                                    @else
                                        <div class="form-control" style="min-height: 100px; white-space: pre-wrap;">{{$form->commission_gemini_instructions ?? "No custom instructions - using default prompt only"}}</div>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		</form>
	</div>
	<div class="modal-footer">
		<div class="d-flex w-100 justify-content-between align-items-center">
			<div>
				@if($zohoMessage)
					<div class="alert alert-{{ $zohoMessageType }} py-1 px-2 mb-0 me-2 d-inline-block" style="font-size: 0.85rem;">
						{{ $zohoMessage }}
					</div>
				@endif
			</div>
			<div class="d-flex gap-2 flex-wrap">
				@can('finance:update')
					@if(!$zohoConnected)
						<button class="btn btn-warning" wire:click="initiateZohoOAuth" title="Connect to Zoho Books to enable sending customers">
							<i class="fas fa-link me-1"></i>Connect Zoho
						</button>
					@endif
					<button 
						type="button"
						class="btn btn-success"
						x-data="{}"
						@click="
							console.log('ZOHO button clicked');
							console.log('Component:', $wire);
							$wire.saveAndSendToZoho().then(() => {
								console.log('Method called successfully');
							}).catch(e => {
								console.error('Error:', e);
								alert('Error: ' + e.message);
							});
						"
						title="Send to Zoho Books"
					>
						<i class="fas fa-cloud-upload-alt me-1"></i>
						ZOHO
					</button>
				@endcan
				<button class="btn btn-primary" wire:click="save">Save</button>
				<button class="btn btn-secondary" wire:click="newAddress">Add Address</button>
				<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
			</div>
		</div>
	</div>

{{-- Zoho Organization Selection Modal --}}
@if($showOrgSelection)
<template x-teleport="body">
	<div 
		x-data
		x-init="document.body.style.overflow = 'hidden'"
		@keydown.escape.window="$wire.closeOrgSelection(); document.body.style.overflow = 'auto'"
		class="modal fade show d-block" 
		tabindex="-1" 
		style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 99999; background: rgba(0,0,0,0.6); display: flex; align-items: center; justify-content: center;"
	>
		<div class="modal-dialog" style="margin: auto; max-width: 500px;" @click.stop>
		<div class="modal-content">
			<div class="modal-header bg-info text-white">
				<h5 class="modal-title">
					<i class="fas fa-building me-2"></i>Select Zoho Organization(s)
				</h5>
				<button type="button" class="btn-close btn-close-white" wire:click="closeOrgSelection" @click="document.body.style.overflow = 'auto'"></button>
			</div>
			<div class="modal-body">
				<p class="text-muted mb-3">Select which Zoho Books organization(s) to create this customer in:</p>
				
				@if($zohoMessage && $zohoMessageType)
					<div class="alert alert-{{ $zohoMessageType }} py-2">{{ $zohoMessage }}</div>
				@endif

				<div class="list-group">
					@foreach($zohoOrganizations as $org)
						<label class="list-group-item list-group-item-action d-flex align-items-center gap-3" style="cursor: pointer;">
							<input 
								type="checkbox" 
								class="form-check-input flex-shrink-0" 
								value="{{ $org['organization_id'] }}"
								wire:model.live="selectedOrgs"
								style="margin: 0;"
							>
							<div class="flex-grow-1">
								<strong>{{ $org['name'] }}</strong>
								@if(!empty($org['currency_code']))
									<span class="badge bg-secondary ms-2">{{ $org['currency_code'] }}</span>
								@endif
								@if(!empty($org['country']))
									<br><small class="text-muted">{{ $org['country'] }}</small>
								@endif
							</div>
						</label>
					@endforeach
				</div>

				@if(count($selectedOrgs) > 0)
					<div class="mt-3 text-muted small">
						<i class="fas fa-check-circle text-success me-1"></i>
						{{ count($selectedOrgs) }} organization(s) selected
					</div>
				@endif
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" wire:click="closeOrgSelection" @click="document.body.style.overflow = 'auto'">
					Cancel
				</button>
				<button 
					type="button" 
					class="btn btn-success" 
					wire:click="confirmSendToZoho"
					wire:loading.attr="disabled"
					@disabled(empty($selectedOrgs))
				>
					<span wire:loading wire:target="confirmSendToZoho" class="spinner-border spinner-border-sm me-1"></span>
					<i class="fas fa-cloud-upload-alt me-1" wire:loading.remove wire:target="confirmSendToZoho"></i>
					Create in Zoho
				</button>
			</div>
		</div>
	</div>
	</div>
</template>
@endif

@script
<script>
	// Handle Zoho OAuth popup
	window.addEventListener('open-zoho-oauth-popup', event => {
		const popup = window.open(event.detail.url, 'Zoho OAuth', 'width=600,height=600');
		
		// Poll to check if popup is closed
		const checkClosed = setInterval(() => {
			if (popup.closed) {
				clearInterval(checkClosed);
				// Refresh Zoho connection status
				$wire.checkZohoConnection();
			}
		}, 1000);
	});
</script>
@endscript
</div>
