<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" >
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>
        <link rel="icon" type="image/x-icon" href="/whitelogotrans.png">

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

        @livewireStyles
        @livewireScripts

        @vite(['resources/sass/app.scss', 'resources/js/app.js'])


        <script src="https://kit.fontawesome.com/2d49de291b.js" crossorigin="anonymous"></script>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">

        <script src="/multiple-select.js" defer></script>

        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>



        <script>

            function printDiv(divName){
                var printContents = document.getElementById(divName).innerHTML;
                var originalContents = document.body.innerHTML;

                document.body.innerHTML = printContents;

                window.print();

                document.body.innerHTML = originalContents;

            }
            function copyToClipboard(id) {
                var copyText = "https://knit.roberttodds.com/pricing?goTo=" + id;
                navigator.clipboard.writeText(copyText);
            }

            function getContentAreaHeight() {
                const titleBar = document.getElementById('title-bar');
                const footer = document.getElementById('footer');

                console.log('adjustContentAreaHeight Done')

                if (titleBar && footer) {
                    const totalHeight = titleBar.offsetHeight + footer.offsetHeight;
                    return window.innerHeight - totalHeight - 70;
                }
                else{
                    return 500;
                }
            }

            function adjustContentAreaHeight() {
                const titleBar = document.getElementById('title-bar');
                const footer = document.getElementById('footer');
                const contentArea = document.getElementById('content-area');

                console.log('adjustContentAreaHeight Done')

                if (titleBar && footer && contentArea) {
                    const totalHeight = titleBar.offsetHeight + footer.offsetHeight;
                    contentArea.style.height = `calc(100vh - ${totalHeight}px - 10px - 1rem)`;
                }
            }
            function adjustColumnSelectorMenuWidth() {
                const button = document.getElementById('column-selector-button');
                const menu = document.getElementById('column-selector-menu');

                if (button && menu) {
                    const buttonWidth = button.offsetWidth; // Get the button's width including padding and border
                    menu.style.minWidth = buttonWidth + 'px'; // Set the menu's min-width to match the button
                }
            }

        </script>

        @stack('script-head')
        @stack('styles')


        @if(auth()->user()->setting('open-dyslexia') == TRUE)
            <style>
                *{
                    font-family: 'opendyslexic';
                    font-size: 0.995em;
                }
            </style>
        @endif

    </head>
    <body class="font-sans bg-white">
        <x-christmas-lights class="no-sidebar" />

        <div class="p-0">
            <div class="container-fluid" style="display: flex; flex-flow: column; height: 100vh;">
                <div class="row">
                    <div class="col">
                        <div id="flash-message-container">
                            @if (session()->has('flash-message'))
                                <div class="alert alert-{{ session('flash-message.type') }}">
                                    {{ session('flash-message.message') }}
                                </div>
                                {{ session()->forget('flash-message') }}
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col px-0">
                        {{ $slot }}
                    </div>
                </div>
            </div>
        </div>
    </body>


    @stack('script-end')

</html>
