<x-app-layout>
    <div class="wdash">
        {{-- Hero Section with Filters --}}
        @livewire('dashboard.dashboard-filters')

        {{-- Stats Grid --}}
        @livewire('dashboard.dashboard-metrics')

        {{-- Main Dashboard Grid --}}
        <div class="wdash-main-grid">
            {{-- Customer Sales Progress --}}
            <div class="wdash-card">
                @livewire('dashboard.customer-sales-by-department')
            </div>

            {{-- Garments Due Chart --}}
            <div class="wdash-card">
                @livewire('dashboard.garments-due-chart')
            </div>

            {{-- Unconfirmed Prices --}}
            <div class="wdash-card">
                @livewire('dashboard.unconfirmed-prices')
            </div>

            {{-- Shipments Leaving This Week - Admin Only --}}
            @php
                $rtTeam = \App\Models\Team::find(1);
                $isAdmin = $rtTeam && auth()->user()->hasTeamRole($rtTeam, 'admin');
            @endphp
            @if($isAdmin)
                <div class="wdash-card">
                    @livewire('dashboard.shipments-leaving-this-week')
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
