@props(['name', 'title', 'size'])
<div
	x-data = "{ show : false, name : '{{$name}}'}"
	x-show = "show"
	x-on:open-modal.window = "show = ($event.detail.name === name)"
	x-on:close-modal.window = "show = false"
	x-on:keydown.escape.window = "show = false"
	style="display: none">

	<div style="inset: 0px; position: fixed; width: 100vw; height: 100vh; padding: 50px; background-color: rgba(0, 0, 0, 0.6); z-index: 1001;" tabindex="0">
		<div class="modal" style="display: block" tabindex="-1">
			<div class="modal-dialog @isset($size) {{$size}} @else modal-xl @endisset" style="height: unset; width: unset">
				<div class="modal-content rounded-0" style="filter: drop-shadow(0px 0px 5px var(--bs-primary))">
					<div class="modal-header">
						<h5 class="modal-title" id="newModalLabel">@isset($title) {{$title}} @endisset</h5>
						<button type="button" class="btn-close" x-on:click="show = false" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()"></button>
					</div>
					<div class="modal-body p-0">
						{{$body}}
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
