@props(['name', 'title'])
<div
	x-data = "{ show : false, name : '{{$name}}'}"
	x-show = "show"
	x-on:open-mini-modal.window = "show = ($event.detail.name === name)"
	x-on:close-mini-modal.window = "show = false"
	x-on:keydown.escape.window = "show = false"
	style="display: none">
	
	<div style="inset: 0px; position: fixed; width: 100vw; height: 100vh; padding: 50px; background-color: rgba(0, 0, 0, 0.6); z-index: 100;" tabindex="0">
		<div class="modal" style="display: block" tabindex="-1">
			<div class="modal-dialog modal-sm">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="newModalLabel">@isset($title) {{$title}} @endisset</h5>
						<button type="button" class="btn-close" x-on:click="show = false" wire:click="$dispatch('close-mini-modal')"></button>
					</div>
					{{$body}}
				</div>
			</div>
		</div>
	</div>
</div>