<tr wire:key="{{ $design->id }}">
    @foreach ($columns as $column)
        @if ($column['visible'])
            <td @class([
                'bg-white' => true,
                'bg-purple' => $column['label'] === 'Factory' && $design->factories->name === 'ABC',
                'bg-red' => $column['label'] === 'Factory' && $design->factories->name !== 'ABC',
                'bg-green' => $column['label'] === 'Description',
                'bg-orange' => $column['label'] === 'Yarn',
            ])>
                @switch($column['label'])
                    @case('Customer')
                        <div class="bg-white">{{ $design->customers->name }}</div>
                        @break
                    @case('Gauge')
                        <div class="bg-white">{{ $design->gauges->gauge }}</div>
                        @break
                    @case('Factory')
                        <div @class([
                            'bg-purple' => $design->factories->name === 'ABC',
                            'bg-red' => $design->factories->name !== 'ABC'
                        ])>
                            {{ $design->factories->name }}
                        </div>
                        @break
                    @case('Date of Issue')
                        <div class="bg-white">{{ $design->issued?->format('d-M-Y') }}</div>
                        @break
                    @case('Description')
                        <div class="bg-green">{{ Str::title($design->description) }}</div>
                        @break
                    @case('ID')
                        <div class="bg-white">{{ $design->id }}</div>
                        @break
                    @case('Yarn')
                        <div class="bg-orange">{{ $design->yarn }}</div>
                        @break
                @endswitch
            </td>
        @endif
    @endforeach

    <td>
        {{-- Action Buttons (Edit, Delete, Restore) --}}
        @can('design:update')
            <button class="btn btn-primary"
                    x-data
                    x-on:click="$dispatch('open-modal', {name:'edit'})"
                    wire:click="$dispatch('edit-design', { id: {{ $design->id }}})">
                Edit
            </button>
        @endcan
    </td>
</tr>
