@props([
    'sample' => null,
    'colourwayId',
    'type',
    'typeName' => '',
    'sampleRequired' => false
])

@php
    $sampleObj = is_array($sample) ? (object) $sample : $sample;
    $status = $sampleObj->status ?? null;
    $dateSent = $sampleObj->date_sent ?? null;
    $dateExpected = $sampleObj->date_expected ?? null;
    $approvedDate = $sampleObj->approved_date ?? null;
    $sampleId = $sampleObj->id ?? null;
    $hasSample = $sampleId !== null;
@endphp

@if($status == "approved")
    {{-- Approved --}}
    <div class="cso-sample-box cso-sample-approved" 
         @can('style:update') wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sampleId }} })" role="button" @endcan
         title="Approved - Click to edit">
        <div class="cso-sample-icon">
            <i class="fas fa-check"></i>
        </div>
        <div class="cso-sample-info">
            <span class="cso-sample-label">Approved</span>
            @if($approvedDate)
                <span class="cso-sample-date">{{ \Carbon\Carbon::parse($approvedDate)->format('d M') }}</span>
            @endif
        </div>
    </div>

@elseif($status == "rejected")
    {{-- Rejected --}}
    <div class="cso-sample-box cso-sample-rejected"
         @can('style:update') wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sampleId }} })" role="button" @endcan
         title="Rejected - Click to edit">
        <div class="cso-sample-icon">
            <i class="fas fa-times"></i>
        </div>
        <div class="cso-sample-info">
            <span class="cso-sample-label">Rejected</span>
        </div>
    </div>

@elseif($dateSent)
    {{-- Sent --}}
    <div class="cso-sample-box cso-sample-sent"
         @can('style:update') wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sampleId }} })" role="button" @endcan
         title="Sent - Click to edit">
        <div class="cso-sample-icon">
            <i class="fas fa-paper-plane"></i>
        </div>
        <div class="cso-sample-info">
            <span class="cso-sample-label">Sent</span>
            <span class="cso-sample-date">{{ \Carbon\Carbon::parse($dateSent)->format('d M') }}</span>
        </div>
    </div>

@elseif($dateExpected)
    {{-- Expected --}}
    <div class="cso-sample-box cso-sample-expected"
         @can('style:update') wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sampleId }} })" role="button" @endcan
         title="Expected - Click to edit">
        <div class="cso-sample-icon">
            <i class="fas fa-clock"></i>
        </div>
        <div class="cso-sample-info">
            <span class="cso-sample-label">Expected</span>
            <span class="cso-sample-date">{{ \Carbon\Carbon::parse($dateExpected)->format('d M') }}</span>
        </div>
    </div>

@elseif($hasSample)
    {{-- Planned (sample exists but no dates) --}}
    <div class="cso-sample-box cso-sample-pending"
         @can('style:update') wire:click="$dispatch('open-sample-edit', { sampleId: {{ $sampleId }} })" role="button" @endcan
         title="Planned - Click to edit">
        <div class="cso-sample-icon">
            <i class="fas fa-hourglass-half"></i>
        </div>
        <div class="cso-sample-info">
            <span class="cso-sample-label">Planned</span>
        </div>
    </div>

@elseif($sampleRequired)
    {{-- Required but not ordered --}}
    <div class="cso-sample-box cso-sample-not-ordered">
        <div class="cso-sample-icon">
            <i class="fas fa-exclamation"></i>
        </div>
        <div class="cso-sample-info">
            <span class="cso-sample-label">Not Ordered</span>
        </div>
    </div>
    @can('style:update')
        <button class="cso-sample-add" wire:click="quickAddSample({{ $colourwayId }}, {{ $type }})" title="Add {{ $typeName }}">
            <i class="fas fa-plus"></i>
        </button>
    @endcan

@else
    {{-- Not required --}}
    <div class="cso-sample-box cso-sample-not-required">
        <div class="cso-sample-icon">
            <i class="fas fa-check"></i>
        </div>
        <div class="cso-sample-info">
            <span class="cso-sample-label">Not Required</span>
        </div>
    </div>
    @can('style:update')
        <button class="cso-sample-add" wire:click="quickAddSample({{ $colourwayId }}, {{ $type }})" title="Add {{ $typeName }}">
            <i class="fas fa-plus"></i>
        </button>
    @endcan
@endif

