@props([
    'title',
    'stats' => [],
    'searchPlaceholder' => 'Search...',
    'searchModel' => 'search',
    'showSearch' => true,
    'createButton' => null,
    'createEvent' => null,
])

<header class="comm-header">
    <div class="comm-header-content">
        {{-- Stats --}}
        <div class="comm-title-section">
            @if(count($stats) > 0)
                <div class="comm-stats">
                    @foreach($stats as $stat)
                        <span class="comm-stat {{ $stat['class'] ?? '' }}">
                            <span class="comm-stat-value">{{ $stat['value'] }}</span>
                            <span class="comm-stat-label">{{ $stat['label'] }}</span>
                        </span>
                    @endforeach
                </div>
            @endif
        </div>
        
        {{-- Search --}}
        @if($showSearch)
            <div class="comm-search-section">
                <div class="comm-search-wrapper">
                    <i class="fas fa-search comm-search-icon"></i>
                    <input 
                        type="text" 
                        class="comm-search-input" 
                        placeholder="{{ $searchPlaceholder }}"
                        wire:model.live.debounce.300ms="{{ $searchModel }}"
                    >
                    @if(isset($this->{$searchModel}) && $this->{$searchModel})
                        <button class="comm-search-clear" wire:click="$set('{{ $searchModel }}', '')">
                            <i class="fas fa-times"></i>
                        </button>
                    @endif
                </div>
            </div>
        @endif

        {{-- Actions --}}
        <div class="comm-actions">
            {{ $actions ?? '' }}
            @if($createButton && $createEvent)
                <button class="comm-create-btn" wire:click="$dispatch('{{ $createEvent }}')">
                    <i class="fas fa-plus"></i>
                    <span>{{ $createButton }}</span>
                </button>
            @endif
        </div>
    </div>
</header>


