@props([
    'hasFilters' => false,
    'activeFiltersCount' => 0,
    'clearAction' => 'clearFilters',
])

<div class="cfilter-bar" x-data="{ showMobile: false }">
    <div class="cfilter-content">
        {{-- Filter Toggle for Mobile --}}
        <button class="cfilter-mobile-toggle" @click="showMobile = !showMobile">
            <i class="fas fa-sliders-h"></i>
            <span>Filters</span>
            @if($activeFiltersCount > 0)
                <span class="cfilter-mobile-count">{{ $activeFiltersCount }}</span>
            @endif
        </button>

        {{-- Filters Container --}}
        <div class="cfilter-items" :class="{ 'show': showMobile }">
            {{ $slot }}
        </div>
        
        {{-- Active Filters Summary & Clear --}}
        @if($hasFilters || $activeFiltersCount > 0)
            <div class="cfilter-active">
                <span class="cfilter-active-count">
                    <i class="fas fa-filter"></i>
                    {{ $activeFiltersCount }} active
                </span>
                <button class="cfilter-clear" wire:click="{{ $clearAction }}">
                <i class="fas fa-times"></i>
                    Clear all
            </button>
            </div>
        @endif
    </div>
</div>
