const form = document.getElementById('gemini-form');
const responseDiv = document.getElementById('gemini-response');

// document.addEventListener('DOMContentLoaded', function() {
//     const form = document.getElementById('gemini-form');
//     const responseDiv = document.getElementById('gemini-response');
        form.addEventListener('submit', async (event) => {
            event.preventDefault();
            const prompt = document.getElementById('gemini-input').value;

            try {
                const response = await fetch('/gemini/generate', { // Use the URL directly
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({ prompt: prompt })
                });

                const data = await response.json();
                responseDiv.innerHTML = data.text;
            } catch (error) {
                console.error('Error:', error);
                responseDiv.innerHTML = 'An error occurred.';
            }
        });
