<?php

namespace App\ValueObjects;

use Illuminate\Support\Collection;

class ZohoInvoice
{
    /* Header-level fields */
    public string $customerName;
    public string $invoiceDate;
    public string $invoicePO;
    public string $invoiceLayout;
    public string $invoiceComments;
    public string $invoiceShippingAddr;
    public string $zohoCustomerTag;
    public string $zohoAccount;
    public string $zohoDepartment;
    public string $zohoFactored;

    /** @var array<int, array>  Each element = one line-item payload array */
    private array $lines = [];

    /** @var array<int, int>  Shipment-line IDs that make up this invoice */
    public array $drops = [];

    /* ---------------------------------------------------------------------
     |  Mutators
     |--------------------------------------------------------------------*/
    public function addLine(array $payload): self
    {
        $this->lines[] = $payload;
        return $this;
    }

    /* ---------------------------------------------------------------------
     |  Accessors
     |--------------------------------------------------------------------*/
    /** Collection of all line items */
    public function lineItems(): Collection
    {
        return collect($this->lines);
    }

    /** Payload expected by Zoho’s POST /invoices endpoint */
    public function toZohoPayload(): array
    {
        return [
            'customer_name'       => $this->customerName,
            'date'                => $this->invoiceDate,
            'reference_number'    => $this->invoicePO,
            'template_name'       => $this->invoiceLayout,
            'notes'               => $this->invoiceComments,
            'shipping_address'    => $this->invoiceShippingAddr,
            'line_items'          => $this->lines,
            // You can add tags / department here if needed
        ];
    }
}
