<?php

namespace App\Support;

use Gemini\Data\Blob;
use Gemini\Data\Part;
use Gemini\Enums\Role;
use Livewire\Wireable;
use Gemini\Data\Content;
use Gemini\Laravel\Facades\Gemini;

class WirableChat implements Wireable
{
    public $history;

    public function __construct($history = [])
    {
        $this->history = $history;
    }

    public function toLivewire()
    {
        return array_map(function ($item) {
            // dd($item->parts);
            return [
                'parts' => array_map(function (Part $part) {
                    return $part->toArray();
                }, $item->parts),
                'role' => $item->role->value,
            ];
        }, $this->history);
    }

    public static function fromLivewire($value)
    {
        $history = array_map(function ($item) {
            return [
                'parts' => array_map(function ($partData) {
                    return new Part(
                        text: $partData['text'] ?? null,
                        inlineData: isset($partData['inlineData']) ? Blob::from($partData['inlineData']) : null
                    );
                }, $item['parts']),
                'role' => Role::from($item['role']),
            ];
        }, $value);

        // Return a new WirableChat instance instead of ChatSession
        return new WirableChat($history);
    }

    public function sendMessage($message)
    {
        $chat = Gemini::chat(config('gemini.models.default'))->startChat(history: $this->history);
        $response = $chat->sendMessage($message);

        // Update the history with the new message and response
        $this->history = $chat->getHistory();

        // Return a new WirableChat instance with the updated history
        return new WirableChat($this->history);
    }

    public function getHistory()
    {
        return $this->history;
    }
}
