<?php

namespace App\Support;

use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;

class StoredUploadedFile extends TemporaryUploadedFile
{
    protected string $filePath;
    protected string $originalName;

    public function __construct(string $filePath, string $originalName)
    {
        $this->filePath = $filePath;
        $this->originalName = $originalName;
    }

    public function getRealPath(): string
    {
        return $this->filePath;
    }

    public function getClientOriginalName(): string
    {
        return $this->originalName;
    }

    public function getClientOriginalExtension(): string
    {
        return pathinfo($this->originalName, PATHINFO_EXTENSION);
    }

    public function getSize(): int
    {
        return file_exists($this->filePath) ? filesize($this->filePath) : 0;
    }

    public function isValid(): bool
    {
        return file_exists($this->filePath);
    }

    public function path(): string
    {
        return $this->filePath;
    }
}











































