<?php

namespace App\Support;

class InvoiceFormatter
{
    /**
     * Replace placeholders like "{line_qty}" with real values.
     *
     * @param  string  $template   e.g. "Qty: {line_qty} pcs"
     * @param  array   $data       ['line_qty' => 150, …]
     * @return string              "Qty: 150 pcs"
     */
    public static function fill(string $template, array $data): string
    {
        return preg_replace_callback(
            '/\{([^}]+)\}/',
            fn ($m) => $data[$m[1]] ?? '',
            $template
        );
    }
}
